/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import javax.xml.namespace.QName;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.util.Collation;
import org.basex.query.util.Err;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.QNmCache;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.list.ByteList;

public final class QNm
extends Item {
    private static final QNmCache CACHE = new QNmCache();
    private byte[] uri;
    private byte[] name;
    private int pref;

    public QNm() {
        super(AtomType.QNM);
        this.name = Token.EMPTY;
    }

    public QNm(byte[] n) {
        super(AtomType.QNM);
        this.name = n;
        this.pref = Token.indexOf(n, 58);
    }

    public QNm(String n) {
        this(Token.token(n));
    }

    public QNm(byte[] n, byte[] u) {
        this(n);
        this.uri(u);
    }

    public QNm(String n, byte[] u) {
        this(Token.token(n), u);
    }

    public QNm(String n, String u) {
        this(Token.token(n), u == null ? null : Token.token(u));
    }

    public QNm(byte[] n, StaticContext sc) {
        this(n);
        this.uri(sc.ns.uri(this.prefix()));
    }

    public QNm(QName qn) {
        this(Token.token(qn.getPrefix().isEmpty() ? qn.getLocalPart() : qn.getPrefix() + ':' + qn.getLocalPart()), Token.token(qn.getNamespaceURI()));
    }

    public void uri(byte[] u) {
        this.uri = u == null ? null : Token.norm(u);
    }

    public byte[] uri() {
        return this.uri == null ? Token.EMPTY : this.uri;
    }

    public boolean hasURI() {
        return this.uri != null;
    }

    @Override
    public byte[] string(InputInfo ii) {
        return this.name;
    }

    public byte[] string() {
        return this.name;
    }

    @Override
    public boolean eq(Item it, Collation coll, InputInfo ii) throws QueryException {
        if (it instanceof QNm) {
            return this.eq((QNm)it);
        }
        throw Err.INVTYPECMP.get(ii, it.type, this.type);
    }

    public boolean eq(QNm n) {
        return n == this || Token.eq(this.uri(), n.uri()) && Token.eq(this.local(), n.local());
    }

    @Override
    public int diff(Item it, Collation coll, InputInfo ii) throws QueryException {
        throw Err.diffError(ii, it, this);
    }

    public boolean hasPrefix() {
        return this.pref != -1;
    }

    public byte[] prefix() {
        return this.pref == -1 ? Token.EMPTY : Token.substring(this.name, 0, this.pref);
    }

    public byte[] local() {
        return this.pref == -1 ? this.name : Token.substring(this.name, this.pref + 1);
    }

    public void set(byte[] n, byte[] u) {
        this.name = n;
        this.pref = Token.indexOf(this.name, 58);
        this.uri = u;
    }

    public byte[] id() {
        return this.uri == null ? this.name : QNm.internal(null, this.local(), this.uri);
    }

    public byte[] prefixId(byte[] ns) {
        if (Token.eq(this.uri(), ns)) {
            return this.local();
        }
        byte[] p = NSGlobal.prefix(this.uri());
        return p.length == 0 ? this.id() : Token.concat(p, Token.token(":"), this.local());
    }

    @Override
    public QName toJava() {
        return new QName(Token.string(this.uri()), Token.string(this.local()), Token.string(this.prefix()));
    }

    @Override
    public int hash(InputInfo ii) {
        return Token.hash(this.local());
    }

    @Override
    public byte[] xdmInfo() {
        return new ByteList().add(this.typeId().bytes()).add(this.uri()).add(0).toArray();
    }

    @Override
    public String toString() {
        return Token.string(this.id());
    }

    public boolean equals(Object obj) {
        return obj.getClass() == QNm.class && this.eq((QNm)obj);
    }

    public int hashCode() {
        return Token.hash(this.id());
    }

    public static QNm get(String local) {
        return CACHE.index(null, Token.token(local), null);
    }

    public static QNm get(byte[] local) {
        return CACHE.index(null, local, null);
    }

    public static QNm get(String local, byte[] uri) {
        return CACHE.index(null, Token.token(local), uri);
    }

    public static QNm get(byte[] local, byte[] uri) {
        return CACHE.index(null, local, uri);
    }

    public static QNm get(String prefix, String local, byte[] uri) {
        return CACHE.index(Token.token(prefix), Token.token(local), uri);
    }

    public static QNm get(String prefix, String local, String uri) {
        return CACHE.index(Token.token(prefix), Token.token(local), Token.token(uri));
    }

    public static QNm get(byte[] prefix, byte[] local, byte[] uri) {
        return CACHE.index(prefix, local, uri);
    }

    public static byte[] internal(byte[] prefix, byte[] local, byte[] uri) {
        int pl;
        int ul = uri == null ? 0 : uri.length;
        int n = pl = prefix == null ? 0 : prefix.length;
        if (ul == 0 && pl == 0) {
            return local;
        }
        int l = (ul == 0 ? 0 : ul + 3) + (pl == 0 ? 0 : pl + 1) + local.length;
        byte[] key = new byte[l];
        int i = 0;
        if (ul != 0) {
            key[i++] = 81;
            key[i++] = 123;
            System.arraycopy(uri, 0, key, i, ul);
            key[i + ul] = 125;
            i += ul + 1;
        }
        if (pl != 0) {
            System.arraycopy(prefix, 0, key, i, pl);
            key[i + pl] = 58;
            i += pl + 1;
        }
        System.arraycopy(local, 0, key, i, local.length);
        return key;
    }
}

