/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import java.util.concurrent.atomic.AtomicInteger;
import org.basex.api.dom.BXNode;
import org.basex.core.MainOptions;
import org.basex.data.MemData;
import org.basex.query.QueryException;
import org.basex.query.iter.AxisIter;
import org.basex.query.iter.AxisMoreIter;
import org.basex.query.iter.NodeSeqBuilder;
import org.basex.query.util.ANodeList;
import org.basex.query.util.Collation;
import org.basex.query.util.DataBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Atts;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public abstract class ANode
extends Item {
    private static final NodeType[] TYPES = new NodeType[]{NodeType.DOC, NodeType.ELM, NodeType.TXT, NodeType.ATT, NodeType.COM, NodeType.PI};
    private static final AtomicInteger ID = new AtomicInteger();
    public final int id = ID.incrementAndGet();
    byte[] val;
    ANode par;

    ANode(NodeType t) {
        super(t);
    }

    @Override
    public final boolean bool(InputInfo ii) {
        return true;
    }

    @Override
    public final byte[] string(InputInfo ii) {
        return this.string();
    }

    public abstract byte[] string();

    @Override
    public final boolean eq(Item it, Collation coll, InputInfo ii) throws QueryException {
        return it.type.isUntyped() ? (coll == null ? Token.eq(this.string(), it.string(ii)) : coll.compare(this.string(), it.string(ii)) == 0) : it.eq(this, coll, ii);
    }

    @Override
    public final int diff(Item it, Collation coll, InputInfo ii) throws QueryException {
        return it.type.isUntyped() ? (coll == null ? Token.diff(this.string(), it.string(ii)) : coll.compare(this.string(), it.string(ii))) : -it.diff(this, coll, ii);
    }

    public abstract ANode copy();

    public abstract ANode deepCopy();

    public DBNode dbCopy(MainOptions opts) {
        MemData md = new MemData(opts);
        new DataBuilder(md).build(this);
        return new DBNode(md);
    }

    public byte[] name() {
        return null;
    }

    public QNm qname() {
        return null;
    }

    public abstract QNm qname(QNm var1);

    public ANode optimize() {
        return this;
    }

    public Atts namespaces() {
        return null;
    }

    public final Atts nsScope() {
        Atts ns = new Atts();
        ANode node = this;
        do {
            Atts n;
            if ((n = node.namespaces()) == null) continue;
            for (int a = n.size() - 1; a >= 0; --a) {
                byte[] key = n.name(a);
                if (ns.contains(key)) continue;
                ns.add(key, n.value(a));
            }
        } while ((node = node.parent()) != null && node.type == NodeType.ELM);
        return ns;
    }

    public final byte[] uri(byte[] pref) {
        Atts at = this.namespaces();
        if (at != null) {
            byte[] s = at.value(pref);
            if (s != null) {
                return s;
            }
            ANode n = this.parent();
            if (n != null) {
                return n.uri(pref);
            }
        }
        return (byte[])(pref.length == 0 ? Token.EMPTY : null);
    }

    public byte[] baseURI() {
        return Token.EMPTY;
    }

    public abstract boolean is(ANode var1);

    public abstract int diff(ANode var1);

    static int diff(ANode node1, ANode node2) {
        ANodeList nl = new ANodeList();
        for (ANode n = node1; n != null; n = n.parent()) {
            if (n == node2) {
                return 1;
            }
            nl.add(n);
        }
        ANode c2 = node2;
        ANode n = node2;
        block1: while ((n = n.parent()) != null) {
            int is = nl.size();
            for (int i = 1; i < is; ++i) {
                ANode c;
                if (n == node1) {
                    return -1;
                }
                if (!nl.get(i).is(n)) continue;
                ANode c1 = nl.get(i - 1);
                AxisMoreIter ir = n.children();
                while ((c = ir.next()) != null) {
                    if (c.is(c1)) {
                        return -1;
                    }
                    if (!c.is(c2)) continue;
                    return 1;
                }
                break block1;
            }
            c2 = n;
        }
        return node1.id - node2.id < 0 ? -1 : 1;
    }

    public ANode finish() {
        return this;
    }

    public abstract ANode parent();

    protected abstract ANode parent(ANode var1);

    public abstract boolean hasChildren();

    public byte[] attribute(String name) {
        return this.attribute(new QNm(name));
    }

    public byte[] attribute(byte[] name) {
        return this.attribute(new QNm(name));
    }

    public byte[] attribute(QNm name) {
        ANode node;
        AxisMoreIter ai = this.attributes();
        do {
            if ((node = ai.next()) != null) continue;
            return null;
        } while (!node.qname().eq(name));
        return node.string();
    }

    public abstract AxisIter ancestor();

    public abstract AxisIter ancestorOrSelf();

    public abstract AxisMoreIter attributes();

    public abstract AxisMoreIter children();

    public abstract AxisIter descendant();

    public abstract AxisIter descendantOrSelf();

    public abstract AxisIter following();

    public abstract AxisIter followingSibling();

    public abstract AxisIter parentIter();

    public final AxisIter preceding() {
        return new AxisIter(){
            private NodeSeqBuilder nc;

            @Override
            public ANode next() {
                if (this.nc == null) {
                    this.nc = new NodeSeqBuilder();
                    ANode n = ANode.this;
                    for (ANode p = n.parent(); p != null; p = p.parent()) {
                        if (n.type != NodeType.ATT) {
                            ANode c;
                            NodeSeqBuilder tmp = new NodeSeqBuilder();
                            AxisMoreIter ai = p.children();
                            while ((c = ai.next()) != null && !c.is(n)) {
                                tmp.add(c.finish());
                                ANode.addDesc(c.children(), tmp);
                            }
                            for (long t = tmp.size() - 1L; t >= 0L; --t) {
                                this.nc.add(tmp.get(t));
                            }
                        }
                        n = p;
                    }
                }
                return this.nc.next();
            }
        };
    }

    public final AxisIter precedingSibling() {
        return new AxisIter(){
            private NodeSeqBuilder nc;
            private long c;

            @Override
            public ANode next() {
                if (this.nc == null) {
                    ANode n;
                    if (ANode.this.type == NodeType.ATT) {
                        return null;
                    }
                    ANode r = ANode.this.parent();
                    if (r == null) {
                        return null;
                    }
                    this.nc = new NodeSeqBuilder();
                    AxisMoreIter ai = r.children();
                    while ((n = ai.next()) != null && !n.is(ANode.this)) {
                        this.nc.add(n.finish());
                    }
                    this.c = this.nc.size();
                }
                return this.c > 0L ? this.nc.get(--this.c) : null;
            }
        };
    }

    public final AxisMoreIter self() {
        return new AxisMoreIter(){
            private boolean more = true;

            @Override
            public boolean more() {
                return this.more;
            }

            @Override
            public ANode next() {
                return (this.more ^= true) ? null : ANode.this;
            }
        };
    }

    static void addDesc(AxisMoreIter ch, NodeSeqBuilder nc) {
        ANode n;
        while ((n = ch.next()) != null) {
            nc.add(n.finish());
            ANode.addDesc(n.children(), nc);
        }
    }

    public int kind() {
        return ANode.kind(this.nodeType());
    }

    public static int kind(NodeType t) {
        switch (t) {
            case DOC: {
                return 0;
            }
            case ELM: {
                return 1;
            }
            case TXT: {
                return 2;
            }
            case ATT: {
                return 3;
            }
            case COM: {
                return 4;
            }
            case PI: {
                return 5;
            }
        }
        return -1;
    }

    public static NodeType type(int k) {
        return TYPES[k];
    }

    @Override
    public final BXNode toJava() {
        return BXNode.get(this.deepCopy());
    }

    public final NodeType nodeType() {
        return (NodeType)this.type;
    }
}

