/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.util.NSGlobal;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public enum ListType implements Type
{
    NMT("NMTOKENS"){

        @Override
        public Value cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return ListType.create(it, ctx, sc, ii, AtomType.NMT);
        }
    }
    ,
    ENT("ENTITIES"){

        @Override
        public Value cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return ListType.create(it, ctx, sc, ii, AtomType.ENT);
        }
    }
    ,
    IDR("IDREFS"){

        @Override
        public Value cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
            return ListType.create(it, ctx, sc, ii, AtomType.IDR);
        }
    };

    private static final ListType[] VALUES;
    private final QNm name;
    private SeqType seq;

    private ListType(String nm) {
        this.name = new QNm(nm, QueryText.XSURI);
    }

    private static Value create(Item it, QueryContext ctx, StaticContext sc, InputInfo ii, AtomType type) throws QueryException {
        byte[][] values = Token.split(Token.norm(it.string(ii)), 32);
        ValueBuilder vb = new ValueBuilder(values.length);
        for (byte[] v : values) {
            vb.add(type.cast(Str.get(v), ctx, sc, ii));
        }
        return vb.value();
    }

    public static ListType find(QNm type) {
        for (ListType t : VALUES) {
            if (!t.name.eq(type)) continue;
            return t;
        }
        return null;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isUntyped() {
        return false;
    }

    @Override
    public boolean isNumberOrUntyped() {
        return false;
    }

    @Override
    public boolean isStringOrUntyped() {
        return false;
    }

    @Override
    public byte[] string() {
        return this.name.string();
    }

    @Override
    public abstract Value cast(Item var1, QueryContext var2, StaticContext var3, InputInfo var4) throws QueryException;

    @Override
    public Value cast(Object o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
        return this.cast(Str.get(o, ctx, ii), ctx, sc, ii);
    }

    @Override
    public Value castString(String o, QueryContext ctx, StaticContext sc, InputInfo ii) throws QueryException {
        return this.cast(o, ctx, sc, ii);
    }

    @Override
    public SeqType seqType() {
        if (this.seq == null) {
            this.seq = SeqType.get((Type)this, SeqType.Occ.ZERO_MORE);
        }
        return this.seq;
    }

    @Override
    public boolean eq(Type t) {
        return this == t;
    }

    @Override
    public final boolean instanceOf(Type t) {
        return this == t;
    }

    @Override
    public Type union(Type t) {
        return this == t ? t : AtomType.ITEM;
    }

    @Override
    public Type intersect(Type t) {
        return this == t ? this : (t.instanceOf(this) ? t : null);
    }

    @Override
    public final boolean isNode() {
        return false;
    }

    @Override
    public Type.ID id() {
        return null;
    }

    @Override
    public boolean nsSensitive() {
        return false;
    }

    @Override
    public String toString() {
        return new TokenBuilder(NSGlobal.prefix(this.name.uri())).add(58).add(this.name.string()).toString();
    }

    static {
        VALUES = ListType.values();
    }
}

