/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import org.basex.data.ExprInfo;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.StaticContext;
import org.basex.query.func.StandardFunc;
import org.basex.query.iter.ValueBuilder;
import org.basex.query.path.Test;
import org.basex.query.util.Err;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Flt;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.Map;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.ListType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class SeqType {
    public static final SeqType EMP = new SeqType(AtomType.ITEM, Occ.ZERO);
    public static final SeqType ITEM = AtomType.ITEM.seqType();
    public static final SeqType ITEM_ZO = new SeqType(AtomType.ITEM, Occ.ZERO_ONE);
    public static final SeqType ITEM_ZM = new SeqType(AtomType.ITEM, Occ.ZERO_MORE);
    public static final SeqType ITEM_OM = new SeqType(AtomType.ITEM, Occ.ONE_MORE);
    public static final SeqType AAT = AtomType.AAT.seqType();
    public static final SeqType AAT_ZO = new SeqType(AtomType.AAT, Occ.ZERO_ONE);
    public static final SeqType AAT_ZM = new SeqType(AtomType.AAT, Occ.ZERO_MORE);
    public static final SeqType BLN = AtomType.BLN.seqType();
    public static final SeqType BLN_ZO = new SeqType(AtomType.BLN, Occ.ZERO_ONE);
    public static final SeqType DBL = AtomType.DBL.seqType();
    public static final SeqType DBL_ZM = new SeqType(AtomType.DBL, Occ.ZERO_MORE);
    public static final SeqType DBL_ZO = new SeqType(AtomType.DBL, Occ.ZERO_ONE);
    public static final SeqType FLT = AtomType.FLT.seqType();
    public static final SeqType DEC_ZO = new SeqType(AtomType.DEC, Occ.ZERO_ONE);
    public static final SeqType ITR = AtomType.ITR.seqType();
    public static final SeqType ITR_ZO = new SeqType(AtomType.ITR, Occ.ZERO_ONE);
    public static final SeqType ITR_ZM = new SeqType(AtomType.ITR, Occ.ZERO_MORE);
    public static final SeqType ITR_OM = new SeqType(AtomType.ITR, Occ.ONE_MORE);
    public static final SeqType BYT_OM = new SeqType(AtomType.BYT, Occ.ONE_MORE);
    public static final SeqType NOD = NodeType.NOD.seqType();
    public static final SeqType NOD_ZO = new SeqType(NodeType.NOD, Occ.ZERO_ONE);
    public static final SeqType NOD_ZM = new SeqType(NodeType.NOD, Occ.ZERO_MORE);
    public static final SeqType QNM = AtomType.QNM.seqType();
    public static final SeqType QNM_ZO = new SeqType(AtomType.QNM, Occ.ZERO_ONE);
    public static final SeqType URI = AtomType.URI.seqType();
    public static final SeqType URI_ZO = new SeqType(AtomType.URI, Occ.ZERO_ONE);
    public static final SeqType URI_ZM = new SeqType(AtomType.URI, Occ.ZERO_MORE);
    public static final SeqType STR = AtomType.STR.seqType();
    public static final SeqType STR_ZO = new SeqType(AtomType.STR, Occ.ZERO_ONE);
    public static final SeqType STR_ZM = new SeqType(AtomType.STR, Occ.ZERO_MORE);
    public static final SeqType NCN_ZO = new SeqType(AtomType.NCN, Occ.ZERO_ONE);
    public static final SeqType DAT = AtomType.DAT.seqType();
    public static final SeqType DAT_ZO = new SeqType(AtomType.DAT, Occ.ZERO_ONE);
    public static final SeqType DTD = AtomType.DTD.seqType();
    public static final SeqType DTD_ZO = new SeqType(AtomType.DTD, Occ.ZERO_ONE);
    public static final SeqType DTM = AtomType.DTM.seqType();
    public static final SeqType DTM_ZO = new SeqType(AtomType.DTM, Occ.ZERO_ONE);
    public static final SeqType TIM = AtomType.TIM.seqType();
    public static final SeqType TIM_ZO = new SeqType(AtomType.TIM, Occ.ZERO_ONE);
    public static final SeqType DUR_ZO = new SeqType(AtomType.DUR, Occ.ZERO_ONE);
    public static final SeqType FUN_OZ = new SeqType(FuncType.ANY_FUN, Occ.ZERO_ONE);
    public static final SeqType FUN_O = FuncType.ANY_FUN.seqType();
    public static final SeqType FUN_ZM = new SeqType(FuncType.ANY_FUN, Occ.ZERO_MORE);
    public static final SeqType BYT_ZM = new SeqType(AtomType.BYT, Occ.ZERO_MORE);
    public static final SeqType ATT = NodeType.ATT.seqType();
    public static final SeqType COM = NodeType.COM.seqType();
    public static final SeqType DOC_O = NodeType.DOC.seqType();
    public static final SeqType DOC_ZO = new SeqType(NodeType.DOC, Occ.ZERO_ONE);
    public static final SeqType DOC_OM = new SeqType(NodeType.DOC, Occ.ONE_MORE);
    public static final SeqType DOC_ZM = new SeqType(NodeType.DOC, Occ.ZERO_MORE);
    public static final SeqType ELM = NodeType.ELM.seqType();
    public static final SeqType ELM_ZM = new SeqType(NodeType.ELM, Occ.ZERO_MORE);
    public static final SeqType NSP = NodeType.NSP.seqType();
    public static final SeqType PI = NodeType.PI.seqType();
    public static final SeqType TXT_ZO = new SeqType(NodeType.TXT, Occ.ZERO_ONE);
    public static final MapType ANY_MAP = new MapType(AtomType.AAT, ITEM_ZM);
    public static final SeqType MAP_ZM = new SeqType(ANY_MAP, Occ.ZERO_MORE);
    public static final SeqType MAP_O = new SeqType(ANY_MAP);
    public static final SeqType HEX = AtomType.HEX.seqType();
    public static final SeqType B64 = AtomType.B64.seqType();
    public static final SeqType B64_ZO = new SeqType(AtomType.B64, Occ.ZERO_ONE);
    public static final SeqType B64_ZM = new SeqType(AtomType.B64, Occ.ZERO_MORE);
    public static final SeqType BIN = AtomType.BIN.seqType();
    public static final SeqType BIN_ZM = new SeqType(AtomType.BIN, Occ.ZERO_MORE);
    public final Type type;
    public final Occ occ;
    private final Test kind;

    private SeqType(Type t, Occ o) {
        this(t, o, null);
    }

    SeqType(Type t) {
        this(t, Occ.ONE);
    }

    private SeqType(Type t, Occ o, Test k) {
        this.type = t;
        this.occ = o;
        this.kind = k;
    }

    public static SeqType get(Type t, Occ o) {
        return o == Occ.ONE ? t.seqType() : (o == Occ.ZERO ? EMP : new SeqType(t, o));
    }

    public static SeqType get(Type t, long o) {
        return SeqType.get(t, o == 0L ? Occ.ZERO : (o == 1L ? Occ.ONE : (o > 1L ? Occ.ONE_MORE : Occ.ZERO_MORE)));
    }

    public static SeqType get(Type t, Occ o, Test k) {
        return k == null ? SeqType.get(t, o) : new SeqType(t, o, k);
    }

    public SeqType withOcc(Occ o) {
        return o == this.occ ? this : SeqType.get(this.type, o, this.kind);
    }

    public boolean instance(Value val) {
        long size = val.size();
        if (!this.occ.check(size)) {
            return false;
        }
        for (long i = 0L; i < size; ++i) {
            if (!this.instance(val.itemAt(i), true)) {
                return false;
            }
            if (i == 0L && val.homogeneous()) break;
        }
        return true;
    }

    private boolean instance(Item it, boolean knd) {
        return this.type instanceof MapType ? it instanceof Map && ((Map)it).hasType((MapType)this.type) : it.type.instanceOf(this.type) && (!knd || this.kind == null || this.kind.eq(it));
    }

    public Value cast(Item it, QueryContext ctx, StaticContext sc, InputInfo ii, ExprInfo e) throws QueryException {
        Item v;
        if (it == null) {
            if (!this.occ.check(0L)) {
                throw Err.INVEMPTYEX.get(ii, e, this);
            }
            return Empty.SEQ;
        }
        if (!this.occ.check(1L)) {
            throw Err.INVCAST.get(ii, it.type, this);
        }
        Value value = v = it.type.eq(this.type) ? it : this.type.cast(it, ctx, sc, ii);
        if (this.kind != null) {
            for (Item i : v) {
                if (this.kind.eq(it)) continue;
                throw Err.castError(ii, this.type, i);
            }
        }
        return v;
    }

    public Value cast(Value val, QueryContext ctx, StaticContext sc, InputInfo ii, ExprInfo e) throws QueryException {
        if (val.size() < 2L) {
            return this.cast(val.isEmpty() ? null : val.itemAt(0L), ctx, sc, ii, e);
        }
        if (!this.occ.check(val.size())) {
            throw Err.INVCAST.get(ii, val.type(), this);
        }
        ValueBuilder vb = new ValueBuilder((int)val.size());
        int i = 0;
        while ((long)i < val.size()) {
            vb.add(this.cast(val.itemAt(i), ctx, sc, ii, e));
            ++i;
        }
        return vb.value();
    }

    public Value treat(Value val, InputInfo ii) throws QueryException {
        if (val.type().instanceOf(this)) {
            return val;
        }
        int size = (int)val.size();
        if (!this.occ.check(size)) {
            throw Err.treatError(ii, this, val);
        }
        if (size == 0) {
            return Empty.SEQ;
        }
        boolean ins = this.instance(val.itemAt(0L), true);
        if (!val.homogeneous()) {
            for (int i = 1; ins && i < size; ++i) {
                ins = this.instance(val.itemAt(i), true);
            }
        }
        if (!ins) {
            throw Err.treatError(ii, this, val);
        }
        return val;
    }

    private Value promote(QueryContext ctx, StaticContext sc, InputInfo ii, Item it, boolean opt) throws QueryException {
        if (this.type instanceof AtomType) {
            Item atom = StandardFunc.atom(it, ii);
            if (atom != it && atom.type.instanceOf(this.type)) {
                return it;
            }
            if (atom.type == AtomType.ATM) {
                if (this.type.nsSensitive()) {
                    if (sc.xquery3()) {
                        throw Err.NSSENS.get(ii, it.type, this.type);
                    }
                    throw Err.treatError(ii, this.withOcc(Occ.ONE), it);
                }
                return this.type.cast(atom, ctx, sc, ii);
            }
            Type at = atom.type;
            Type tt = this.type;
            if (tt == AtomType.DBL && (at.instanceOf(AtomType.FLT) || at.instanceOf(AtomType.DEC))) {
                return Dbl.get(atom.dbl(ii));
            }
            if (tt == AtomType.FLT && at.instanceOf(AtomType.DEC)) {
                return Flt.get(atom.flt(ii));
            }
            if (tt == AtomType.STR && at.instanceOf(AtomType.URI)) {
                return Str.get(atom.string(ii));
            }
        } else if (it instanceof FItem && this.type instanceof FuncType) {
            return ((FItem)it).coerceTo((FuncType)this.type, ctx, ii, opt);
        }
        throw Err.treatError(ii, this.withOcc(Occ.ONE), it);
    }

    public Value promote(QueryContext ctx, StaticContext sc, InputInfo ii, Value val, boolean opt) throws QueryException {
        long n = val.size();
        if (!this.occ.check(n)) {
            throw Err.treatError(ii, this, val);
        }
        if (n == 0L) {
            return Empty.SEQ;
        }
        if (val.isItem()) {
            return this.instance((Item)val, true) ? val : this.promote(ctx, sc, ii, (Item)val, opt);
        }
        ValueBuilder vb = null;
        Item fst = val.itemAt(0L);
        if (!this.instance(fst, true)) {
            vb = new ValueBuilder(new Item[(int)val.size()], 0);
            vb.add(this.promote(ctx, sc, ii, fst, opt));
        } else if (val.homogeneous()) {
            return val;
        }
        int i = 1;
        while ((long)i < n) {
            Item it = val.itemAt(i);
            if (vb != null) {
                vb.add(this.instance(it, true) ? it : this.promote(ctx, sc, ii, it, opt));
            } else if (!this.instance(it, true)) {
                vb = new ValueBuilder(new Item[(int)val.size()], 0);
                for (int j = 0; j < i; ++j) {
                    vb.add(val.itemAt(j));
                }
                vb.add(this.promote(ctx, sc, ii, it, opt));
            }
            ++i;
        }
        return vb != null ? Seq.get(vb.items(), (int)vb.size(), this.type) : val;
    }

    public boolean promotable(SeqType t) {
        if (this.intersect(t) != null) {
            return true;
        }
        if (this.occ.intersect(t.occ) == null) {
            return false;
        }
        Type to = t.type;
        if (to instanceof AtomType) {
            if (this.type.isUntyped()) {
                return !to.nsSensitive();
            }
            return to == AtomType.DBL && (this.couldBe(AtomType.FLT) || this.couldBe(AtomType.DEC)) || to == AtomType.FLT && this.couldBe(AtomType.DEC) || to == AtomType.STR && this.couldBe(AtomType.URI);
        }
        return t.type instanceof FuncType && this.type instanceof FuncType;
    }

    private boolean couldBe(Type o) {
        return this.type.intersect(o) != null;
    }

    public SeqType union(SeqType t) {
        return SeqType.get(this.type == t.type ? this.type : this.type.union(t.type), this.occ.union(t.occ));
    }

    public SeqType intersect(SeqType t) {
        Occ o = this.occ.intersect(t.occ);
        if (o == null) {
            return null;
        }
        Type tp = this.type.intersect(t.type);
        if (tp == null) {
            return null;
        }
        if (this.kind == null || t.kind == null || this.kind.sameAs(t.kind)) {
            return SeqType.get(tp, o, this.kind != null ? this.kind : t.kind);
        }
        Test k = this.kind.intersect(t.kind);
        return k == null ? null : SeqType.get(tp, o, k);
    }

    public long occ() {
        return this.occ == Occ.ZERO ? 0L : (this.occ == Occ.ONE ? 1L : -1L);
    }

    public boolean zeroOrOne() {
        return this.occ.max <= 1;
    }

    public boolean one() {
        return this.occ == Occ.ONE;
    }

    public boolean mayBeZero() {
        return this.occ.min == 0;
    }

    public boolean mayBeNumber() {
        return this.type.isNumber() || AtomType.AAT.instanceOf(this.type);
    }

    public boolean eq(SeqType t) {
        return this.type.eq(t.type) && this.occ == t.occ && (this.kind == null ? t.kind == null : t.kind != null && this.kind.sameAs(t.kind));
    }

    public boolean instanceOf(SeqType t) {
        return (t.type == AtomType.ITEM || this.type.instanceOf(t.type)) && this.occ.instanceOf(t.occ) && (t.kind == null || this.kind != null && this.kind.intersect(t.kind) != null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.occ != Occ.ONE && this.type instanceof FuncType) {
            sb.append('(').append(this.typeString()).append(')');
        } else {
            sb.append(this.typeString());
        }
        if (!(this.type instanceof ListType)) {
            sb.append((Object)this.occ);
        }
        return sb.toString();
    }

    public String typeString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.occ == Occ.ZERO ? "empty-sequence()" : this.type);
        if (this.kind != null) {
            sb.deleteCharAt(sb.length() - 1).append(this.kind).append(')');
        }
        return sb.toString();
    }

    public static enum Occ {
        ZERO(0, 0, ""),
        ZERO_ONE(0, 1, "?"),
        ONE(1, 1, ""),
        ONE_MORE(1, Integer.MAX_VALUE, "+"),
        ZERO_MORE(0, Integer.MAX_VALUE, "*");

        private final String str;
        public final int min;
        public final int max;

        private Occ(int mn, int mx, String s) {
            this.min = mn;
            this.max = mx;
            this.str = s;
        }

        public boolean instanceOf(Occ o) {
            return this.min >= o.min && this.max <= o.max;
        }

        public Occ intersect(Occ other) {
            int mn = Math.max(this.min, other.min);
            int mx = Math.min(this.max, other.max);
            return mx < mn ? null : (mx == 0 ? ZERO : (mn == mx ? ONE : (mx == 1 ? ZERO_ONE : (mn == 0 ? ZERO_MORE : ONE_MORE))));
        }

        public Occ union(Occ other) {
            int mn = Math.min(this.min, other.min);
            int mx = Math.max(this.max, other.max);
            return mx == 0 ? ZERO : (mn == mx ? ONE : (mx == 1 ? ZERO_ONE : (mn == 0 ? ZERO_MORE : ONE_MORE)));
        }

        public boolean check(long c) {
            return (long)this.min <= c && c <= (long)this.max;
        }

        public String toString() {
            return this.str;
        }
    }
}

