/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import java.util.Arrays;
import org.basex.util.list.IntList;

public final class Array {
    public static final int CAPACITY = 8;
    public static final double RESIZE = 1.5;

    private Array() {
    }

    public static byte[][] copyOf(byte[][] array, int size) {
        byte[][] tmp = new byte[size][];
        System.arraycopy(array, 0, tmp, 0, Math.min(size, array.length));
        return tmp;
    }

    public static int[][] copyOf(int[][] array, int size) {
        int[][] tmp = new int[size][];
        System.arraycopy(array, 0, tmp, 0, Math.min(size, array.length));
        return tmp;
    }

    public static String[] copyOf(String[] array, int size) {
        String[] tmp = new String[size];
        System.arraycopy(array, 0, tmp, 0, Math.min(size, array.length));
        return tmp;
    }

    public static <T> T[] add(T[] array, T entry) {
        int s = array.length;
        T[] t = Arrays.copyOf(array, s + 1);
        t[s] = entry;
        return t;
    }

    public static <T> T[] add(T[] array, T[] target, T entry) {
        Array.copy(array, target);
        target[array.length] = entry;
        return target;
    }

    public static int[] add(int[] array, int entry) {
        int s = array.length;
        int[] t = Arrays.copyOf(array, s + 1);
        t[s] = entry;
        return t;
    }

    public static void move(Object array, int pos, int off, int size) {
        System.arraycopy(array, pos, array, pos + off, size);
    }

    public static <T> T[] copy(T[] source, T[] target) {
        System.arraycopy(source, 0, target, 0, source.length);
        return target;
    }

    public static <T> T[] delete(T[] array, int pos) {
        int s = array.length - 1;
        Array.move(array, pos + 1, -1, s - pos);
        return Arrays.copyOf(array, s);
    }

    public static int[] createOrder(byte[][] values, boolean numeric, boolean ascending) {
        IntList il = Array.number(values.length);
        il.sort(values, numeric, ascending);
        return il.toArray();
    }

    public static int[] createOrder(double[] values, boolean ascending) {
        IntList il = Array.number(values.length);
        il.sort(values, ascending);
        return il.toArray();
    }

    public static int[] createOrder(int[] values, boolean ascending) {
        IntList il = Array.number(values.length);
        il.sort(values, ascending);
        return il.toArray();
    }

    private static IntList number(int size) {
        int[] tmp = new int[size];
        for (int i = 0; i < size; ++i) {
            tmp[i] = i;
        }
        return new IntList(tmp);
    }

    public static void reverse(byte[] array) {
        Array.reverse(array, 0, array.length);
    }

    private static void reverse(byte[] array, int pos, int len) {
        int l = pos;
        for (int r = pos + len - 1; l < r; ++l, --r) {
            byte tmp = array[l];
            array[l] = array[r];
            array[r] = tmp;
        }
    }

    public static void reverse(Object[] array, int pos, int len) {
        int l = pos;
        for (int r = pos + len - 1; l < r; ++l, --r) {
            Object tmp = array[l];
            array[l] = array[r];
            array[r] = tmp;
        }
    }

    public static int newSize(int old) {
        return Array.newSize(old, 1.5);
    }

    public static int newSize(int old, double factor) {
        return (int)((double)old * factor) + 1;
    }
}

