/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.util.BitSet;
import java.util.NoSuchElementException;
import org.basex.query.QueryException;
import org.basex.query.ft.FTTokens;
import org.basex.util.ft.FTIterator;
import org.basex.util.list.TokenList;

public final class FTBitapSearch {
    private final FTIterator haystack;
    private final FTTokens needles;
    private final TokenComparator cmp;
    private final BitSet[] masks;
    private final int[] sorted;
    private boolean next;
    private int pos;
    private int match;

    public FTBitapSearch(FTIterator h, FTTokens n, TokenComparator c) {
        int i;
        this.haystack = h;
        this.cmp = c;
        this.needles = n;
        this.sorted = new int[n.size()];
        int count = -1;
        for (i = 0; i < this.sorted.length; ++i) {
            if (n.get(i) == null || n.get(i).isEmpty()) continue;
            this.sorted[++count] = i;
        }
        this.masks = new BitSet[++count];
        for (i = 0; i < count; ++i) {
            for (int j = i; j > 0 && n.get(this.sorted[j]).size() > n.get(this.sorted[j - 1]).size(); --j) {
                int t = this.sorted[j];
                this.sorted[j] = this.sorted[j - 1];
                this.sorted[j - 1] = t;
            }
            this.masks[i] = new BitSet();
            this.masks[i].set(0);
        }
    }

    public boolean hasNext() throws QueryException {
        if (this.masks.length == 0) {
            return false;
        }
        if (this.next) {
            return this.pos >= 0;
        }
        this.next = true;
        while (this.haystack.hasNext()) {
            byte[] current = this.haystack.nextToken();
            ++this.pos;
            boolean matched = false;
            for (int i = 0; i < this.masks.length; ++i) {
                int id = this.sorted[i];
                TokenList n = this.needles.get(id);
                BitSet m = this.masks[id];
                for (int k = n.size(); k >= 1; --k) {
                    m.set(k, m.get(k - 1) && this.cmp.equal(current, n.get(k - 1)));
                }
                if (!m.get(n.size()) || matched) continue;
                this.match = id;
                matched = true;
            }
            if (!matched) continue;
            return true;
        }
        this.pos = -1;
        return false;
    }

    public int next() throws QueryException {
        if (this.hasNext()) {
            this.next = false;
            return this.pos - this.needles.get(this.match).size();
        }
        throw new NoSuchElementException();
    }

    public static interface TokenComparator {
        public boolean equal(byte[] var1, byte[] var2) throws QueryException;
    }
}

