/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.http11;

import com.bradmcevoy.http.ExistingEntityHandler;
import com.bradmcevoy.http.GetableResource;
import com.bradmcevoy.http.HandlerHelper;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Range;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceHandlerHelper;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.exceptions.NotFoundException;
import com.bradmcevoy.http.http11.DefaultMatchHelper;
import com.bradmcevoy.http.http11.Http11ResponseHandler;
import com.bradmcevoy.http.http11.MatchHelper;
import com.bradmcevoy.http.http11.PartialGetHelper;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetHandler
implements ExistingEntityHandler {
    private static final Logger log = LoggerFactory.getLogger(GetHandler.class);
    private final Http11ResponseHandler responseHandler;
    private final HandlerHelper handlerHelper;
    private final ResourceHandlerHelper resourceHandlerHelper;
    private final PartialGetHelper partialGetHelper;
    private final MatchHelper matchHelper;

    public GetHandler(Http11ResponseHandler responseHandler, HandlerHelper handlerHelper, DefaultMatchHelper matchHelper) {
        this.responseHandler = responseHandler;
        this.handlerHelper = handlerHelper;
        this.matchHelper = matchHelper;
        this.resourceHandlerHelper = new ResourceHandlerHelper(handlerHelper, responseHandler);
        this.partialGetHelper = new PartialGetHelper(responseHandler);
    }

    @Override
    public void process(HttpManager manager, Request request, Response response) throws NotAuthorizedException, ConflictException, BadRequestException {
        log.debug("process");
        this.resourceHandlerHelper.process(manager, request, response, this);
    }

    @Override
    public void processResource(HttpManager manager, Request request, Response response, Resource r) throws NotAuthorizedException, ConflictException, BadRequestException {
        manager.onGet(request, response, r, request.getParams());
        this.resourceHandlerHelper.processResource(manager, request, response, r, this, true, request.getParams(), null);
    }

    @Override
    public void processExistingResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, BadRequestException, ConflictException, NotFoundException {
        GetableResource r;
        if (log.isTraceEnabled()) {
            log.trace("process: " + request.getAbsolutePath());
        }
        if (this.checkConditional(r = (GetableResource)resource, request)) {
            if (log.isTraceEnabled()) {
                log.trace("respond not modified with: " + this.responseHandler.getClass().getCanonicalName());
            }
            this.responseHandler.respondNotModified(r, response, request);
            return;
        }
        this.sendContent(manager, request, response, r, request.getParams());
    }

    private boolean checkConditional(GetableResource resource, Request request) {
        if (resource.getMaxAgeSeconds(request.getAuthorization()) == null) {
            log.trace("resource has null max age, so not modified response is disabled");
            return false;
        }
        if (this.checkIfModifiedSince(resource, request)) {
            log.trace("is not modified since");
            return true;
        }
        if (this.matchHelper.checkIfNoneMatch(resource, request)) {
            log.trace("conditional check, if-none-match returned true");
            return true;
        }
        return false;
    }

    private boolean checkIfModifiedSince(GetableResource resource, Request requestInfo) {
        boolean unchangedSince;
        long timeRequestMs;
        log.trace("checkIfModifiedSince");
        Long maxAgeSecs = resource.getMaxAgeSeconds(requestInfo.getAuthorization());
        if (maxAgeSecs == null) {
            log.trace("checkIfModifiedSince: null max age");
            return false;
        }
        log.trace("checkIfModifiedSince with maxAge");
        Date dtRequest = requestInfo.getIfModifiedHeader();
        if (dtRequest == null) {
            log.trace(" no modified date header");
            return false;
        }
        long timeNowMs = System.currentTimeMillis();
        long timeElapsedMs = timeNowMs - (timeRequestMs = dtRequest.getTime() + 1000L);
        long timeElapsed = timeElapsedMs / 1000L;
        if (timeElapsed > maxAgeSecs) {
            log.trace("its been longer then the max age period, so generate fresh response");
            return false;
        }
        Date dtResourceModified = resource.getModifiedDate();
        if (dtResourceModified == null) {
            if (log.isTraceEnabled()) {
                log.trace("no modified date on resource: " + resource.getClass().getCanonicalName());
            }
            return true;
        }
        long resModifiedMs = dtResourceModified.getTime();
        boolean bl = unchangedSince = timeRequestMs >= resModifiedMs;
        if (log.isTraceEnabled()) {
            log.trace("times as long: resource modified " + dtResourceModified.getTime() + " - modified since header: " + dtRequest.getTime());
            log.trace("checkModifiedSince: actual: " + dtResourceModified + " - request:" + dtRequest + " = " + unchangedSince + " (true indicates no change)");
        }
        return unchangedSince;
    }

    @Override
    public String[] getMethods() {
        return new String[]{Request.Method.GET.code, Request.Method.HEAD.code};
    }

    @Override
    public boolean isCompatible(Resource handler) {
        return handler instanceof GetableResource;
    }

    private void sendContent(HttpManager manager, Request request, Response response, GetableResource resource, Map<String, String> params) throws NotAuthorizedException, BadRequestException, NotFoundException {
        try {
            if (request.getMethod().equals((Object)Request.Method.HEAD)) {
                this.responseHandler.respondHead(resource, response, request);
            } else {
                List<Range> ranges = this.partialGetHelper.getRanges(request.getRangeHeader());
                if (ranges != null && ranges.size() > 0) {
                    this.partialGetHelper.sendPartialContent(resource, request, response, ranges, params);
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace("normal content: " + this.responseHandler.getClass().getCanonicalName());
                    }
                    this.responseHandler.respondContent(resource, response, request, params);
                }
            }
        }
        catch (NotFoundException e) {
            throw e;
        }
        catch (NotAuthorizedException notAuthorizedException) {
            throw notAuthorizedException;
        }
        catch (BadRequestException badRequestException) {
            throw badRequestException;
        }
        catch (Throwable e) {
            log.error("Exception sending content for:" + request.getAbsolutePath() + " of resource type: " + resource.getClass().getCanonicalName());
            throw new RuntimeException(e);
        }
    }
}

