/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.webdav;

import com.bradmcevoy.http.webdav.PropPatchRequestParser;
import com.bradmcevoy.http.webdav.PropPatchSaxHandler;
import com.bradmcevoy.io.ReadingException;
import com.bradmcevoy.io.StreamUtils;
import com.bradmcevoy.io.WritingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.namespace.QName;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DefaultPropPatchParser
implements PropPatchRequestParser {
    private static final Logger log = LoggerFactory.getLogger(DefaultPropPatchParser.class);

    @Override
    public PropPatchRequestParser.ParseResult getRequestedFields(InputStream in) {
        log.debug("getRequestedFields");
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            StreamUtils.readTo(in, (OutputStream)bout, false, true);
            byte[] arr = bout.toByteArray();
            return this.parseContent(arr);
        }
        catch (SAXException ex) {
            throw new RuntimeException(ex);
        }
        catch (ReadingException ex) {
            throw new RuntimeException(ex);
        }
        catch (WritingException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private PropPatchRequestParser.ParseResult parseContent(byte[] arr) throws IOException, SAXException {
        if (arr.length > 0) {
            log.debug("processing content");
            ByteArrayInputStream bin = new ByteArrayInputStream(arr);
            XMLReader reader = XMLReaderFactory.createXMLReader();
            PropPatchSaxHandler handler = new PropPatchSaxHandler();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(bin));
            log.debug("toset: " + handler.getAttributesToSet().size());
            return new PropPatchRequestParser.ParseResult(handler.getAttributesToSet(), handler.getAttributesToRemove().keySet());
        }
        log.debug("empty content");
        return new PropPatchRequestParser.ParseResult(new HashMap<QName, String>(), new HashSet<QName>());
    }
}

