/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.webdav;

import com.bradmcevoy.http.AuthenticationService;
import com.bradmcevoy.http.ExistingEntityHandler;
import com.bradmcevoy.http.HttpManager;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceHandlerHelper;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.exceptions.BadRequestException;
import com.bradmcevoy.http.exceptions.ConflictException;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.webdav.DefaultPropPatchParser;
import com.bradmcevoy.http.webdav.PropFindPropertyBuilder;
import com.bradmcevoy.http.webdav.PropFindResponse;
import com.bradmcevoy.http.webdav.PropPatchRequestParser;
import com.bradmcevoy.http.webdav.PropPatchSetter;
import com.bradmcevoy.http.webdav.WebDavResponseHandler;
import com.bradmcevoy.io.ReadingException;
import com.bradmcevoy.io.WritingException;
import com.bradmcevoy.property.DefaultPropertyAuthoriser;
import com.bradmcevoy.property.PropertyAuthoriser;
import com.bradmcevoy.property.PropertyHandler;
import com.ettrema.event.PropPatchEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropPatchHandler
implements ExistingEntityHandler,
PropertyHandler {
    private static final Logger log = LoggerFactory.getLogger(PropPatchHandler.class);
    private final ResourceHandlerHelper resourceHandlerHelper;
    private final PropPatchRequestParser requestParser;
    private final PropPatchSetter patchSetter;
    private final WebDavResponseHandler responseHandler;
    private PropertyAuthoriser permissionService = new DefaultPropertyAuthoriser();

    public PropPatchHandler(ResourceHandlerHelper resourceHandlerHelper, WebDavResponseHandler responseHandler, PropPatchSetter propPatchSetter) {
        this.resourceHandlerHelper = resourceHandlerHelper;
        this.requestParser = new DefaultPropPatchParser();
        this.patchSetter = propPatchSetter;
        this.responseHandler = responseHandler;
    }

    public PropPatchHandler(ResourceHandlerHelper resourceHandlerHelper, PropPatchRequestParser requestParser, PropPatchSetter patchSetter, WebDavResponseHandler responseHandler) {
        this.resourceHandlerHelper = resourceHandlerHelper;
        this.requestParser = requestParser;
        this.patchSetter = patchSetter;
        this.responseHandler = responseHandler;
    }

    @Override
    public String[] getMethods() {
        return new String[]{Request.Method.PROPPATCH.code};
    }

    @Override
    public boolean isCompatible(Resource r) {
        return this.patchSetter.supports(r);
    }

    @Override
    public void process(HttpManager httpManager, Request request, Response response) throws ConflictException, NotAuthorizedException, BadRequestException {
        this.resourceHandlerHelper.process(httpManager, request, response, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, ConflictException, BadRequestException {
        long t = System.currentTimeMillis();
        try {
            manager.onProcessResourceStart(request, response, resource);
            if (this.resourceHandlerHelper.isNotCompatible(resource, request.getMethod()) || !this.isCompatible(resource)) {
                log.debug("resource not compatible. Resource class: " + resource.getClass() + " handler: " + this.getClass());
                this.responseHandler.respondMethodNotImplemented(resource, response, request);
                return;
            }
            AuthenticationService.AuthStatus authStatus = this.resourceHandlerHelper.checkAuthentication(manager, resource, request);
            if (authStatus != null && authStatus.loginFailed) {
                log.debug("authentication failed. respond with: " + this.responseHandler.getClass().getCanonicalName() + " resource: " + resource.getClass().getCanonicalName());
                this.responseHandler.respondUnauthorised(resource, response, request);
                return;
            }
            if (request.getMethod().isWrite && this.resourceHandlerHelper.isLockedOut(request, resource)) {
                response.setStatus(Response.Status.SC_LOCKED);
                return;
            }
            this.processExistingResource(manager, request, response, resource);
        }
        finally {
            t = System.currentTimeMillis() - t;
            manager.onProcessResourceFinish(request, response, resource, t);
        }
    }

    @Override
    public void processExistingResource(HttpManager manager, Request request, Response response, Resource resource) throws NotAuthorizedException, BadRequestException, ConflictException {
        try {
            PropFindResponse resp = this.doPropPatch(request, resource);
            manager.getEventManager().fireEvent(new PropPatchEvent(resource, resp));
            ArrayList<PropFindResponse> responses = new ArrayList<PropFindResponse>();
            responses.add(resp);
            this.responseHandler.respondPropFind(responses, response, request, resource);
        }
        catch (NotAuthorizedException e) {
            this.responseHandler.respondUnauthorised(resource, response, request);
        }
        catch (WritingException ex) {
            throw new RuntimeException(ex);
        }
        catch (ReadingException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public PropFindResponse doPropPatch(Request request, Resource resource) throws NotAuthorizedException, IOException {
        Set<PropertyAuthoriser.CheckResult> errorFields;
        InputStream in = request.getInputStream();
        PropPatchRequestParser.ParseResult parseResult = this.requestParser.getRequestedFields(in);
        Set<QName> allFields = this.getAllFields(parseResult);
        if (log.isTraceEnabled()) {
            log.trace("check permissions with: " + this.permissionService.getClass().getCanonicalName());
        }
        if ((errorFields = this.permissionService.checkPermissions(request, request.getMethod(), PropertyAuthoriser.PropertyPermission.WRITE, allFields, resource)) != null && errorFields.size() > 0) {
            throw new NotAuthorizedException(resource);
        }
        String href = request.getAbsoluteUrl();
        href = PropFindPropertyBuilder.fixUrlForWindows(href);
        PropFindResponse resp = this.patchSetter.setProperties(href, parseResult, resource);
        return resp;
    }

    private Set<QName> getAllFields(PropPatchRequestParser.ParseResult parseResult) {
        HashSet<QName> set = new HashSet<QName>();
        if (parseResult.getFieldsToRemove() != null) {
            set.addAll(parseResult.getFieldsToRemove());
        }
        if (parseResult.getFieldsToSet() != null) {
            set.addAll(parseResult.getFieldsToSet().keySet());
        }
        return set;
    }

    @Override
    public PropertyAuthoriser getPermissionService() {
        return this.permissionService;
    }

    @Override
    public void setPermissionService(PropertyAuthoriser permissionService) {
        this.permissionService = permissionService;
    }

    public static class Fields
    implements Iterable<Field> {
        public final List<Field> removeFields = new ArrayList<Field>();
        public final List<SetField> setFields = new ArrayList<SetField>();

        private int size() {
            return this.removeFields.size() + this.setFields.size();
        }

        @Override
        public Iterator<Field> iterator() {
            ArrayList<Field> list = new ArrayList<Field>(this.removeFields);
            list.addAll(this.setFields);
            return list.iterator();
        }
    }

    public static class SetField
    extends Field {
        public final String value;

        public SetField(String name, String value) {
            super(name);
            this.value = value;
        }
    }

    public static class Field {
        public final String name;
        String namespaceUri;

        public Field(String name) {
            this.name = name;
        }

        public void setNamespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
        }

        public String getNamespaceUri() {
            return this.namespaceUri;
        }
    }
}

