/*
 * Decompiled with CFR 0.152.
 */
package com.bradmcevoy.http.webdav;

import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.Response;
import com.bradmcevoy.http.exceptions.NotAuthorizedException;
import com.bradmcevoy.http.values.ValueAndType;
import com.bradmcevoy.http.values.ValueWriters;
import com.bradmcevoy.http.webdav.PropFindResponse;
import com.bradmcevoy.http.webdav.PropPatchRequestParser;
import com.bradmcevoy.http.webdav.PropPatchSetter;
import com.bradmcevoy.property.PropertySource;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertySourcePatchSetter
implements PropPatchSetter {
    private static final Logger log = LoggerFactory.getLogger(PropertySourcePatchSetter.class);
    private final List<PropertySource> propertySources;
    private final ValueWriters valueWriters;

    public PropertySourcePatchSetter(List<PropertySource> propertySources, ValueWriters valueWriters) {
        this.propertySources = propertySources;
        this.valueWriters = valueWriters;
    }

    public PropertySourcePatchSetter(List<PropertySource> propertySources) {
        this.propertySources = propertySources;
        this.valueWriters = new ValueWriters();
    }

    @Override
    public boolean supports(Resource r) {
        return true;
    }

    @Override
    public PropFindResponse setProperties(String href, PropPatchRequestParser.ParseResult parseResult, Resource r) {
        log.trace("setProperties: resource type: {}", r.getClass());
        HashMap<QName, ValueAndType> knownProps = new HashMap<QName, ValueAndType>();
        EnumMap<Response.Status, List<PropFindResponse.NameAndError>> errorProps = new EnumMap<Response.Status, List<PropFindResponse.NameAndError>>(Response.Status.class);
        for (Map.Entry<QName, String> entry : parseResult.getFieldsToSet().entrySet()) {
            QName name = entry.getKey();
            boolean found = false;
            for (PropertySource source : this.propertySources) {
                PropertySource.PropertyMetaData meta = source.getPropertyMetaData(entry.getKey(), r);
                if (meta == null || meta.isUnknown()) continue;
                found = true;
                if (meta.isWritable()) {
                    Object val = this.parse(name, entry.getValue(), meta.getValueType());
                    try {
                        log.trace("setProperties: name: {} source: {}", (Object)name, source.getClass());
                        source.setProperty(name, val, r);
                        knownProps.put(name, new ValueAndType(null, meta.getValueType()));
                    }
                    catch (NotAuthorizedException e) {
                        log.warn("setProperties: NotAuthorised to write property: {}", (Object)name, (Object)e);
                        this.addErrorProp(errorProps, Response.Status.SC_UNAUTHORIZED, name, "Not authorised");
                    }
                    catch (PropertySource.PropertySetException ex) {
                        log.warn("setProperties: PropertySetException when writing property {}", (Object)name, (Object)ex);
                        this.addErrorProp(errorProps, ex.getStatus(), name, ex.getErrorNotes());
                    }
                    break;
                }
                log.warn("property is not writable in source: " + source.getClass());
                this.addErrorProp(errorProps, Response.Status.SC_FORBIDDEN, name, "Property is read only");
                break;
            }
            if (found) continue;
            log.warn("property not found: " + entry.getKey());
            this.addErrorProp(errorProps, Response.Status.SC_NOT_FOUND, entry.getKey(), "Unknown property");
        }
        if (parseResult.getFieldsToRemove() != null) {
            for (QName name : parseResult.getFieldsToRemove()) {
                boolean found = false;
                for (PropertySource source : this.propertySources) {
                    PropertySource.PropertyMetaData meta = source.getPropertyMetaData(name, r);
                    if (meta == null || meta.isUnknown()) continue;
                    found = true;
                    if (meta.isWritable()) {
                        try {
                            log.trace("clearProperty");
                            source.clearProperty(name, r);
                            knownProps.put(name, new ValueAndType(null, meta.getValueType()));
                        }
                        catch (NotAuthorizedException e) {
                            this.addErrorProp(errorProps, Response.Status.SC_UNAUTHORIZED, name, "Not authorised");
                        }
                        catch (PropertySource.PropertySetException ex) {
                            this.addErrorProp(errorProps, ex.getStatus(), name, ex.getErrorNotes());
                        }
                        break;
                    }
                    log.warn("property is not writable in source: " + source.getClass());
                    this.addErrorProp(errorProps, Response.Status.SC_FORBIDDEN, name, "Property is read only");
                    break;
                }
                if (found) continue;
                log.warn("property not found to remove: " + name);
                this.addErrorProp(errorProps, Response.Status.SC_NOT_FOUND, name, "Unknown property");
            }
        }
        if (log.isDebugEnabled() && errorProps.size() > 0) {
            log.debug("errorProps: " + errorProps.size() + " listing property sources:");
            for (PropertySource s : this.propertySources) {
                log.debug("  source: " + s.getClass().getCanonicalName());
            }
        }
        if (r instanceof CommitableResource) {
            log.trace("resource is commitable, call doCommit");
            CommitableResource cr = (CommitableResource)r;
            cr.doCommit(knownProps, errorProps);
        } else {
            log.trace("resource is not commitable");
        }
        PropFindResponse resp = new PropFindResponse(href, knownProps, errorProps);
        return resp;
    }

    private void addErrorProp(Map<Response.Status, List<PropFindResponse.NameAndError>> errorProps, Response.Status stat, QName name, String err) {
        List<PropFindResponse.NameAndError> list = errorProps.get((Object)stat);
        if (list == null) {
            list = new ArrayList<PropFindResponse.NameAndError>();
            errorProps.put(stat, list);
        }
        PropFindResponse.NameAndError ne = new PropFindResponse.NameAndError(name, err);
        list.add(ne);
    }

    private Object parse(QName key, String value, Class valueType) {
        return this.valueWriters.parse(key, valueType, value);
    }

    public static interface CommitableResource
    extends Resource {
        public void doCommit(Map<QName, ValueAndType> var1, Map<Response.Status, List<PropFindResponse.NameAndError>> var2);
    }
}

