/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xmldb;

import java.util.HashMap;
import org.basex.api.xmldb.BXCollection;
import org.basex.api.xmldb.BXResourceSet;
import org.basex.api.xmldb.BXXMLDBText;
import org.basex.api.xmldb.BXXMLResource;
import org.basex.core.Proc;
import org.basex.data.Nodes;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.util.Token;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XPathQueryService;

final class BXQueryService
implements XPathQueryService,
BXXMLDBText {
    static final String XPATH = "XPathQueryService";
    static final String XQUERY = "XQueryQueryService";
    private final HashMap<String, String> ns = new HashMap();
    private final String name;
    private final String version;
    private BXCollection coll;

    BXQueryService(BXCollection c, String n, String v) {
        this.coll = c;
        this.name = n;
        this.version = v;
    }

    public void setNamespace(String pre, String uri) throws XMLDBException {
        if (uri == null || uri.isEmpty()) {
            throw new XMLDBException(1, "Namespace URI is empty: " + pre);
        }
        this.ns.put(pre == null ? "" : pre, uri);
    }

    public String getNamespace(String pre) {
        return this.ns.get(pre == null ? "" : pre);
    }

    public void removeNamespace(String pre) {
        this.ns.remove(pre == null ? "" : pre);
    }

    public void clearNamespaces() {
        this.ns.clear();
    }

    public BXResourceSet query(String query) throws XMLDBException {
        return this.query(this.coll.ctx.current(), query);
    }

    public BXResourceSet queryResource(String id, String query) throws XMLDBException {
        BXXMLResource xml = this.coll.getResource(id);
        if (xml != null) {
            return this.query(new Nodes(xml.pos, xml.data), query);
        }
        throw new XMLDBException(1, "Resource not found: " + id);
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setCollection(Collection col) {
        this.coll = (BXCollection)col;
    }

    public String getProperty(String nm) {
        return null;
    }

    public void setProperty(String nm, String value) throws XMLDBException {
        throw new XMLDBException(1, "Property could not be set: " + nm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BXResourceSet query(Nodes nodes, String query) throws XMLDBException {
        BXResourceSet i$;
        QueryProcessor qp = new QueryProcessor(query, this.coll.ctx).context(nodes);
        qp.parse();
        try {
            this.coll.ctx.register((Proc)qp);
            for (String n : this.ns.keySet()) {
                qp.sc.ns.add(Token.token((String)n), Token.token((String)this.ns.get(n)), null);
            }
            i$ = new BXResourceSet(qp.execute(), this.coll);
        }
        catch (Throwable throwable) {
            try {
                qp.close();
                this.coll.ctx.unregister((Proc)qp);
                throw throwable;
            }
            catch (QueryException ex) {
                throw new XMLDBException(1, ex.getMessage());
            }
        }
        qp.close();
        this.coll.ctx.unregister((Proc)qp);
        return i$;
    }
}

