/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xmldb;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.basex.api.dom.BXDoc;
import org.basex.api.xmldb.BXXMLDBText;
import org.basex.build.Builder;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.build.xml.SAXHandler;
import org.basex.core.BaseXException;
import org.basex.core.MainOptions;
import org.basex.data.Data;
import org.basex.data.Result;
import org.basex.io.IOFile;
import org.basex.io.in.ArrayInput;
import org.basex.io.out.ArrayOutput;
import org.basex.io.parse.xml.XmlParser;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.XMLSerializer;
import org.basex.query.QueryIOException;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.util.Token;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.XMLResource;

final class BXXMLResource
implements XMLResource,
BXXMLDBText {
    private final Collection coll;
    private String id;
    private Result result;
    Object content;
    Data data;
    int pos;

    BXXMLResource(byte[] d, Collection c) {
        this.content = d;
        this.coll = c;
    }

    BXXMLResource(Result res, int p, Collection c) {
        this.result = res;
        this.coll = c;
        this.pos = p;
    }

    BXXMLResource(Data d, int p, String i, Collection c) {
        this.id = i;
        this.coll = c;
        this.data = d;
        this.pos = p;
    }

    public Collection getParentCollection() {
        return this.coll;
    }

    public String getId() {
        return this.id;
    }

    public String getResourceType() {
        return "XMLResource";
    }

    public Object getContent() throws XMLDBException {
        if (this.content == null) {
            try {
                ArrayOutput ao = new ArrayOutput();
                XMLSerializer ser = Serializer.get((OutputStream)ao);
                if (this.data != null) {
                    ser.serialize((Item)new DBNode(this.data, this.pos));
                } else if (this.result != null) {
                    this.result.serialize((Serializer)ser, this.pos);
                } else {
                    return null;
                }
                this.content = ao.toArray();
            }
            catch (IOException ex) {
                throw new XMLDBException(1, ex.getMessage());
            }
        }
        return this.content instanceof byte[] ? Token.string((byte[])((byte[])this.content)) : this.content;
    }

    public void setContent(Object value) throws XMLDBException {
        if (value instanceof byte[]) {
            this.content = value;
        } else if (value instanceof String) {
            this.content = Token.token((String)value.toString());
        } else if (value instanceof File) {
            try {
                this.content = new IOFile((File)value).read();
            }
            catch (IOException ex) {
                throw new XMLDBException(1, "Content cannot be set.\n" + ex.getMessage());
            }
        } else {
            throw new XMLDBException(1, "Content cannot be set.");
        }
    }

    public String getDocumentId() throws XMLDBException {
        if (this.result != null) {
            throw new XMLDBException(1, "Document ID cannot be retrieved from query result.");
        }
        if (this.id != null) {
            return this.id;
        }
        int p = this.pos;
        while (p >= 0) {
            int k = this.data.kind(p);
            if (k == 0) {
                return Token.string((byte[])this.data.text(p, true));
            }
            p = this.data.parent(p, k);
        }
        return null;
    }

    public Node getContentAsDOM() {
        if (!(this.content instanceof Node)) {
            this.content = new BXDoc((ANode)new DBNode(this.data, this.pos));
        }
        return (Node)this.content;
    }

    public void setContentAsDOM(Node cont) throws XMLDBException {
        if (cont == null) {
            throw new XMLDBException(301);
        }
        if (!(cont instanceof Document)) {
            throw new XMLDBException(3);
        }
        this.content = cont;
    }

    public void getContentAsSAX(ContentHandler handler) throws XMLDBException {
        if (handler == null) {
            throw new XMLDBException(301);
        }
        try {
            new XmlParser().contentHandler(handler).parse((InputStream)new ArrayInput(this.getContent().toString()));
        }
        catch (Exception pce) {
            throw new XMLDBException(1, pce.getMessage());
        }
    }

    public ContentHandler setContentAsSAX() {
        MemBuilder mb = new MemBuilder("", Parser.emptyParser((MainOptions)new MainOptions()));
        mb.init();
        return new BXSAXContentHandler(this, mb);
    }

    private static final class BXSAXContentHandler
    extends SAXHandler {
        private final BXXMLResource res;

        BXSAXContentHandler(BXXMLResource r, MemBuilder mb) {
            super((Builder)mb, false, false);
            this.res = r;
        }

        public void endDocument() throws SAXException {
            try {
                this.res.content = new DBNode(((MemBuilder)this.builder).data()).serialize().toArray();
            }
            catch (QueryIOException ex) {
                BXSAXContentHandler.error((IOException)((Object)new BaseXException((Exception)((Object)ex))));
            }
        }
    }
}

