/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.basex.core.GlobalOptions;
import org.basex.core.ProcException;
import org.basex.core.Text;
import org.basex.http.HTTPContext;
import org.basex.http.HTTPException;
import org.basex.http.restxq.RestXqServlet;
import org.basex.query.QueryException;
import org.basex.server.LoginException;
import org.basex.util.Prop;
import org.basex.util.Util;

public abstract class BaseXServlet
extends HttpServlet {
    String user;
    String pass;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            HTTPContext.init(config.getServletContext());
            Enumeration en = config.getInitParameterNames();
            while (en.hasMoreElements()) {
                String key = ((String)en.nextElement()).toLowerCase(Locale.ENGLISH);
                String val = config.getInitParameter(key);
                if (key.startsWith("org.basex.")) {
                    key = key.substring("org.basex.".length());
                }
                if (key.equalsIgnoreCase(GlobalOptions.USER.name())) {
                    this.user = val;
                    continue;
                }
                if (!key.equalsIgnoreCase(GlobalOptions.PASSWORD.name())) continue;
                this.pass = val;
            }
        }
        catch (IOException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void service(HttpServletRequest req, HttpServletResponse res) throws IOException {
        HTTPContext http = new HTTPContext(req, res, this);
        boolean restxq = this instanceof RestXqServlet;
        try {
            this.run(http);
            http.log("", 200);
        }
        catch (HTTPException ex) {
            http.status(ex.getStatus(), Util.message((Throwable)ex), restxq);
        }
        catch (LoginException ex) {
            http.status(401, Util.message((Throwable)ex), restxq);
        }
        catch (IOException ex) {
            http.status(400, Util.message((Throwable)ex), restxq);
        }
        catch (ProcException ex) {
            http.status(400, Text.INTERRUPTED, restxq);
        }
        catch (QueryException ex) {
            http.status(400, Util.message((Throwable)ex), restxq);
        }
        catch (Exception ex) {
            String msg = Util.bug((Throwable)ex);
            Util.errln((Object)msg, (Object[])new Object[0]);
            http.status(500, Util.info((Object)"Unexpected error: %", (Object[])new Object[]{msg}), restxq);
        }
        finally {
            if (Prop.debug) {
                Util.outln((Object)("_ REQUEST _________________________________" + Prop.NL + req), (Object[])new Object[0]);
                Enumeration en = req.getHeaderNames();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    Util.outln((Object)("- " + key + ": " + req.getHeader(key)), (Object[])new Object[0]);
                }
                Util.out((Object)("_ RESPONSE ________________________________" + Prop.NL + res), (Object[])new Object[0]);
            }
        }
    }

    protected abstract void run(HTTPContext var1) throws Exception;
}

