/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.basex.BaseXServer;
import org.basex.build.JsonOptions;
import org.basex.build.JsonSerialOptions;
import org.basex.core.Context;
import org.basex.core.GlobalOptions;
import org.basex.data.DataText;
import org.basex.http.BaseXServlet;
import org.basex.http.HTTPParams;
import org.basex.io.IOFile;
import org.basex.io.serial.SerialMethod;
import org.basex.io.serial.SerializerOptions;
import org.basex.server.Log;
import org.basex.server.LoginException;
import org.basex.util.Base64;
import org.basex.util.Performance;
import org.basex.util.Prop;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.StringList;
import org.basex.util.options.Option;
import org.basex.util.options.Options;

public final class HTTPContext {
    public final HttpServletRequest req;
    public final HttpServletResponse res;
    public final String method;
    public final HTTPParams params;
    private SerializerOptions sopts;
    public boolean wrapping;
    public String user;
    public String pass;
    private static Context context;
    private static boolean init;
    private final Performance perf = new Performance();
    private final String[] segments;

    public HTTPContext(HttpServletRequest rq, HttpServletResponse rs, BaseXServlet servlet) throws IOException {
        this.req = rq;
        this.res = rs;
        this.params = new HTTPParams(this);
        this.method = rq.getMethod();
        StringBuilder uri = new StringBuilder(this.req.getRequestURL());
        String qs = this.req.getQueryString();
        if (qs != null) {
            uri.append('?').append(qs);
        }
        this.log('[' + this.method + "] " + uri, null);
        this.res.setCharacterEncoding("UTF-8");
        this.segments = HTTPContext.decode(HTTPContext.toSegments(this.req.getPathInfo()));
        GlobalOptions mprop = this.context().globalopts;
        this.user = servlet.user != null ? servlet.user : mprop.get(GlobalOptions.USER);
        this.pass = servlet.pass != null ? servlet.pass : mprop.get(GlobalOptions.PASSWORD);
        String auth = this.req.getHeader("Authorization");
        if (auth != null) {
            String[] values = auth.split(" ");
            if (values[0].equals("Basic")) {
                String[] cred = Base64.decode((String)values[1]).split(":", 2);
                if (cred.length != 2) {
                    throw new LoginException("No username/password specified.", new Object[0]);
                }
                this.user = cred[0];
                this.pass = cred[1];
            } else {
                throw new LoginException("Unsupported Authorization method: %.", new Object[]{values[0]});
            }
        }
    }

    public String contentType() {
        String ct = this.req.getContentType();
        return ct != null ? ct.replaceFirst(";.*", "") : null;
    }

    public String contentTypeExt() {
        String ct = this.req.getContentType();
        return ct != null ? ct.replaceFirst("^.*?;\\s*", "") : null;
    }

    public void initResponse() {
        SerializerOptions opts = this.sopts();
        String enc = opts.get(SerializerOptions.ENCODING);
        this.res.setCharacterEncoding(enc);
        String ct = HTTPContext.mediaType(opts);
        this.res.setContentType(new TokenBuilder(ct).add(DataText.CHARSET).add(enc).toString());
    }

    public static String mediaType(SerializerOptions sopts) {
        String type = sopts.get(SerializerOptions.MEDIA_TYPE);
        if (!type.isEmpty()) {
            return type;
        }
        SerialMethod sm = (SerialMethod)sopts.get(SerializerOptions.METHOD);
        if (sm == SerialMethod.RAW) {
            return "application/octet-stream";
        }
        if (sm == SerialMethod.XML) {
            return "application/xml";
        }
        if (sm == SerialMethod.XHTML || sm == SerialMethod.HTML) {
            return "text/html";
        }
        if (sm == SerialMethod.JSON) {
            JsonSerialOptions jprop = (JsonSerialOptions)sopts.get(SerializerOptions.JSON);
            return jprop.get(JsonOptions.FORMAT) == JsonOptions.JsonFormat.JSONML ? "application/jsonml+json" : "application/json";
        }
        return "text/plain";
    }

    public int depth() {
        return this.segments.length;
    }

    public String segment(int i) {
        return this.segments[i];
    }

    public String dbpath() {
        TokenBuilder tb = new TokenBuilder();
        int ps = this.segments.length;
        for (int p = 1; p < ps; ++p) {
            if (!tb.isEmpty()) {
                tb.add(47);
            }
            tb.add(this.segments[p]);
        }
        return tb.toString();
    }

    public String db() {
        return this.depth() == 0 ? null : this.segments[0];
    }

    public String[] produces() {
        String accept = this.req.getHeader("Accept");
        if (accept == null) {
            return new String[0];
        }
        String[] acc = accept.split("\\s*,\\s*");
        int as = acc.length;
        for (int a = 0; a < as; ++a) {
            if (acc[a].indexOf(59) == -1) continue;
            acc[a] = acc[a].replaceAll("\\w*;.*", "");
        }
        return acc;
    }

    public void status(int code, String message, boolean error) throws IOException {
        try {
            this.log(message, code);
            this.res.resetBuffer();
            if (code == 401) {
                this.res.setHeader("WWW-Authenticate", "Basic");
            }
            if (error && code >= 400) {
                this.res.sendError(code, message);
            } else {
                this.res.setStatus(code);
                if (message != null) {
                    this.res.getOutputStream().write(Token.token((String)message));
                }
            }
        }
        catch (IllegalStateException ex) {
            this.log(Util.message((Throwable)ex), 500);
        }
    }

    public void credentials(String u, String p) {
        this.user = u;
        this.pass = p;
    }

    public Context authenticate() throws LoginException {
        byte[] address = Token.token((String)this.req.getRemoteAddr());
        try {
            if (this.user == null || this.user.isEmpty() || this.pass == null || this.pass.isEmpty()) {
                throw new LoginException("No username/password specified.", new Object[0]);
            }
            Context ctx = new Context(this.context(), null);
            ctx.user = ctx.users.get(this.user);
            if (ctx.user == null || !ctx.user.password.equals(Token.md5((String)this.pass))) {
                throw new LoginException();
            }
            HTTPContext.context.blocker.remove(address);
            return ctx;
        }
        catch (LoginException ex) {
            for (int d = HTTPContext.context.blocker.delay(address); d > 0; --d) {
                Performance.sleep((long)100L);
            }
            throw ex;
        }
    }

    public Context context() {
        return context;
    }

    public void sopts(SerializerOptions opts) {
        this.sopts = opts;
    }

    public SerializerOptions sopts() {
        if (this.sopts == null) {
            this.sopts = new SerializerOptions();
        }
        return this.sopts;
    }

    public void log(String info, Object type) {
        Object[] objectArray;
        Log log = HTTPContext.context.log;
        if (type != null) {
            Object[] objectArray2 = new Object[5];
            objectArray2[0] = this.address();
            objectArray2[1] = HTTPContext.context.user.name;
            objectArray2[2] = type;
            objectArray2[3] = info;
            objectArray = objectArray2;
            objectArray2[4] = this.perf;
        } else {
            Object[] objectArray3 = new Object[4];
            objectArray3[0] = this.address();
            objectArray3[1] = HTTPContext.context.user.name;
            objectArray3[2] = null;
            objectArray = objectArray3;
            objectArray3[3] = info;
        }
        log.write(objectArray);
    }

    public static synchronized Context init() {
        if (context == null) {
            context = new Context();
        }
        return context;
    }

    public static synchronized void init(ServletContext sc) throws IOException {
        if (init) {
            return;
        }
        init = true;
        String webapp = sc.getRealPath("/");
        Options.setSystem((String)"org.basex.path", (Object)webapp);
        Options.setSystem((Option)GlobalOptions.WEBPATH, (Object)webapp);
        Enumeration en = sc.getInitParameterNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            if (!key.startsWith("org.basex.")) continue;
            String val = sc.getInitParameter(key);
            String k = key;
            String v = val;
            if (key.equals("org.basex.httppath")) {
                k = "org.basex." + GlobalOptions.RESTXQPATH.name();
            } else if (key.equals("org.basex.mode")) {
                k = "org.basex." + GlobalOptions.HTTPLOCAL.name();
                v = Boolean.toString("local".equals(v));
            } else if (key.equals("org.basex.server")) {
                k = "org.basex." + GlobalOptions.HTTPLOCAL.name();
                v = Boolean.toString(!Boolean.parseBoolean(v));
            }
            k = k.toLowerCase(Locale.ENGLISH);
            if (!k.equals(key) || !v.equals(val)) {
                Util.errln((Object)("Warning! Outdated option: " + key + '=' + val + " => " + k + '=' + v), (Object[])new Object[0]);
            }
            if (k.endsWith("path") && !new File(v).isAbsolute()) {
                Util.debug((Object)(k.toUpperCase(Locale.ENGLISH) + ": " + v), (Object[])new Object[0]);
                v = new IOFile(webapp, v).path();
            }
            Options.setSystem((String)k, (Object)v);
        }
        if (context == null) {
            context = new Context(false);
        } else {
            HTTPContext.context.globalopts.setSystem();
            HTTPContext.context.options.setSystem();
        }
        if (!HTTPContext.context.globalopts.get(GlobalOptions.HTTPLOCAL).booleanValue()) {
            new BaseXServer(context, new String[0]);
        }
    }

    public static String[] toSegments(String path) {
        StringList sl = new StringList();
        if (path != null) {
            TokenBuilder tb = new TokenBuilder();
            for (int s = 0; s < path.length(); ++s) {
                char ch = path.charAt(s);
                if (ch == '/') {
                    if (tb.isEmpty()) continue;
                    sl.add(tb.toString());
                    tb.reset();
                    continue;
                }
                tb.add((int)ch);
            }
            if (!tb.isEmpty()) {
                sl.add(tb.toString());
            }
        }
        return sl.toArray();
    }

    public static String[] decode(String[] segments) {
        try {
            int sl = segments.length;
            for (int s = 0; s < sl; ++s) {
                segments[s] = URLDecoder.decode(segments[s], Prop.ENCODING);
            }
            return segments;
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String address() {
        return this.req.getRemoteAddr() + ':' + this.req.getRemotePort();
    }
}

