/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.basex.core.BaseXException;
import org.basex.core.Command;
import org.basex.core.Context;
import org.basex.core.LockResult;
import org.basex.core.MainOptions;
import org.basex.core.Perm;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Cs;
import org.basex.core.cmd.Open;
import org.basex.http.HTTPCode;
import org.basex.http.HTTPContext;
import org.basex.http.HTTPException;
import org.basex.http.rest.RESTSession;
import org.basex.http.rest.RESTText;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.func.Function;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.list.TokenList;

public abstract class RESTCmd
extends Command {
    final RESTSession session;
    final ArrayList<Command> cmds;
    HTTPCode code;

    RESTCmd(RESTSession rs) {
        super(RESTCmd.max(rs.cmds), new String[0]);
        this.cmds = rs.cmds;
        this.session = rs;
    }

    public void databases(LockResult lr) {
        boolean rc;
        for (Command c : this.cmds) {
            c.databases(lr);
        }
        boolean wc = lr.write.contains("%CTX") || lr.write.contains("%COLL");
        boolean bl = rc = lr.read.contains("%CTX") || lr.read.contains("%COLL");
        if (wc || rc && !lr.write.isEmpty()) {
            lr.writeAll = true;
            lr.readAll = true;
        } else if (rc) {
            lr.readAll = true;
        }
    }

    public boolean updating(Context ctx) {
        boolean up = false;
        for (Command c : this.cmds) {
            up |= c.updating(ctx);
        }
        return up;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean run() {
        try {
            this.run0();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            boolean bl = this.error(ex.getMessage(), new Object[0]);
            return bl;
        }
        finally {
            new Close().run(this.context);
        }
    }

    protected abstract void run0() throws IOException;

    final String run(Command c) throws HTTPException {
        ArrayOutput ao = new ArrayOutput();
        this.run(c, (OutputStream)ao);
        return ao.toString();
    }

    final void run(Command c, OutputStream os) throws HTTPException {
        boolean ok = c.run(this.context, os);
        this.error(c.info(), new Object[0]);
        if (!ok) {
            throw HTTPCode.BAD_REQUEST_X.get(c.info());
        }
    }

    static void list(Table table, FElem root, QNm header, int skip) {
        for (TokenList l : table.contents) {
            FElem el = new FElem(header);
            for (int i = 1; i < l.size() - skip; ++i) {
                el.add(new QNm(Token.lc((byte[])table.header.get(i))), l.get(i));
            }
            el.add(l.get(0));
            root.add((ANode)el);
        }
    }

    static void open(RESTSession rs) {
        String db = rs.http.db();
        if (db == null) {
            return;
        }
        String dbpath = rs.http.dbpath();
        rs.add((Command)new Open(db));
        if (!dbpath.isEmpty()) {
            rs.add((Command)new Cs(Function._DB_OPEN.args(new Object[]{db, dbpath})));
        }
    }

    static SerializerOptions serial(HTTPContext http) {
        SerializerOptions sopts = http.sopts();
        if (http.wrapping) {
            sopts.set(SerializerOptions.WRAP_PREFIX, "rest");
            sopts.set(SerializerOptions.WRAP_URI, RESTText.RESTURI);
        }
        return sopts;
    }

    private static Perm max(ArrayList<Command> cmds) {
        Perm p = Perm.NONE;
        for (Command c : cmds) {
            p = p.max(c.perm);
        }
        return p;
    }

    static void parseOptions(RESTSession rs) throws IOException {
        for (Map.Entry<String, String[]> param : rs.http.params.map().entrySet()) {
            RESTCmd.parseOption(rs, param, true);
        }
    }

    static boolean parseOption(RESTSession rs, Map.Entry<String, String[]> param, boolean force) throws BaseXException {
        boolean found;
        MainOptions options = rs.context.options;
        String key = param.getKey().toUpperCase(Locale.ENGLISH);
        boolean bl = found = options.option(key) != null;
        if (found || force) {
            options.assign(key, param.getValue()[0]);
        }
        return found;
    }
}

