/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;
import org.basex.core.Context;
import org.basex.http.HTTPCode;
import org.basex.http.HTTPContext;
import org.basex.http.HTTPException;
import org.basex.http.rest.RESTCmd;
import org.basex.http.rest.RESTCommand;
import org.basex.http.rest.RESTQuery;
import org.basex.http.rest.RESTRun;
import org.basex.http.rest.RESTSchema;
import org.basex.http.rest.RESTSession;
import org.basex.http.rest.RESTText;
import org.basex.io.IO;
import org.basex.io.IOContent;
import org.basex.io.in.ArrayInput;
import org.basex.io.in.NewlineInput;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.query.util.DataBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.util.Token;
import org.basex.util.Util;

final class RESTPost {
    private RESTPost() {
    }

    public static RESTCmd get(RESTSession rs) throws IOException {
        DBNode doc;
        HTTPContext http = rs.http;
        String enc = http.req.getCharacterEncoding();
        if (enc == null) {
            enc = "UTF-8";
        }
        byte[] input = new NewlineInput((InputStream)http.req.getInputStream()).encoding(enc).content();
        RESTPost.validate(input);
        Context ctx = rs.context;
        try {
            doc = new DBNode((IO)new IOContent(input), ctx.options);
        }
        catch (IOException ex) {
            throw HTTPCode.BAD_REQUEST_X.get(ex);
        }
        try {
            String value;
            String name;
            SerializerOptions sopts = http.sopts();
            QueryProcessor qp = new QueryProcessor("*/*:parameter", ctx).context((Object)doc);
            for (Item param : qp.value()) {
                name = RESTPost.value("@name", param, ctx);
                value = RESTPost.value("@value", param, ctx);
                if (sopts.option(name) != null) {
                    sopts.assign(name, value);
                    continue;
                }
                if (name.equals("wrap")) {
                    http.wrapping = Util.yes((String)value);
                    continue;
                }
                throw HTTPCode.UNKNOWN_PARAM_X.get(name);
            }
            qp = new QueryProcessor("*/*:option", ctx).context((Object)doc);
            for (Item it : qp.value()) {
                name = RESTPost.value("@name", it, ctx).toUpperCase(Locale.ENGLISH);
                value = RESTPost.value("@value", it, ctx);
                ctx.options.assign(name, value);
            }
            HashMap<String, String[]> vars = new HashMap<String, String[]>();
            qp = new QueryProcessor("*/*:variable", ctx).context((Object)doc);
            for (Item it : qp.value()) {
                String name2 = RESTPost.value("@name", it, ctx);
                String value2 = RESTPost.value("@value", it, ctx);
                String type = RESTPost.value("@type", it, ctx);
                vars.put(name2, new String[]{value2, type});
            }
            qp = new QueryProcessor("*/*:context/node()", ctx).context((Object)doc);
            String value3 = null;
            for (Item it : qp.value()) {
                if (value3 != null) {
                    throw HTTPCode.MULTIPLE_CONTEXT_X.get(new Object[0]);
                }
                value3 = DataBuilder.stripNS((ANode)((ANode)it), (byte[])Token.token((String)RESTText.RESTURI), (Context)ctx).serialize().toString();
            }
            String request = RESTPost.value("local-name(*)", (Item)doc, ctx);
            String text = RESTPost.value("*/*:text/text()", (Item)doc, ctx);
            if (request.equals("command")) {
                return RESTCommand.get(rs, text);
            }
            if (request.equals("run")) {
                return RESTRun.get(rs, text, vars, value3);
            }
            return RESTQuery.get(rs, text, vars, value3);
        }
        catch (QueryException ex) {
            throw HTTPCode.BAD_REQUEST_X.get(new Object[]{ex});
        }
    }

    private static String value(String query, Item item, Context ctx) throws QueryException {
        QueryProcessor qp = new QueryProcessor(query, ctx).context((Object)item);
        Item it = qp.iter().next();
        return it == null ? null : Token.string((byte[])it.string(null));
    }

    private static void validate(byte[] input) throws HTTPException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            RESTSchema.newValidator().validate(new DOMSource(db.parse((InputStream)new ArrayInput(input))));
        }
        catch (Exception ex) {
            Util.debug((Object)("Error while validating \"" + Token.string((byte[])input) + '\"'), (Object[])new Object[0]);
            throw HTTPCode.BAD_REQUEST_X.get(ex);
        }
    }
}

