/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.basex.core.Command;
import org.basex.core.GlobalOptions;
import org.basex.core.MainOptions;
import org.basex.core.cmd.XQuery;
import org.basex.http.HTTPContext;
import org.basex.http.rest.RESTCmd;
import org.basex.http.rest.RESTSession;
import org.basex.query.value.type.NodeType;
import org.basex.util.options.Options;

class RESTQuery
extends RESTCmd {
    private final Map<String, String[]> variables;
    private final String value;

    RESTQuery(RESTSession rs, Map<String, String[]> vars, String val) {
        super(rs);
        this.variables = vars;
        this.value = val;
    }

    @Override
    protected void run0() throws IOException {
        this.query(this.session.context.globalopts.get(GlobalOptions.WEBPATH));
    }

    void query(String path) throws IOException {
        HTTPContext http = this.session.http;
        this.context.options.set(MainOptions.QUERYPATH, path);
        this.context.options.set(MainOptions.SERIALIZER, (Options)RESTQuery.serial(http));
        http.initResponse();
        int cs = this.cmds.size();
        for (int c = 0; c < cs; ++c) {
            Command cmd = (Command)this.cmds.get(c);
            if (cmd instanceof XQuery) {
                XQuery xq = (XQuery)this.cmds.get(c);
                if (this.value != null) {
                    xq.bind(null, this.value, NodeType.DOC.toString());
                }
                xq.http((Object)http);
                for (Map.Entry<String, String[]> e : this.variables.entrySet()) {
                    String key = e.getKey();
                    String[] val = e.getValue();
                    if (val.length == 2) {
                        xq.bind(key, val[0], val[1]);
                    }
                    if (val.length != 1) continue;
                    xq.bind(key, val[0]);
                }
                http.sopts().parse(xq.parameters(this.context).toString());
                http.initResponse();
                this.run((Command)xq, (OutputStream)http.res.getOutputStream());
                continue;
            }
            this.run(cmd, (OutputStream)http.res.getOutputStream());
        }
    }

    static RESTQuery get(RESTSession rs, String query, Map<String, String[]> vars, String val) throws IOException {
        RESTQuery.open(rs);
        rs.add((Command)new XQuery(query));
        return new RESTQuery(rs, vars, val);
    }
}

