/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.rest;

import java.io.IOException;
import java.io.OutputStream;
import org.basex.core.Command;
import org.basex.core.MainOptions;
import org.basex.core.cmd.AQuery;
import org.basex.core.cmd.List;
import org.basex.core.cmd.Open;
import org.basex.core.cmd.XQuery;
import org.basex.http.HTTPContext;
import org.basex.http.rest.RESTCmd;
import org.basex.http.rest.RESTList;
import org.basex.http.rest.RESTSession;
import org.basex.http.rest.RESTText;
import org.basex.io.serial.SerialMethod;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.func.Function;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.FElem;
import org.basex.util.Table;
import org.basex.util.Token;
import org.basex.util.options.Options;

final class RESTRetrieve
extends RESTCmd {
    private RESTRetrieve(RESTSession rs) {
        super(rs);
    }

    @Override
    protected void run0() throws IOException {
        for (Command c : this.cmds) {
            this.run(c);
        }
        HTTPContext http = this.session.http;
        if (this.run((Command)this.query(Function._DB_EXISTS)).equals("true")) {
            boolean raw = this.run((Command)this.query(Function._DB_IS_RAW)).equals("true");
            if (raw) {
                SerializerOptions sopts = http.sopts();
                sopts.set(SerializerOptions.METHOD, (Enum)SerialMethod.RAW);
                sopts.set(SerializerOptions.MEDIA_TYPE, this.run((Command)this.query(Function._DB_CONTENT_TYPE)));
            }
            http.initResponse();
            this.context.options.set(MainOptions.SERIALIZER, (Options)RESTRetrieve.serial(http));
            this.run((Command)this.query(raw ? Function._DB_RETRIEVE : Function._DB_OPEN), (OutputStream)http.res.getOutputStream());
        } else {
            Table table = new Table(this.run((Command)new List(http.db(), http.dbpath())));
            FElem el = new FElem(RESTText.Q_DATABASE).declareNS();
            el.add("name", http.db()).add("resources", Token.token((int)table.contents.size()));
            RESTRetrieve.list(table, el, RESTText.Q_RESOURCE, 0);
            http.initResponse();
            Serializer ser = Serializer.get((OutputStream)http.res.getOutputStream(), (SerializerOptions)http.sopts());
            ser.serialize((Item)el);
            ser.close();
        }
    }

    private AQuery query(Function f) {
        HTTPContext http = this.session.http;
        String query = "declare variable $d external;declare variable $p external;" + f.args(new Object[]{"$d", "$p"});
        return new XQuery(query).bind("d", http.db()).bind("p", http.dbpath());
    }

    static RESTCmd get(RESTSession rs) {
        HTTPContext http = rs.http;
        if (http.depth() == 0) {
            return new RESTList(rs.add((Command)new List()));
        }
        return new RESTRetrieve(rs.add((Command)new Open(http.db())));
    }
}

