/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import org.basex.http.HTTPContext;

final class RestXqPath
implements Comparable<RestXqPath> {
    final String[] segment;
    final boolean[] template;
    final int size;

    RestXqPath(String path) {
        this.segment = HTTPContext.toSegments(path);
        this.size = this.segment.length;
        this.template = new boolean[this.size];
        for (int s = 0; s < this.size; ++s) {
            this.template[s] = this.segment[s].trim().startsWith("{");
        }
        HTTPContext.decode(this.segment);
    }

    boolean matches(HTTPContext http) {
        if (this.size != http.depth()) {
            return false;
        }
        for (int s = 0; s < this.size; ++s) {
            if (this.segment[s].equals(http.segment(s)) || this.isTemplate(s)) continue;
            return false;
        }
        return true;
    }

    boolean isTemplate(int s) {
        return this.template[s];
    }

    @Override
    public int compareTo(RestXqPath rxs) {
        int d = this.size - rxs.size;
        if (d != 0) {
            return d;
        }
        for (int s = 0; s < this.size; ++s) {
            boolean wc2;
            boolean wc1 = this.isTemplate(s);
            if (wc1 == (wc2 = rxs.isTemplate(s))) continue;
            return wc1 ? 1 : -1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("/");
        for (int s = 0; s < this.size; ++s) {
            sb.append(this.segment[s]).append('/');
        }
        return sb.toString();
    }
}

