/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.restxq;

import java.io.OutputStream;
import java.util.Iterator;
import org.basex.http.HTTPContext;
import org.basex.http.HTTPMethod;
import org.basex.http.restxq.RestXqFunction;
import org.basex.http.restxq.RestXqText;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.io.serial.SerializerOptions;
import org.basex.query.func.FuncOptions;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.util.InputInfo;
import org.basex.util.Token;

final class RestXqRespBuilder {
    final ArrayOutput cache = new ArrayOutput();
    boolean error;
    int status;
    String message;

    RestXqRespBuilder() {
    }

    void build(ANode response, RestXqFunction func, Iter iter, HTTPContext http) throws Exception {
        Item item;
        Iterator i$ = response.attributes().iterator();
        if (i$.hasNext()) {
            ANode a = (ANode)i$.next();
            throw func.error("Unexpected node: %.", a);
        }
        SerializerOptions sp = func.output;
        String cType = null;
        for (ANode n : response.children()) {
            if (RestXqText.HTTP_RESPONSE.eq(n)) {
                byte[] sta = null;
                byte[] msg = null;
                for (ANode a : n.attributes()) {
                    QNm qnm = a.qname();
                    if (qnm.eq(RestXqText.Q_STATUS)) {
                        sta = a.string();
                        continue;
                    }
                    if (qnm.eq(RestXqText.Q_REASON) || qnm.eq(RestXqText.Q_MESSAGE)) {
                        msg = a.string();
                        continue;
                    }
                    throw func.error("Unexpected node: %.", a);
                }
                if (sta != null) {
                    this.status = Token.toInt(sta);
                    this.message = msg != null ? Token.string(msg) : null;
                }
                for (ANode c : n.children()) {
                    if (RestXqText.HTTP_HEADER.eq(c)) {
                        byte[] nam = c.attribute(RestXqText.Q_NAME);
                        byte[] val = c.attribute(RestXqText.Q_VALUE);
                        if (nam == null || val == null) continue;
                        String key = Token.string((byte[])nam);
                        String value = Token.string((byte[])val);
                        if (key.equals("Content-Type")) {
                            cType = value;
                            continue;
                        }
                        http.res.setHeader(key, value);
                        continue;
                    }
                    throw func.error("Unexpected node: %.", c);
                }
                continue;
            }
            if (RestXqText.OUTPUT_SERIAL.eq(n)) {
                sp = FuncOptions.serializer((Item)n, (InputInfo)func.function.info);
                FuncOptions.serializer((Item)n, (SerializerOptions)func.output, (InputInfo)func.function.info);
                continue;
            }
            throw func.error("Unexpected node: %.", n);
        }
        if (cType != null) {
            sp.set(SerializerOptions.MEDIA_TYPE, cType);
        }
        if ((item = iter.next()) == null) {
            this.error = true;
        } else if (func.methods.size() == 1 && func.methods.contains(HTTPMethod.HEAD.name())) {
            throw func.error("HEAD method must return a single 'restxq:response' element.", new Object[0]);
        }
        http.sopts(sp);
        http.initResponse();
        Serializer ser = Serializer.get((OutputStream)this.cache, (SerializerOptions)sp);
        while (item != null) {
            ser.serialize(item);
            item = iter.next();
        }
        ser.close();
    }
}

