/*
 * Decompiled with CFR 0.152.
 */
package org.basex.http.webdav.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.UUID;
import org.basex.core.BaseXException;
import org.basex.data.Result;
import org.basex.http.HTTPContext;
import org.basex.http.webdav.impl.WebDAVQuery;
import org.basex.io.IOStream;
import org.basex.io.out.ArrayOutput;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.list.StringList;

public final class WebDAVLockService {
    private static final String FILE = "xquery/webdav.xqm";
    private final HTTPContext http;

    WebDAVLockService(HTTPContext h) {
        this.http = h;
    }

    public void unlock(String token) throws IOException {
        this.execute(new WebDAVQuery("w:delete-lock($token)").bind("token", token));
    }

    public void refreshLock(String token) throws IOException {
        this.execute(new WebDAVQuery("w:refresh-lock($token)").bind("token", token));
    }

    public String lock(String db, String p, String scope, String type, String depth, String user, Long to) throws IOException {
        this.initLockDb();
        String token = UUID.randomUUID().toString();
        WebDAVQuery query = new WebDAVQuery("w:create-lock($path, $token, $scope, $type, $depth, $owner,$timeout)");
        query.bind("path", db + '/' + p);
        query.bind("token", token);
        query.bind("scope", scope);
        query.bind("type", type);
        query.bind("depth", depth);
        query.bind("owner", user);
        query.bind("timeout", to == null ? Long.MAX_VALUE : to);
        this.execute(query);
        return token;
    }

    public String lock(String token) throws IOException {
        StringList locks = this.execute(new WebDAVQuery("w:lock($token)").bind("token", token));
        return locks.isEmpty() ? null : locks.get(0);
    }

    public String lock(String db, String path) throws IOException {
        WebDAVQuery query = new WebDAVQuery("w:locks-on($path)").bind("path", db + '/' + path);
        StringList sl = this.execute(query);
        return sl.isEmpty() ? null : sl.get(0);
    }

    public boolean conflictingLocks(String db, String p) throws IOException {
        return this.execute(new WebDAVQuery("w:conflicting-locks(<w:lockinfo><w:path>{ $path }</w:path><w:scope>exclusive</w:scope><w:depth>infinite</w:depth><w:owner>{ $owner }</w:owner></w:lockinfo>)").bind("path", db + '/' + p).bind("owner", this.http.user)).isEmpty();
    }

    private void initLockDb() throws IOException {
        this.execute(new WebDAVQuery("w:init-lock-db()"));
    }

    private StringList execute(WebDAVQuery query) throws IOException {
        ClassLoader cl = this.getClass().getClassLoader();
        InputStream s = cl.getResourceAsStream(FILE);
        if (s == null) {
            throw new IOException("WebDAV module not found");
        }
        byte[] module = new IOStream(s).read();
        QueryProcessor qp = new QueryProcessor(query.toString(), this.http.context());
        try {
            for (Map.Entry<String, Object> entry : query.entries()) {
                qp.bind(entry.getKey(), entry.getValue());
            }
            qp.ctx.parseLibrary(Token.string((byte[])module), FILE, qp.sc);
            Result r = qp.execute();
            int n = (int)r.size();
            StringList items = new StringList(n);
            for (int i = 0; i < n; ++i) {
                ArrayOutput ao = new ArrayOutput();
                r.serialize((Serializer)Serializer.get((OutputStream)ao), 0);
                items.add(ao.toString());
            }
            StringList stringList = items;
            return stringList;
        }
        catch (QueryException ex) {
            throw new BaseXException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            Util.debug((Throwable)ex);
            throw new BaseXException(ex);
        }
        finally {
            qp.close();
        }
    }
}

