declare variable $pre-marklogic-5 := fn:matches(xdmp:version(), "^[1234]\.");

declare variable $module :=
<module>
	<uri>/xqj-conformance.xqy</uri>
	<content>
<![CDATA[
declare variable $xquery as xs:string external;

declare option xdmp:mapping "true";

declare function local:n($n as item())
{
	typeswitch($n)
		case $c as xs:QName
			return local:p(1,local:a($c),fn:namespace-uri-from-QName($c),$c)
		case $c as xs:anyAtomicType
			return local:p(1,local:a($c),(),$c)
		case $c as element()
			return local:p(7,local:a($c),(),xdmp:quote($c))
		case $c as attribute()
			return local:p(2,local:a($c),fn:namespace-uri($c),local:d($c))
		case $c as text()
			return local:p('B',local:a($c),(),$c)
		case $c as document-node(element())
			return local:p(5,local:a($c),xdmp:node-uri($n),xdmp:quote($c))
		case $c as document-node()
			return if($c/node() instance of text()) then
				local:p(4,local:a($c),xdmp:node-uri($n),xdmp:quote($c))
			else
				local:p('o',local:a($c),xdmp:node-uri($n),$c)
		case $c as comment()
			return local:p(3,local:a($c),(),xdmp:quote($c))
		case $c as processing-instruction()
			return local:p('A',local:a($c),(),xdmp:quote($c))
		default return ()
};

declare function local:a($a)
{
	typeswitch($a)
		case $c as xs:untypedAtomic return 5
		case $c as xs:ENTITY return 'm'
		case $c as xs:ID return 'k'
		case $c as xs:NMTOKEN return 'j'
		case $c as xs:language return 'g'
		case $c as xs:IDREF return 'l'
		case $c as xs:NCName return 'i'
		case $c as xs:Name return 'h'
		case $c as xs:token return 'f'
		case $c as xs:normalizedString return 'e'
		case $c as xs:string return 'T'

		case $c as xs:byte return 'V'
		case $c as xs:short return 'E'
		case $c as xs:int return 'C'
		case $c as xs:long return 'F'
		case $c as xs:unsignedByte return 'd'
		case $c as xs:unsignedShort return 'c'
		case $c as xs:unsignedInt return 'b'
		case $c as xs:unsignedLong return 'a'
		case $c as xs:positiveInteger return 'Z'
		case $c as xs:nonNegativeInteger return 'X'
		case $c as xs:negativeInteger return 'Y'
		case $c as xs:nonPositiveInteger return 'W'
		case $c as xs:integer return 'D'
 		case $c as xs:decimal return 'H'

		case $c as xs:float return 'K'
		case $c as xs:double return 'I'
		case $c as xs:boolean return 'A'
		case $c as xs:date return 'B'
		case $c as xs:dateTime return 'G'
		case $c as xs:anyURI return 8
		case $c as xs:time return 'U'
		case $c as xs:gYearMonth return 'P'
		case $c as xs:gYear return 'O'
		case $c as xs:gDay return 'L'
		case $c as xs:gMonth return 'M'
		case $c as xs:gMonthDay return 'N'
		case $c as xs:base64Binary return 9
		case $c as xs:hexBinary return 'Q'
		case $c as xs:QName return 'S'
		case $c as xs:NOTATION return 'R'

		case $c as xs:yearMonthDuration return 7
		case $c as xs:dayTimeDuration return 6
		case $c as xs:duration return 'J'
		default return 0
};

declare function local:d($n as attribute())
{
	fn:concat(fn:name($n),'="',fn:replace($n,'"',"&amp;quot;"),'"')
};

declare function local:p($kind, $type, $url as xs:string?, $result)
{
	fn:concat($kind,$type,$url,",",$result)
};
]]>{
if($pre-marklogic-5) then
<e>
<![CDATA[
local:n(
	xdmp:eval(
		$xquery
	)
)
]]>
</e>/text()
else
<e>
<![CDATA[
local:n(
	xdmp:eval(
		$xquery, (),
    if(xdmp:get-transaction-mode() ne "auto") then
		  <options xmlns="xdmp:eval">
			  <isolation>same-statement</isolation>
		  </options>
    else ()
	)
)
]]>
</e>/text() }
	</content>
</module>;

let $mdb := xdmp:modules-database()
return
if($mdb = 0) then

	xdmp:save(
		fn:concat(xdmp:modules-root(), $module/uri),
		$module/content/text()
	)

else

	xdmp:eval(
		fn:concat(
			'declare variable $content external;',
			'xdmp:document-insert("',
			$module/uri,
			'", $content)'
		),
		(xs:QName("content"),$module/content/text()),
		<options xmlns="xdmp:eval">
			<database>{$mdb}</database>
		</options>
	)
