/*
 * Decompiled with CFR 0.152.
 */
package rb.httpd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import rb.httpd.HttpAccessTable;
import rb.httpd.HttpClass;
import rb.httpd.RBH;
import rb.httpd.RequestHeader;
import rb.httpd.RequestProcessorClass;
import rb.util.FileRB;

public class FileHandler
extends RequestProcessorClass {
    String argPath;
    File argFile;
    static String rootMark = "_";

    void directory(String string, String string2) {
        this.sendLink(this.tagImg("folder.gif", "left"), "\u0000/" + rootMark + HttpClass.toURL(string) + "?RBH", null, null);
        this.sendLink(HttpClass.toHttp(string2), "\u0000/" + rootMark + HttpClass.toURL(string), null, null);
        this.print.print("<BR>\n");
    }

    void file(String string, String string2) {
        this.sendLink(this.tagImg("file.gif", ""), "\u0000/" + rootMark + HttpClass.toURL(string) + "?text/plain", null, null);
        this.sendLink(HttpClass.toHttp(string2), "\u0000/" + rootMark + HttpClass.toURL(string) + "?RBH", null, null);
        this.print.print("<BR>\n");
    }

    public void replyTo(RequestHeader requestHeader, InputStream inputStream, OutputStream outputStream) throws Throwable {
        this.init(requestHeader, outputStream);
        this.argPath = requestHeader.getURLPath();
        boolean bl = this.argPath.startsWith(rootMark);
        if (bl) {
            this.argPath = this.argPath.substring(rootMark.length());
        }
        if ("RBH".equals(requestHeader.getURLParameters())) {
            new RBH().sendRBH(requestHeader, outputStream, this.argPath);
            return;
        }
        if (!bl) {
            this.argPath = HttpAccessTable.translateFileName(this.argPath, true);
        }
        if (this.argPath == null) {
            this.showInvalidPath(requestHeader.getURLPath());
        } else {
            this.argFile = new File(this.argPath);
            if (!this.argFile.isFile()) {
                this.showDirectory();
            } else {
                this.sendFile(new FileInputStream(this.argFile), outputStream, requestHeader.getURLParameters());
            }
        }
    }

    void showDirectory() throws IOException {
        if (!this.argPath.endsWith(File.separator)) {
            this.argPath = String.valueOf(this.argPath) + File.separator;
        }
        this.sendHeader("text/html", -1L, true);
        this.sendHtmlStart("Directory (RB) : " + this.argPath);
        this.print.print("<TABLE WIDTH=100% BORDER=1 CELLPADDING=2 CELLSPACING=0>");
        this.print.print("<TBODY> <TR VALIGN=TOP>");
        this.print.print("<TD COLSPAN=\"2\" >\n");
        this.showDirectoryLine();
        this.print.print("</TD></TR>\n");
        this.print.print("<TR VALIGN=TOP>\n  ");
        this.print.print("<TD WIDTH=50% BGCOLOR=\"#e6e6ff\">Directories:</TH>");
        this.print.print("<TD WIDTH=50% BGCOLOR=\"#e6e6ff\">Files:</TH>");
        this.print.print("</TR>");
        this.print.print("<TR VALIGN=TOP>");
        File[] fileArray = FileRB.getFiles(this.argFile, FileRB.FltDirectory, FileRB.CmpNoCase);
        this.print.print("<TD WIDTH=50%>");
        int n = 0;
        while (n < fileArray.length) {
            this.directory(fileArray[n].getAbsolutePath(), fileArray[n].getName());
            ++n;
        }
        if (fileArray.length == 0) {
            this.print.print(this.transparent(0));
        }
        this.print.print("</TD>\n");
        fileArray = FileRB.getFiles(this.argFile, FileRB.FltFile, FileRB.CmpNoCase);
        this.print.print("<TD WIDTH=50%>");
        n = 0;
        while (n < fileArray.length) {
            this.file(fileArray[n].getAbsolutePath(), fileArray[n].getName());
            ++n;
        }
        if (fileArray.length == 0) {
            this.print.print(this.transparent(0));
        }
        this.print.print("</TD>\n");
        this.print.print("</TBODY> </TABLE> </BODY> </HTML>\n\n");
        this.print.flush();
    }

    void showDirectoryLine() throws IOException {
        this.sendLink(this.tagImg("folder.gif", "left"), "\u0000/" + rootMark + HttpClass.toURL(this.argPath) + "?RBH", null, null);
        this.sendLink(this.tagImg("pickup.gif", "right"), "?", "_blank", "New window");
        this.sendLink(this.tagImg("help.gif", "right"), "&/FileBrowser.html", null, "Help");
        int n = 0;
        int n2 = 0;
        while (n < this.argPath.length()) {
            n2 = this.argPath.indexOf(File.separator, n);
            if (n2 < 0) {
                n2 = this.argPath.length();
            }
            String string = "\u0000/" + rootMark + HttpClass.toURL(String.valueOf(this.argPath.substring(0, n2)) + File.separator);
            if (n2 > n) {
                this.sendLink(this.argPath.substring(n, n2), string, "", "");
                this.print.print(File.separator);
            } else {
                this.sendLink(File.separator, string, "", "");
            }
            this.print.print("\n");
            n = n2 + File.separator.length();
        }
    }
}

