/*
 * Decompiled with CFR 0.152.
 */
package rb.httpd;

import java.io.File;
import rb.util.StringUtil;
import rb.util.SystemRB;
import rb.util.VectorRB;

public class HttpAccessTable {
    String[] keys;
    String[] values;
    static HttpAccessTable translateTable = new HttpAccessTable("rb.httpd.translate", "AddressBook/=&AddressBook/? ");
    static HttpAccessTable accessTable = new HttpAccessTable("rb.httpd.access", "");

    HttpAccessTable(String string, String string2) {
        this.initTable(SystemRB.getPropertyString(string, string2));
    }

    private void initTable(String string) {
        String[] stringArray = StringUtil.splitString(string, "?");
        VectorRB vectorRB = new VectorRB();
        VectorRB vectorRB2 = new VectorRB();
        int n = 0;
        while (n < stringArray.length) {
            int n2 = stringArray[n].indexOf(61);
            if (n2 >= 0) {
                vectorRB.add(stringArray[n].substring(0, n2).trim());
                vectorRB2.add(stringArray[n].substring(n2 + 1));
            }
            ++n;
        }
        this.keys = new String[vectorRB.size()];
        this.values = new String[vectorRB2.size()];
        vectorRB.toArray(this.keys);
        vectorRB2.toArray(this.values);
    }

    String translate(String string) {
        return HttpAccessTable.translate(string, this.keys, this.values);
    }

    static String translate(String string, String[] stringArray, String[] stringArray2) {
        if (string == null) {
            return null;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (string.startsWith(stringArray[n])) {
                return String.valueOf(stringArray2[n]) + string.substring(stringArray[n].length());
            }
            ++n;
        }
        return null;
    }

    String translateBack(String string) {
        return HttpAccessTable.translate(string, this.values, this.keys);
    }

    static String translateFileName(String string, boolean bl) {
        string = StringUtil.replace(string, "|", ":");
        string = StringUtil.replace(string, "/", File.separator);
        String string2 = accessTable.translate(string);
        if (bl && (string2 == null || accessTable.translateBack(string2) == null)) {
            return null;
        }
        if (string2 != null) {
            string = string2;
        }
        return string;
    }
}

