/*
 * Decompiled with CFR 0.152.
 */
package rb.httpd;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import rb.httpd.Default;
import rb.httpd.HttpClass;
import rb.httpd.HttpRequestHeader;
import rb.httpd.RequestHeader;
import rb.httpd.RequestProcessor;
import rb.util.StringUtil;
import rb.util.SystemRB;

class HttpRequestServer {
    Socket client;
    String redirectRequest = "";
    static final String prpLog = "rb.httpd.log.requests";
    private static final Vector requestProcessors = new Vector();
    private static final Hashtable clientInfo = new Hashtable();

    HttpRequestServer(Socket socket) {
        this.client = socket;
    }

    static Hashtable getClientInfo() {
        Hashtable hashtable = clientInfo;
        synchronized (hashtable) {
            return (Hashtable)clientInfo.clone();
        }
    }

    static Vector getProcessorClasses() {
        Vector vector = requestProcessors;
        synchronized (vector) {
            return (Vector)requestProcessors.clone();
        }
    }

    static RequestProcessor getProcessorFor(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            Vector vector = requestProcessors;
            synchronized (vector) {
                if (requestProcessors.indexOf(clazz) < 0) {
                    if (bl) {
                        throw new Exception("");
                    }
                    requestProcessors.addElement(clazz);
                }
            }
            return (RequestProcessor)clazz.newInstance();
        }
        catch (Exception exception) {
            return new Default();
        }
    }

    void logClientAndRequest(RequestHeader requestHeader) {
        Hashtable hashtable = clientInfo;
        synchronized (hashtable) {
            clientInfo.put(this.client.getInetAddress(), new Date());
        }
        if ("true".equals(SystemRB.getPropertyString(prpLog, ""))) {
            SystemRB.log("" + this.client + " : " + requestHeader.getURL());
        }
    }

    void processRequest() {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = this.client.getInputStream();
            outputStream = this.client.getOutputStream();
            this.processRequestPrim(inputStream, outputStream);
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
        }
        try {
            inputStream.close();
        }
        catch (Throwable throwable) {}
        try {
            outputStream.close();
        }
        catch (Throwable throwable) {}
        try {
            this.client.close();
        }
        catch (Throwable throwable) {}
    }

    void processRequestPrim(InputStream inputStream, OutputStream outputStream) throws Throwable {
        HttpRequestHeader httpRequestHeader = new HttpRequestHeader();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        httpRequestHeader.readFrom(bufferedReader);
        httpRequestHeader.localAddress = String.valueOf(this.client.getLocalAddress().getHostName()) + ":" + this.client.getLocalPort();
        if ("/".indexOf(httpRequestHeader.getURL()) >= 0) {
            httpRequestHeader.urlPath = "&/server.html";
        }
        try {
            this.logClientAndRequest(httpRequestHeader);
            RequestProcessor requestProcessor = HttpRequestServer.getProcessorFor(httpRequestHeader.getProcessorClassName(), false);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream, 1460);
            if (httpRequestHeader.getURLPath().indexOf("&") < 0) {
                requestProcessor.replyTo(httpRequestHeader, inputStream, bufferedOutputStream);
            } else {
                new Default().sendResource(httpRequestHeader, requestProcessor, outputStream);
            }
        }
        catch (Exception exception) {
            this.showError(exception, outputStream, httpRequestHeader);
        }
    }

    void showError(Throwable throwable, OutputStream outputStream, HttpRequestHeader httpRequestHeader) {
        SystemRB.log(this, "", throwable);
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        printWriter.print("HTTP/1.0 200 OK \n Content-Type: text/plain\n Pragma: no-cache\n Cache-control: no-cache\n");
        printWriter.print("Connection: close \n\n");
        printWriter.print("-- Error: " + throwable.getMessage() + "\n");
        throwable.printStackTrace(printWriter);
        printWriter.print("-- The original request:\n");
        int n = 0;
        while (n < httpRequestHeader.headerLines.length) {
            printWriter.print(httpRequestHeader.headerLines[n]);
            printWriter.print("\n");
            SystemRB.log(httpRequestHeader.headerLines[n]);
            ++n;
        }
        printWriter.flush();
    }

    String[] splitRequest(String string) throws Throwable {
        String string2 = "FileHandler";
        String[] stringArray = new String[]{"&", HttpClass.toURL("&")};
        int n = 0;
        while (n < stringArray.length) {
            if (string.startsWith(stringArray[n])) {
                string2 = string.substring(stringArray[n].length());
                string = "";
                int n2 = string2.indexOf(47);
                if (n2 >= 0) {
                    string = string2.substring(n2 + 1);
                    string2 = string2.substring(0, n2);
                }
                this.redirectRequest = string2;
                if (!string2.equals("")) break;
                string2 = "FileHandler&";
                break;
            }
            ++n;
        }
        if (string2.indexOf(46) < 0) {
            string2 = String.valueOf(StringUtil.toLast(this.getClass().getName(), '.')) + "." + string2;
        }
        return new String[]{string2, string};
    }
}

