/*
 * Decompiled with CFR 0.152.
 */
package rb.util;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import rb.util.Context1;
import sun.misc.Compare;
import sun.misc.Sort;

public class VectorRB
extends Vector {
    VectorRB thisVector = this;

    public VectorRB() {
    }

    public VectorRB(int n) {
        super(n);
    }

    public VectorRB(int n, int n2) {
        super(n, n2);
    }

    public VectorRB(Dictionary dictionary) {
        this(dictionary.size());
        this.addElements(dictionary.elements());
    }

    public VectorRB(Object[] objectArray) {
        super(objectArray.length);
        this.addElements(objectArray);
    }

    public synchronized void add(Object object) {
        super.addElement(object);
    }

    public void addElements(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.addElement(enumeration.nextElement());
        }
    }

    public void addElements(Vector vector) {
        this.insertElements(vector, this.elementCount);
    }

    public void addElements(Object[] objectArray) {
        this.insertElements(objectArray, this.elementCount);
    }

    public synchronized VectorRB collect(Context1 context1) {
        VectorRB vectorRB = new VectorRB(this.size());
        int n = 0;
        while (n < this.elementCount) {
            vectorRB.elementData[n] = context1.value(this.elementData[n]);
            ++n;
        }
        vectorRB.elementCount = this.elementCount;
        return vectorRB;
    }

    public synchronized int copyInto(Object[] objectArray, int n) {
        int n2 = Math.min(objectArray.length, this.elementCount - n);
        int n3 = 0;
        while (n3 < n2) {
            objectArray[n3] = this.elementData[n3 + n];
            ++n3;
        }
        return n2;
    }

    public final synchronized void insertElements(Vector vector, int n) {
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        this.insertElements(objectArray, n);
    }

    public final void insertElements(Object[] objectArray, int n) {
        this.insertElements(objectArray, n, objectArray.length);
    }

    public final synchronized void insertElements(Object[] objectArray, int n, int n2) {
        if (n >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        this.ensureCapacity(this.elementCount + n2);
        System.arraycopy(this.elementData, n, this.elementData, n + n2, this.elementCount - n);
        System.arraycopy(objectArray, 0, this.elementData, n, n2);
        this.elementCount += n2;
    }

    public synchronized boolean remove(Object object) {
        return super.removeElement(object);
    }

    public synchronized void removeElements(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.removeElement(enumeration.nextElement());
        }
    }

    public synchronized void removeElements(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            this.removeElement(objectArray[n]);
            ++n;
        }
    }

    public synchronized VectorRB reversed() {
        VectorRB vectorRB = new VectorRB(this.size());
        int n = this.size() - 1;
        while (n >= 0) {
            vectorRB.addElement(this.elementAt(n));
            --n;
        }
        return vectorRB;
    }

    public synchronized Enumeration reversedElements() {
        return new Enumeration(this){
            /* synthetic */ VectorRB this$0;
            int current;

            public boolean hasMoreElements() {
                VectorRB vectorRB = this.this$0.thisVector;
                synchronized (vectorRB) {
                    return this.current >= 0;
                }
            }

            public Object nextElement() {
                VectorRB vectorRB = this.this$0.thisVector;
                synchronized (vectorRB) {
                    if (this.current >= 0) {
                        return this.this$0.elementAt(this.current--);
                    }
                }
                throw new NoSuchElementException(String.valueOf(this.this$0.thisVector.getClass().getName()) + ".reversedElements()");
            }
            {
                this.this$0 = vectorRB;
                this.current = vectorRB.size() - 1;
            }
        };
    }

    public void sort(Compare compare) {
        Sort.quicksort((Object[])this.elementData, (int)0, (int)(this.elementCount - 1), (Compare)compare);
    }

    public synchronized Vector subvector(int n, int n2) {
        if (n2 > this.elementCount) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        Object[] objectArray = new Object[n2 - n];
        System.arraycopy(this.elementData, n, objectArray, 0, n2 - n);
        return new VectorRB(this.elementData);
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        this.copyInto(objectArray);
        return objectArray;
    }

    public void toArray(Object object) {
        System.arraycopy(this.elementData, 0, object, 0, this.elementCount);
    }
}

