/**/
version="1.2"
/*
Version history
---------------
1.2 -- Replaced Bubble Sort with QSort,
       added buttons and pages;
1.1 -- Fixed bug with ftp sites;
1.0 -- Initial release.
*/

storepath=strip(translate('e:\scachestore'))
outfile.prefix='c:\scache\history\history'
outfile.postfix='.htm'
maxurlsperpage=15


'@echo off'
call RxFuncAdd 'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs


dirsbeforeurl=2

outfile.cpage=0
button.left=0
button.right=0
button.start=0
button.end=0

numstr='0123456789'
numeric digits 12
say 'Creating file tree...'
call SysFileTree storepath||"\*",'files','DST'
dir.0=files.0
time.0=files.0
say 'Total directories in cache: '||files.0
do i=1 to files.0
	parse value files.i with time.i . . dir.i
	time.i=strip(translate(time.i))
	dir.i=strip(translate(dir.i))
	/*skiping head dirs*/
	j=pos(storepath,dir.i||'\')+length(storepath)+1
	dir.i=substr(dir.i,j,length(dir.i)-j+1)
	dir.i.subpath=''
	do k=1 to dirsbeforeurl
		j=pos('\',dir.i)
		if j=0 then do 
			dir.i='' 
			time.i='00/00/00/00/00'
		end
		else do
			dir.i.subpath=dir.i.subpath||substr(dir.i,1,j)
			dir.i=substr(dir.i,j+1,length(dir.i)-j)
		end
	end
	/*skiping after dirs */
	j=pos('\',dir.i)
	if j>0 then do
		dir.i=substr(dir.i,1,j-1)
	end
	/*port numbers check*/
	j=lastpos('_',dir.i)
	if j>0 then do
		fl=1 /*all numbers*/
		do k=j+1 to length(dir.i)-1
			ch=substr(dir.i,k,1)
			if pos(ch,numstr)=0 then fl=0 
		end
		if fl=1 then do
			dir.i=substr(dir.i,1,j-1)||':'||substr(dir.i,j+1,length(dir.i)-j)
		end
	end
end

call strim

say 'Creating servers list'
/* searching for duplicate*/
do i=1 to dir.0
	call charout ,'.'
	do j=i+1 to dir.0 
		if i<>j then do
			if (dir.i=dir.j) then do
				if fdate2num(time.i)>fdate2num(time.j) then do
					dir.j='' 
					time.j='00/00/00/00/00'
				end
				else do
					dir.i=''
					time.i='00/00/00/00/00'
				end
			end
		end
	end
end
say ''
say 'Sorting servers list'
call strim
/*sorting*/
call qsort
/*sflag=1
do while sflag=1
	sflag=0
	call charout ,'.'
	do i=1 to dir.0-1
		j=i+1
		if (fdate2num(time.j)>fdate2num(time.i)) then do
			/*swapping*/
			s=time.j
			time.j=time.i
			time.i=s

			s=dir.j
			l=dir.j.subpath
			dir.j.subpath=dir.i.subpath
			dir.j=dir.i

			dir.i=s
			dir.i.subpath=l
			sflag=1
		end
	end
end*/
say ''
say 'Writing output'
/*writing history file*/
call sysFileTree outfile.prefix||'*'||outfile.postfix,'f2d','FO'
do i=1 to f2d.0 
	call sysFileDelete f2d.i
end
call writeheader
do i=1 to dir.0
	outf=outfile.prefix||outfile.cpage||outfile.postfix
	pfix='http '
	url=lowcase(dir.i)
	full_url='http://'||url
	full_path='file:///'||translate(storepath,'|',':')||'\'||dir.i.subpath||translate(lowcase(dir.i),'_',':')||'\'
	j=lastpos('^',url)
	if j>0 then do
		pfix='ftp '
		url=substr(url,1,j-1)
		full_url='ftp://'||url
	end
	call lineout outf,'<TR>'
	call lineout outf,'<TD><sub>'||i||'</sub></TD>'
	call lineout outf,'<TD><FONT COLOR="000060">'||fdate2date(time.i)||'<sup>'||fdate2time(time.i)||'</sup></FONT></TD>'
	call lineout outf,'<TD><B><sup>'||pfix||'</sup><A HREF="'||full_url||'">'||url||'</B></A><A HREF="'||full_path||'"><i><sup>Folder</i></sup></A></TD>'
	call lineout outf,'</TR>'
	if (i%maxurlsperpage=i/maxurlsperpage) then do
		if outfile.cpage=0 then do 
			button.start=0
			button.left=0
		end
		else do
			button.start=1
			button.left=1
		end
		if i<dir.0 then do
			button.right=1
			button.end=1
		end
		else do
			button.right=0
			button.end=0
		end
		call writefooter
		if i<dir.0 then do
			button.start=1
			button.left=1
			outfile.cpage=outfile.cpage+1
			call writeheader
		end
	end
end
if (dir.0%maxurlsperpage<>dir.0/maxurlsperpage) then do
	button.right=0
	button.end=0
	call writefooter
end
/*done*/
say 'done.'
exit


writefooter: procedure expose outfile. button. dir. maxurlsperpage version

outf=outfile.prefix||outfile.cpage||outfile.postfix
call lineout outf,'</TABLE>'
call lineout outf,'<P>'

call lineout outf,'<TABLE BORDER=0 cellpadding=0 cellspacing=0 width="80%">'

outfpref=translate(outfile.prefix,'|',':')
outfpref='file:///'||translate(outfpref,'/','\')
if button.start=0 then 
	call lineout outf,'<TD align=center><IMG SRC="startbutton_off.jpg" width=100 height=50></TD>'
else
	call lineout outf,'<TD align=center><A HREF="'||outfpref||0||outfile.postfix||'"><IMG SRC="startbutton.jpg" width=100 height=50 ALT=""></A></TD>'

if button.left=0 then 
	call lineout outf,'<TD align=center><IMG SRC="leftbutton_off.jpg" width=100 height=50></TD>'
else
	call lineout outf,'<TD align=center><A HREF="'||outfpref||outfile.cpage-1||outfile.postfix||'"><IMG SRC="leftbutton.jpg" width=100 height=50 ALT=""></A></TD>'

if button.right=0 then 
	call lineout outf,'<TD align=center><IMG SRC="rightbutton_off.jpg" width=100 height=50></TD>'
else
	call lineout outf,'<TD align=center><A HREF="'||outfpref||outfile.cpage+1||outfile.postfix||'"><IMG SRC="rightbutton.jpg" width=100 height=50 ALT=""></A></TD>'

if button.end=0 then 
	call lineout outf,'<TD align=center><IMG SRC="endbutton_off.jpg" width=100 height=50></TD>'
else
	call lineout outf,'<TD align=center><A HREF="'||outfpref||dir.0%maxurlsperpage||outfile.postfix||'"><IMG SRC="endbutton.jpg" width=100 height=50 ALT=""></A></TD>'

call lineout outf,'</TABLE>'

call lineout outf,'<i><sup>script done by <A HREF="mailto:stalker@pec.ru"><B>Stalker</B></A></sup></i>'
call lineout outf,'<Fontsize="-1"><br><sup>generated on '||date('E')||'<sup>'||time()||'</sup>   by version '||version||'</sup></br></font>'
call lineout outf,'</CENTER>'
call lineout outf,'</BODY>'
call lineout outf,'</HTML>'
call stream outf,'c','close'
return 0

writeheader: procedure expose outfile. maxurlsperpage dir.
outf=outfile.prefix||outfile.cpage||outfile.postfix
maxpage=dir.0%maxurlsperpage
if (dir.0//maxurlsperpage)>0 then maxpage=maxpage+1
call lineout outf,'<HTML>'
call lineout outf,'<HEAD>'
call lineout outf,'<TITLE>SCACHE History</TITLE>'
call lineout outf,'<BODY Background="back.jpg" bgcolor="white" link="blue" vlink="blue" >'
call lineout outf,'<CENTER>'
call lineout outf,'<A HREF="http://ncic.netmag.cz/apps/nase/smartcache.html"><img src="scachenow.jpg" alt="Scache now!" width="88" height="31" border="0"></a>'
call lineout outf,'<Font size="+3"><b><br>SCache history</b></font><br>'
call lineout outf,'<hr size=1>'
/*call lineout outf,'<P>'*/
call lineout outf,'<TABLE Border=0 Cellspacing=0 Cellpadding=0 width=80%>'
call lineout outf,'<TD><sub>page '||outfile.cpage+1||' of '||maxpage||'</sub></TD>'
call lineout outf,'</TABLE>'

call lineout outf,'<TABLE Border=2 Cellspacing=0 Cellpadding=0 width=80%>'
return 0


strim:procedure expose dir. time.
/*deleting dupes*/
	k=0
	do i=1 to dir.0
		if dir.i<>'' then do
			k=k+1
			sdir.k=dir.i
			sdir.k.subpath=dir.i.subpath
			stime.k=time.i
		end
	end
	sdir.0=k
	stime.0=k
	do i=1 to sdir.0
		dir.i=sdir.i
		dir.i.subpath=sdir.i.subpath
		time.i=stime.i
	end
	dir.0=sdir.0
	time.0=stime.0
	drop stime sdir
return 0

fdate2time:procedure
	parse arg fdate
	parse value fdate with year '/' month '/' date '/' hour '/' minute
	/*y2k bug*/
	if year<81 then do
		year='20'||year 
	end	
	else do
		year='19'||year
	end
	dt=hour||':'||minute
return dt

fdate2date:procedure
	parse arg fdate
	parse value fdate with year '/' month '/' date '/' hour '/' minute
	/*y2k bug*/
	if year<81 then do
		year='20'||year 
	end	
	else do
		year='19'||year
	end
	dt=date||'/'||month||'/'||year
return dt

fdate2num:procedure
	parse arg fdate
	parse value fdate with year '/' month '/' date '/' hour '/' minute
	/*y2k bug*/
	if year<81 then do
		year='20'||year 
	end	
	else do
		year='19'||year
	end
	if month=0 
		then num=0
		else num=year||month||date||hour||minute
return num

lowCase: procedure
	parse arg st
	st=translate(st,'㪥뢠஫ᬨabcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')
return st

QSort: Procedure Expose dir. time.
	Arg left, right
	If left  = '' Then left  = 1
	If right = '' Then right = time.0
	If right > left Then Do
		i = left
		j = right
		k = (left+right)%2
		x = fdate2num(time.k)
		Do Until i > j
			Do While fdate2num(time.i) > x; i = i + 1; End
			Do While fdate2num(time.j) < x; j = j - 1; End
			If i <= j Then Do
				/*swapping*/
				if (i<>j) then do
					call charout ,'.'
					s=time.i
					time.i=time.j
					time.j=s
					
					s=dir.j
					l=dir.j.subpath
					dir.j.subpath=dir.i.subpath
					dir.j=dir.i
	
					dir.i=s
					dir.i.subpath=l
				end
				i = i + 1
				j = j - 1
			End
		End
		y = QSort(left,j)
		y = QSort(i,right)
	End
Return right - left 