import java.net.*;
import java.io.*;
import java.util.*;

class ServerThread extends Thread
{
	Socket client;
	int serverPort;
	String serverRoot;
	String defaultFile;
	int delay;

	public ServerThread(Socket client,int port,String root,String file,int d)
	{
		this.client=client; serverPort=port; serverRoot=root; defaultFile=file; delay=d;
	}

	public void run()
	{
		try
		{
			String destName=client.getInetAddress().getHostName();
			String destAddr=client.getInetAddress().getHostAddress();
			int destPort=client.getPort();
			datedLog("Accepted connection to "+destName+" ("+destAddr+")"+" on port "+destPort+".");

			HTTPOutputStream outStream=new HTTPOutputStream(new BufferedOutputStream(client.getOutputStream()));
			HTTPInputStream inStream=new HTTPInputStream(client.getInputStream());
			HTTPRequest request=inStream.getRequest();
			request.log();
			String reqtype=request.requestType();
			if (reqtype.equals("GET")) processGetRequest(request,outStream);
			else if (reqtype.equals("POST")) processGetRequest(request,outStream);
			else {System.out.println("Unknown or unsupported method '"+reqtype+"' - ignoring"); sendString(outStream,"HTTP/1.0 404 BAD\n\nUnknown or unsupported method '"+reqtype+"'.");}
			datedLog("Request completed. Closing connection.");
		} catch (IOException ex) {datedLog("IOException occured when processing request.");}
		try {client.close();} catch (IOException ex) {datedLog("IOException occured when closing socket.");}
	}

	String getCGICommand(String fileName,String formInfo)
	{
		//CGI script - use extension to determine command
		String command=null;
		if (fileName.endsWith(".pl")) command="perl5 "+fileName+" "+formInfo; //Perl script
		if (fileName.endsWith(".cmd")) command="cmd /c "+fileName.replace('/','\\')+" "+formInfo.replace('&',' ')+" 2>&1"; //REXX or batch
		//To add more languages, just add more lines
		return command;
	}

	void processPostRequest(HTTPRequest request,HTTPOutputStream outStream) throws IOException
	{
		String fileName=request.getFileName(serverRoot,defaultFile);
		if (fileName.startsWith("cgi-bin/"))
		{
			String command=getCGICommand(fileName,""); //No formInfo on POST request (could be changed but prob not nec)
			if (command!=null)
			{
				//Execute script and send output
				System.out.println("Executing '"+command+"'...");
				Process p=Runtime.getRuntime().exec(command);
				InputStream is=p.getInputStream();
				OutputStream os=p.getOutputStream();
				request.write(os);
				os.flush();
				int bytecount=0;
				try
				{
					while (true)
					{
						int tmp=is.read();
						if (tmp==-1) break;
						outStream.write((byte)tmp);
						outStream.flush();
						++bytecount;
					}
				}
				catch (IOException e) {System.out.println("IOException on read()");}
				outStream.close();
				System.out.println(bytecount+" bytes of CGI output sent.");
				return;
			}
			//Unknown language - return error
			sendString(outStream,"<H3>Unknown cgi program</H3><P>Please check your URL and/or contact the site administrator.");
			outStream.flush();
			outStream.close();
			return;
		}
		System.out.println("POST target not CGI - ignoring.");
		sendString(outStream,"HTTP/1.0 404 BAD\n\nPOST target not in /cgi-bin - aborting.");
	}

	String makeLines(Vector vec)
	{
		Enumeration enum=vec.elements();
		StringBuffer lines=new StringBuffer((String)enum.nextElement());
		while (enum.hasMoreElements())
		{
			lines.append((char)13).append((char)10).append((String)enum.nextElement());
		}
		return lines.toString();
	}

	void processGetRequest(HTTPRequest request,HTTPOutputStream outStream) throws IOException
	{
		String fileName=request.getFileName(serverRoot,defaultFile);
		String formInfo="";
		int pos=fileName.indexOf('?');
		if (pos!=-1)
		{
			//Has question mark, prob has form info
			formInfo=fileName.substring(pos+1);
			fileName=fileName.substring(0,pos);
		}
		String command=getCGICommand(fileName,formInfo);
		if (delay>0) try {sleep(delay);} catch (InterruptedException e) {}
		if (command!=null)
		{
			//Execute script and send output
			System.out.println("Executing '"+command+"'...");
			Vector env=new Vector(); //A vector of strings for the environment
			String cred=request.getCredentials();
			if (cred!=null) env.addElement("CRED="+cred);
			env.addElement("REQUEST="+makeLines(request.getLines()));
			byte content[]=request.getContent();
			if (content!=null) env.addElement("CONTENT="+content);

			String envp[]=new String[env.size()];
			env.copyInto(envp);
			Process p=Runtime.getRuntime().exec(command,envp);
			InputStream is=p.getInputStream();
			OutputStream os=p.getOutputStream();
			request.write(os);
			int bytecount=0;
			try
			{
				while (true)
				{
					int tmp=is.read();
					if (tmp==-1) break;
					outStream.write((byte)tmp);
					outStream.flush();
					++bytecount;
				}
			}
			catch (IOException e) {System.out.println("IOException on read()");}
			outStream.close();
			System.out.println(bytecount+" bytes of CGI output sent.");
			return;
		}
		File file=new File(fileName);
		if (file.exists()) {sendString(outStream,"HTTP/1.0 200 OK\nContent-type: text/html\n\n"); sendFile(outStream,file);}
		else {sendString(outStream,"HTTP/1.0 404 NOTFOUND\nContent-type: text/plain\n\nThe requested URL does not exist."); datedLog("File "+fileName+" does not exist.");}
	}

	public boolean inServerRoot(String fileName)
	{
		int rootLength=serverRoot.length();
		if (fileName.length()<rootLength) return false;
		return serverRoot.equals(fileName.substring(0,rootLength));
	}

	void sendString(HTTPOutputStream out,String data)
	{
		try
		{
			int len=(int)data.length();
			for (int i=0;i<len;++i) out.write(data.charAt(i));
			out.flush();
		} catch (Exception ex) {}
	}

	void sendFile(HTTPOutputStream out,File file)
	{
		try
		{
			int max=256; //Maximum number of bytes to read in one block
			DataInputStream in = new DataInputStream(new FileInputStream(file));
			int len=(int)file.length();
			byte buffer[]=new byte[max];
			int lenleft=len;
			while (lenleft>max)
			{
				in.readFully(buffer,0,max);
				for (int i=0;i<max;++i) out.write(buffer[i]);
				out.flush();
				lenleft-=max;
			}
			if (lenleft>0)
			{
				buffer=new byte[lenleft];
				in.readFully(buffer);
				in.close();
				for (int i=0;i<lenleft;++i) out.write(buffer[i]);
				out.flush();
				out.close();
				datedLog("File sent: "+file+"  Number of bytes: "+len);
			}
		} catch (Exception ex) {datedLog("Error retrieving "+file);}
	}

	public synchronized void datedLog(String msg)
	{
		System.out.println((new Date()).toString()+" "+msg);
	}
}
