/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigedit.frames;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.w3c.cvs.CvsAddException;
import org.w3c.cvs.CvsDirectory;
import org.w3c.cvs.CvsException;
import org.w3c.cvs.UpToDateCheckFailedException;
import org.w3c.jigedit.cvs.CvsFrame;
import org.w3c.jigedit.cvs.CvsModule;
import org.w3c.jigsaw.frames.HTTPFrame;
import org.w3c.jigsaw.html.HtmlGenerator;
import org.w3c.jigsaw.http.HTTPException;
import org.w3c.jigsaw.http.Reply;
import org.w3c.jigsaw.http.Request;
import org.w3c.tools.resources.Attribute;
import org.w3c.tools.resources.AttributeRegistry;
import org.w3c.tools.resources.BooleanAttribute;
import org.w3c.tools.resources.DirectoryResource;
import org.w3c.tools.resources.InvalidResourceException;
import org.w3c.tools.resources.MultipleLockException;
import org.w3c.tools.resources.ProtocolException;
import org.w3c.tools.resources.ReplyInterface;
import org.w3c.tools.resources.RequestInterface;
import org.w3c.tools.resources.Resource;
import org.w3c.tools.resources.ResourceException;
import org.w3c.tools.resources.ResourceReference;
import org.w3c.util.IO;
import org.w3c.www.mime.MimeType;

public class CvsFileFrame
extends HTTPFrame {
    public static final boolean debug = true;
    private static int ATTR_AUTOUPDATE = -1;
    protected File resDirectory = null;

    protected static Reply error(Request request, int n, String string, String string2) {
        Reply reply = request.makeReply(n);
        HtmlGenerator htmlGenerator = CvsFrame.getHtmlGenerator(string);
        htmlGenerator.append("<span class=\"title\">", string, "</span>\n");
        htmlGenerator.append("<p>", string2);
        reply.setStream(htmlGenerator);
        return reply;
    }

    public boolean isAutoUpdatable() {
        return this.getBoolean(ATTR_AUTOUPDATE, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized File getResourceDirectory() {
        if (this.resDirectory == null) {
            ResourceReference resourceReference = this.getFileResource().getParent();
            ResourceReference resourceReference2 = null;
            Resource resource = null;
            while (true) {
                try {
                    if (resourceReference == null) {
                        File file = null;
                        return file;
                    }
                    resource = resourceReference.lock();
                    if (resource instanceof DirectoryResource) {
                        this.resDirectory = ((DirectoryResource)resource).getDirectory();
                        break;
                    }
                    resourceReference2 = resource.getParent();
                }
                catch (InvalidResourceException invalidResourceException) {
                    File file = null;
                    return file;
                }
                finally {
                    if (resourceReference != null) {
                        resourceReference.unlock();
                    }
                }
                resourceReference = resourceReference2;
            }
        }
        return this.resDirectory;
    }

    protected synchronized CvsDirectory getCvsManager() throws CvsException {
        return CvsModule.getCvsManager(this.getResourceDirectory(), this.getContext(), (Properties)this.getServer().getProperties());
    }

    protected boolean checkCvsManager() {
        try {
            return this.getCvsManager() != null;
        }
        catch (CvsException cvsException) {
            return false;
        }
    }

    public String computeETag() {
        String string = null;
        if (this.fresource != null) {
            long l = this.fresource.getFileStamp();
            long l2 = this.fresource.getFileLength();
            if (l >= 0L) {
                string = Long.toHexString(l2) + "-" + Long.toHexString(l);
            }
        }
        return string;
    }

    protected void add(Request request) throws CvsException {
        String string = (String)request.getState("org.w3c.jigsaw.auth.AuthFilter.user");
        String[] stringArray = new String[]{"USER=" + string, "LOGNAME=" + string};
        String[] stringArray2 = null;
        MimeType mimeType = request.getContentType();
        stringArray2 = mimeType != null && mimeType.match(MimeType.TEXT) != 3 && mimeType.match(MimeType.APPLICATION_XHTML_XML) != 4 ? new String[]{"-kb", this.getFileResource().getFile().getName()} : new String[]{this.getFileResource().getFile().getName()};
        CvsDirectory cvsDirectory = null;
        cvsDirectory = this.getCvsManager();
        cvsDirectory.add(stringArray2, stringArray);
    }

    protected void commit(Request request) throws CvsException {
        this.commit(request, "Changed through Jigsaw.");
    }

    protected void commit(Request request, String string) throws CvsException {
        String string2 = (String)request.getState("org.w3c.jigsaw.auth.AuthFilter.user");
        String[] stringArray = new String[]{"USER=" + string2, "LOGNAME=" + string2};
        String string3 = "(" + string2 + ") " + string;
        CvsDirectory cvsDirectory = null;
        cvsDirectory = this.getCvsManager();
        cvsDirectory.commit(this.getFileResource().getFile().getName(), string3, stringArray);
    }

    protected void update() throws CvsException {
        CvsDirectory cvsDirectory = this.getCvsManager();
        cvsDirectory.update(this.getFileResource().getFile().getName());
    }

    protected int status() throws CvsException {
        CvsDirectory cvsDirectory = this.getCvsManager();
        return cvsDirectory.status(this.getFileResource().getFile().getName());
    }

    protected String statusToString(int n) {
        return CvsDirectory.statusToString((int)n);
    }

    protected File getBackupFile() {
        File file = this.getFileResource().getFile();
        return new File(file.getParent(), file.getName() + ".bak");
    }

    protected Reply putFileResource(Request request) throws ProtocolException, ResourceException {
        System.out.println("Put on " + this.getResource().getIdentifier() + "...");
        if (this.getResourceDirectory() != null) {
            if (this.checkCvsManager()) {
                File file = this.getFileResource().getFile();
                int n = -1;
                try {
                    n = this.status();
                }
                catch (CvsException cvsException) {
                    n = 7;
                }
                System.out.println("... with a cvs status equals to : " + this.statusToString(n));
                if (n == 5) {
                    String string = "Conflict between working revision and repository revision.<br> Please update the file manually or use the CVS form.";
                    return CvsFileFrame.error(request, 409, "Conflict", string);
                }
                if (n == 8) {
                    String string = "File already in the repository (added independently by second party).<br>Please update the file manually or use the CVS form.";
                    return CvsFileFrame.error(request, 409, "Conflict", string);
                }
                if (file.exists() && n != 7) {
                    File file2 = this.getBackupFile();
                    try {
                        if (n == 1) {
                            try {
                                IO.copy((File)file, (File)file2);
                            }
                            catch (IOException iOException) {
                                file2.delete();
                                file.renameTo(file2);
                            }
                            Reply reply = super.putFileResource(request);
                            int n2 = reply.getStatus();
                            if (n2 / 100 == 2) {
                                this.commit(request);
                            }
                            file2.delete();
                            this.getFileResource().checkContent();
                            if (n2 / 100 == 2) {
                                return this.createDefaultReply(request, reply.getStatus());
                            }
                            return reply;
                        }
                        String string = "File is not up to date, please update the file manually or use the CVS form.";
                        return CvsFileFrame.error(request, 409, "Error", string);
                    }
                    catch (UpToDateCheckFailedException upToDateCheckFailedException) {
                        file.delete();
                        file2.renameTo(file);
                        String string = upToDateCheckFailedException.getFilename() + " is not up to date, " + "please update the file manually " + "or use the CVS form.";
                        return CvsFileFrame.error(request, 409, "Error", string);
                    }
                    catch (CvsException cvsException) {
                        file2.delete();
                        String string = "CvsException : " + cvsException.getMessage();
                        this.getServer().errlog(this.getIdentifier() + " : " + cvsException.getMessage());
                        return CvsFileFrame.error(request, 503, "Error", string);
                    }
                }
                Reply reply = super.putFileResource(request);
                try {
                    this.add(request);
                    this.commit(request);
                    this.getFileResource().checkContent();
                }
                catch (CvsAddException cvsAddException) {
                    String string = "Cvs add failed : <br>'" + cvsAddException.getMessage() + "'<br>please update the file manually " + "or use the CVS form";
                    return CvsFileFrame.error(request, 503, "Error", string);
                }
                catch (CvsException cvsException) {
                    cvsException.printStackTrace();
                    String string = "Problem during cvs process : " + cvsException.getMessage();
                    this.getServer().errlog(this.getIdentifier() + " : " + string);
                    return CvsFileFrame.error(request, 500, "Internal Server Error", string);
                }
                if (reply.getStatus() == 201) {
                    Reply reply2 = request.makeReply(reply.getStatus());
                    reply2.setContent("<P>Resource succesfully created");
                    if (request.hasState("org.w3c.jigsaw.frames.HTTPFrame.cl")) {
                        reply2.setContentLocation(this.getURL(request).toExternalForm());
                    }
                    reply = this.createDefaultReply(request, 201);
                    reply2.setETag(reply.getETag());
                    return reply2;
                }
                return this.createDefaultReply(request, reply.getStatus());
            }
            return super.putFileResource(request);
        }
        String string = "Server misconfigured : unable to find resource directory";
        this.getServer().errlog(this.getIdentifier() + " : " + string);
        return CvsFileFrame.error(request, 500, "Internal Server Error", string);
    }

    protected Reply deleteFileResource(Request request) throws ProtocolException, ResourceException {
        String string;
        String string2 = (String)request.getState("org.w3c.jigsaw.auth.AuthFilter.user");
        String[] stringArray = new String[]{"USER=" + string2, "LOGNAME=" + string2};
        this.fresource.getFile().delete();
        String[] stringArray2 = new String[]{this.fresource.getFilename()};
        if (stringArray2[0] == null) {
            stringArray2[0] = this.fresource.getIdentifier();
        }
        try {
            if (this.getCvsManager().status(stringArray2[0]) != 7) {
                this.getCvsManager().remove(stringArray2, "Deleted via HTTP delete method.", stringArray);
            }
        }
        catch (CvsException cvsException) {
            string = "Cvs remove failed : " + cvsException.getMessage();
            this.getServer().errlog((Resource)this, string);
        }
        try {
            this.fresource.delete();
        }
        catch (MultipleLockException multipleLockException) {
            string = "Can't delete resource: " + this.resource.getIdentifier() + " is locked. Try again later.";
            Reply reply = CvsFileFrame.error(request, 403, "Error", string);
            throw new HTTPException(reply);
        }
        return request.makeReply(204);
    }

    public ReplyInterface perform(RequestInterface requestInterface) throws ProtocolException, ResourceException {
        if (!this.checkRequest(requestInterface)) {
            return null;
        }
        String string = ((Request)requestInterface).getMethod();
        if ((string.equals("GET") || string.equals("HEAD") || string.equals("POST") || string.equals("PUT")) && this.isAutoUpdatable() && this.fresource != null) {
            try {
                this.update();
            }
            catch (CvsException cvsException) {
                String string2 = "cvs update \"" + this.getFileResource().getFile().getName() + "\" failed.";
                this.getServer().errlog((Resource)this, string2);
            }
        }
        return super.perform(requestInterface);
    }

    static {
        BooleanAttribute booleanAttribute = null;
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.w3c.jigedit.frames.CvsFileFrame");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        booleanAttribute = new BooleanAttribute("autoupdate", Boolean.FALSE, 2);
        ATTR_AUTOUPDATE = AttributeRegistry.registerAttribute(clazz, (Attribute)booleanAttribute);
    }
}

