/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.jigadmin.RemoteResourceWrapper;
import org.w3c.jigadmin.ResourceClassProperties;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.tools.resources.Attribute;

public class PropertyManager {
    protected File root = null;
    protected File zipfile = null;
    protected Hashtable classProperties = null;
    protected Properties iconProperties = null;
    protected Hashtable mimeTypes = null;
    protected Properties resources = null;
    protected Properties frames = null;
    protected Properties indexers = null;
    private boolean inited = false;
    public static String ROOT_P = "jigadmRoot";
    public static PropertyManager propertyManager = null;

    protected static Properties merge(Properties properties, Properties properties2, boolean bl) {
        Properties properties3 = (Properties)properties.clone();
        Enumeration<Object> enumeration = properties2.keys();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (!bl && properties.get(object) != null) continue;
            Object object2 = properties2.get(object);
            properties3.put(object, object2);
        }
        return properties3;
    }

    protected static Properties merge(Properties properties, Properties properties2) {
        return PropertyManager.merge(properties, properties2, true);
    }

    protected void initialize() {
        Object object;
        Object object2;
        Object object3;
        ZipEntry zipEntry;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.zipfile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        this.classProperties = new Hashtable(11);
        while (enumeration.hasMoreElements()) {
            zipEntry = enumeration.nextElement();
            object3 = zipEntry.getName();
            if (((String)object3).equals("icons" + File.separator) || !zipEntry.isDirectory() || ((String)object3).indexOf(File.separator) != ((String)object3).lastIndexOf(File.separator)) continue;
            object2 = null;
            object2 = new ResourceClassProperties((String)object3, zipFile);
            object = ((String)object3).substring(0, ((String)object3).length() - 1);
            this.classProperties.put(object, object2);
        }
        try {
            zipEntry = zipFile.getEntry("icons.p");
            object3 = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            this.iconProperties = new Properties();
            this.iconProperties.load((InputStream)object3);
            ((InputStream)object3).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mimeTypes = new Hashtable(11);
        try {
            zipEntry = zipFile.getEntry("mimetypes.p");
            object3 = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            object2 = new Properties();
            ((Properties)object2).load((InputStream)object3);
            ((InputStream)object3).close();
            object = ResourceClassProperties.getStringArray((Properties)object2, "Types");
            for (int i = 0; i < ((String[])object).length; ++i) {
                String[] stringArray = ResourceClassProperties.getStringArray((Properties)object2, object[i]);
                this.mimeTypes.put(object[i], stringArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            zipEntry = zipFile.getEntry("resources.p");
            object3 = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            this.resources = new Properties();
            this.resources.load((InputStream)object3);
            ((InputStream)object3).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            zipEntry = zipFile.getEntry("frames.p");
            object3 = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            this.frames = new Properties();
            this.frames.load((InputStream)object3);
            ((InputStream)object3).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            zipEntry = zipFile.getEntry("indexers.p");
            object3 = new BufferedInputStream(zipFile.getInputStream(zipEntry));
            this.indexers = new Properties();
            this.indexers.load((InputStream)object3);
            ((InputStream)object3).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            zipFile.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.inited = true;
    }

    protected ResourceClassProperties getResourceClassProperties(String[] stringArray, int n) {
        ResourceClassProperties resourceClassProperties = null;
        for (int i = n; i < stringArray.length && (resourceClassProperties = (ResourceClassProperties)this.classProperties.get(stringArray[i])) == null; ++i) {
        }
        if (resourceClassProperties == null) {
            throw new RuntimeException("configuration error, no editor for: " + stringArray[0]);
        }
        return resourceClassProperties;
    }

    protected ResourceClassProperties getResourceClassProperties(String[] stringArray) {
        return this.getResourceClassProperties(stringArray, 0);
    }

    protected int findResourceClassProperties(String[] stringArray, int n) {
        ResourceClassProperties resourceClassProperties = null;
        for (int i = n; i < stringArray.length; ++i) {
            resourceClassProperties = (ResourceClassProperties)this.classProperties.get(stringArray[i]);
            if (resourceClassProperties == null) continue;
            return i;
        }
        return -1;
    }

    protected int findResourceClassProperties(String[] stringArray) {
        return this.findResourceClassProperties(stringArray, 0);
    }

    protected String[] getClassHierarchy(RemoteResourceWrapper remoteResourceWrapper) {
        try {
            String[] stringArray = remoteResourceWrapper.getResource().getClassHierarchy();
            return stringArray;
        }
        catch (RemoteAccessException remoteAccessException) {
            remoteAccessException.printStackTrace();
            return new String[0];
        }
    }

    protected Properties getDefaultHelperProperties(String string) {
        ResourceClassProperties resourceClassProperties = null;
        resourceClassProperties = (ResourceClassProperties)this.classProperties.get("defaults");
        if (resourceClassProperties != null) {
            return resourceClassProperties.getHelperProperties(string);
        }
        return null;
    }

    protected Properties getDefaultAttributeProperties(String string) {
        ResourceClassProperties resourceClassProperties = null;
        resourceClassProperties = (ResourceClassProperties)this.classProperties.get("defaults");
        if (resourceClassProperties != null) {
            return resourceClassProperties.getAttributeProperties(string);
        }
        return null;
    }

    public Properties getEditorProperties(RemoteResourceWrapper remoteResourceWrapper) {
        String[] stringArray = this.getClassHierarchy(remoteResourceWrapper);
        return this.getResourceClassProperties(stringArray).getEditorProperties();
    }

    public String getEditorClass(RemoteResourceWrapper remoteResourceWrapper) {
        String[] stringArray = this.getClassHierarchy(remoteResourceWrapper);
        return this.getResourceClassProperties(stringArray).getEditorClass();
    }

    public boolean isEditable(RemoteResourceWrapper remoteResourceWrapper) {
        String[] stringArray = this.getClassHierarchy(remoteResourceWrapper);
        return this.getResourceClassProperties(stringArray).isEditable();
    }

    public boolean isExtensible(RemoteResourceWrapper remoteResourceWrapper) {
        String[] stringArray = this.getClassHierarchy(remoteResourceWrapper);
        return this.getResourceClassProperties(stringArray).isExtensible();
    }

    public String[] getHelperClasses(RemoteResourceWrapper remoteResourceWrapper) {
        String[] stringArray = this.getClassHierarchy(remoteResourceWrapper);
        int n = this.findResourceClassProperties(stringArray);
        if (n < 0) {
            return new String[0];
        }
        ResourceClassProperties resourceClassProperties = this.getResourceClassProperties(stringArray);
        Vector<String[]> vector = new Vector<String[]>();
        vector.addElement(resourceClassProperties.getHelperClasses());
        while (resourceClassProperties.aggregateHelpers() && ++n < stringArray.length && (n = this.findResourceClassProperties(stringArray, n)) >= 0) {
            resourceClassProperties = this.getResourceClassProperties(stringArray, n);
            vector.addElement(resourceClassProperties.getHelperClasses());
        }
        if (vector.size() == 1) {
            return (String[])vector.elementAt(0);
        }
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            n2 += ((String[])vector.elementAt(i)).length;
        }
        String[] stringArray2 = new String[n2];
        for (int i = 0; i < vector.size(); ++i) {
            String[] stringArray3 = (String[])vector.elementAt(i);
            for (int j = 0; j < stringArray3.length; ++j) {
                stringArray2[n3++] = stringArray3[j];
            }
        }
        return stringArray2;
    }

    public Properties getHelperProperties(RemoteResourceWrapper remoteResourceWrapper, String string) {
        String[] stringArray = this.getClassHierarchy(remoteResourceWrapper);
        int n = this.findResourceClassProperties(stringArray);
        if (n < 0) {
            return new Properties();
        }
        ResourceClassProperties resourceClassProperties = this.getResourceClassProperties(stringArray);
        Properties properties = resourceClassProperties.getHelperProperties(string);
        while (resourceClassProperties.aggregateHelpers() && ++n < stringArray.length && (n = this.findResourceClassProperties(stringArray, n)) >= 0) {
            resourceClassProperties = this.getResourceClassProperties(stringArray, n);
            Properties properties2 = resourceClassProperties.getHelperProperties(string);
            if (properties2 == null) continue;
            properties = properties != null ? PropertyManager.merge(properties, properties2, false) : properties2;
        }
        return properties == null ? new Properties() : properties;
    }

    public Properties getAttributeProperties(RemoteResourceWrapper remoteResourceWrapper, Attribute attribute) {
        Properties properties;
        String[] stringArray = this.getClassHierarchy(remoteResourceWrapper);
        String string = attribute.getClass().getName();
        int n = this.findResourceClassProperties(stringArray);
        if (n < 0) {
            return new Properties();
        }
        ResourceClassProperties resourceClassProperties = this.getResourceClassProperties(stringArray);
        Properties properties2 = resourceClassProperties.getAttributeProperties(attribute.getName());
        if (properties2 == null) {
            properties2 = new Properties();
        }
        if ((properties = this.getDefaultAttributeProperties(string)) != null) {
            properties2 = PropertyManager.merge(properties, properties2);
        }
        while (resourceClassProperties.aggregateAttributeProperties() && ++n < stringArray.length && (n = this.findResourceClassProperties(stringArray, n)) >= 0) {
            resourceClassProperties = this.getResourceClassProperties(stringArray, n);
            Properties properties3 = resourceClassProperties.getAttributeProperties(attribute.getName());
            if (properties3 == null) continue;
            properties2 = PropertyManager.merge(properties3, properties2);
        }
        return properties2;
    }

    public String getIconLocation(String string) {
        String string2 = this.iconProperties.getProperty(string);
        if (string2 != null) {
            boolean bl = this.iconProperties.getProperty("relative").equals("true");
            return bl ? this.root.getAbsolutePath() + File.separator + "icons" + File.separator + string2 : string2;
        }
        return null;
    }

    public Hashtable getMimeTypes() {
        return this.mimeTypes;
    }

    public Hashtable getResources() {
        return this.resources;
    }

    public Hashtable getIndexers() {
        return this.indexers;
    }

    public Hashtable getFrames() {
        return this.frames;
    }

    public static PropertyManager getPropertyManager() {
        if (propertyManager == null) {
            Properties properties = System.getProperties();
            String string = properties.getProperty(ROOT_P);
            propertyManager = string == null ? new PropertyManager(new File(properties.getProperty("user.dir") + File.separator + "config" + File.separator + "jigadmin.zip"), new File(properties.getProperty("user.dir") + File.separator + "config")) : new PropertyManager(new File(string + File.separator + "config" + File.separator + "jigadmin.zip"), new File(string + File.separator + "config"));
        }
        return propertyManager;
    }

    public PropertyManager(File file, File file2) {
        this.root = file2;
        this.zipfile = file;
        this.initialize();
        if (!this.inited) {
            System.out.println("PropertyManager: unable to initialize.");
            System.out.println("\tCouldn't find mandatory properties in \"" + file2 + "\" use the \"-root\" option or run " + "jigadmin from Jigsaw root directory.");
            System.exit(1);
        }
    }
}

