/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.editors;

import java.util.Properties;
import java.util.Vector;
import org.w3c.jigadmin.RemoteResourceWrapper;
import org.w3c.jigadmin.editors.ControlServerHelper;
import org.w3c.jigadmin.editors.ServerEditor;
import org.w3c.jigadmin.editors.ServerEditorInterface;
import org.w3c.jigadmin.editors.ServerHelperFactory;
import org.w3c.jigadmin.editors.ServerHelperInterface;
import org.w3c.jigadmin.events.ResourceActionEvent;
import org.w3c.jigadmin.events.ResourceActionListener;
import org.w3c.jigadmin.gui.Message;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;

public class AdminServerEditor
extends ServerEditor
implements ServerEditorInterface,
ResourceActionListener {
    protected static final String CONTROL_NAME = "control";
    protected static final String REALMS_NAME = "realms";
    private RemoteResource[] controls = null;

    protected void initializeServerHelpers() throws RemoteAccessException {
        this.shelpers = new ServerHelperInterface[2];
        RemoteResourceWrapper remoteResourceWrapper = this.server.getChildResource(CONTROL_NAME);
        this.shelpers[0] = ServerHelperFactory.getServerHelper(CONTROL_NAME, remoteResourceWrapper);
        ControlServerHelper controlServerHelper = (ControlServerHelper)this.shelpers[0];
        controlServerHelper.setResOpEnabled(false);
        controlServerHelper.setSaveToolTipText("Save all servers configuration");
        controlServerHelper.setStopToolTipText("Stop all servers");
        controlServerHelper.addResourceActionListener(this);
        remoteResourceWrapper = this.server.getChildResource(REALMS_NAME);
        this.shelpers[1] = ServerHelperFactory.getServerHelper(REALMS_NAME, remoteResourceWrapper);
    }

    protected RemoteResource[] getControls() throws RemoteAccessException {
        if (this.controls == null) {
            RemoteResource remoteResource = this.server.getResource();
            String[] stringArray = remoteResource.enumerateResourceIdentifiers();
            Vector<RemoteResource> vector = new Vector<RemoteResource>(2);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(CONTROL_NAME) || stringArray[i].equals(REALMS_NAME)) continue;
                RemoteResource remoteResource2 = remoteResource.loadResource(stringArray[i]);
                RemoteResource remoteResource3 = remoteResource2.loadResource(CONTROL_NAME);
                vector.addElement(remoteResource3);
            }
            this.controls = new RemoteResource[vector.size()];
            vector.copyInto(this.controls);
        }
        return this.controls;
    }

    public void resourceActionPerformed(ResourceActionEvent resourceActionEvent) {
        switch (resourceActionEvent.getResourceActionCommand()) {
            case 40: {
                try {
                    RemoteResource[] remoteResourceArray = this.getControls();
                    for (int i = 0; i < remoteResourceArray.length; ++i) {
                        remoteResourceArray[i].loadResource("save");
                    }
                    break;
                }
                catch (RemoteAccessException remoteAccessException) {
                    Message.showErrorMessage(this.server, remoteAccessException);
                    break;
                }
            }
            case 50: {
                try {
                    RemoteResource[] remoteResourceArray = this.getControls();
                    for (int i = 0; i < remoteResourceArray.length; ++i) {
                        remoteResourceArray[i].loadResource("stop");
                    }
                    break;
                }
                catch (RemoteAccessException remoteAccessException) {
                    Message.showErrorMessage(this.server, remoteAccessException);
                    break;
                }
            }
        }
    }

    public void initialize(String string, RemoteResourceWrapper remoteResourceWrapper, Properties properties) {
        super.initialize(string, remoteResourceWrapper, properties);
        this.setServer(remoteResourceWrapper);
    }
}

