/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.jigadm.RemoteResourceWrapper;
import org.w3c.jigadm.editors.AttributeEditor;
import org.w3c.jigadm.events.ResourceChangeEvent;
import org.w3c.jigadmin.PropertyManager;
import org.w3c.jigadmin.editors.AttributeEditorFactory;
import org.w3c.jigadmin.editors.ResourceHelper;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.jigsaw.admin.RemoteResource;
import org.w3c.tools.resources.serialization.AttributeDescription;
import org.w3c.tools.widgets.Utilities;

public class AttributesHelper
extends ResourceHelper {
    ActionListener al = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals(AttributesHelper.RESET_L)) {
                AttributesHelper.this.resetChanges();
            } else if (actionEvent.getActionCommand().equals(AttributesHelper.COMMIT_L)) {
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            AttributesHelper.this.commitChanges();
                        }
                        catch (RemoteAccessException remoteAccessException) {
                            AttributesHelper.this.errorPopup("RemoteAccessException", (Exception)((Object)remoteAccessException));
                        }
                    }
                };
                AttributesHelper.this.setMessage("Committing...");
                thread.start();
                AttributesHelper.this.setMessage("Commit done.");
            }
        }
    };
    MouseAdapter ma = new MouseAdapter(){

        public void mouseEntered(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof JButton) {
                String string = ((JButton)component).getActionCommand();
                if (string.equals(AttributesHelper.COMMIT_L)) {
                    AttributesHelper.this.setMessage("Commit the changes to the server.");
                } else if (string.equals(AttributesHelper.RESET_L)) {
                    AttributesHelper.this.setMessage("Reset changes");
                }
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            AttributesHelper.this.setMessage("");
        }
    };
    private org.w3c.jigadmin.RemoteResourceWrapper rrw = null;
    private AttributeDescription[] a = null;
    private AttributeEditor[] ae = null;
    private boolean initialized = false;
    protected static final String COMMIT_L = "Commit";
    protected static final String RESET_L = "Reset";
    JPanel widget = new JPanel(new BorderLayout());
    JLabel message;

    public void setMessage(String string) {
        this.message.setText(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitChanges() throws RemoteAccessException {
        int n;
        if (!this.initialized) {
            return;
        }
        int n2 = 0;
        for (n = 0; n < this.ae.length; ++n) {
            if (!this.ae[n].hasChanged()) continue;
            ++n2;
        }
        String[] stringArray = new String[n2];
        Object[] objectArray = new Object[n2];
        n2 = 0;
        for (int i = 0; i < this.ae.length; ++i) {
            if (!this.ae[i].hasChanged()) continue;
            stringArray[n2] = this.a[i].getName();
            objectArray[n2] = this.ae[i].getValue();
            if (stringArray[n2].equals("identifier")) {
                if (this.rrw.getBrowser() != null) {
                    this.rrw.getBrowser().renameNode((RemoteResourceWrapper)this.rrw, (String)objectArray[n2]);
                }
                this.processEvent((EventObject)new ResourceChangeEvent((Object)this.rrw, "identifier", null, objectArray[n2]));
            }
            ++n2;
        }
        n = 0;
        while (n == 0) {
            try {
                n = 1;
                this.rrw.getResource().setValues(stringArray, objectArray);
            }
            catch (RemoteAccessException remoteAccessException) {
                if (remoteAccessException.getMessage().equals("Unauthorized")) {
                    n = 0;
                    continue;
                }
                throw remoteAccessException;
            }
            finally {
                if (n != 0) continue;
                this.rrw.getServerBrowser().popupPasswdDialog("admin");
            }
        }
        this.clearChanged();
    }

    public boolean hasChanged() {
        if (this.ae == null) {
            return false;
        }
        boolean bl = false;
        for (int i = 0; !bl && i < this.ae.length; ++i) {
            bl = this.ae[i].hasChanged();
        }
        return bl;
    }

    public void resetChanges() {
        if (this.ae == null) {
            return;
        }
        for (int i = 0; i < this.ae.length; ++i) {
            if (!this.ae[i].hasChanged()) continue;
            this.ae[i].resetChanges();
        }
    }

    public void clearChanged() {
        if (this.ae == null) {
            return;
        }
        for (int i = 0; i < this.ae.length; ++i) {
            if (!this.ae[i].hasChanged()) continue;
            this.ae[i].clearChanged();
        }
    }

    public Component getComponent() {
        return this.widget;
    }

    public final String getTitle() {
        return "Attribute";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(RemoteResourceWrapper remoteResourceWrapper, Properties properties) throws RemoteAccessException {
        Object object;
        Serializable serializable;
        Object object2;
        int n;
        if (this.initialized) {
            return;
        }
        AttributeDescription[] attributeDescriptionArray = null;
        Object var5_4 = null;
        int n2 = 0;
        this.rrw = (org.w3c.jigadmin.RemoteResourceWrapper)remoteResourceWrapper;
        RemoteResource remoteResource = this.rrw.getResource();
        boolean bl = false;
        while (!bl) {
            try {
                bl = true;
                attributeDescriptionArray = remoteResource.getAttributes();
            }
            catch (RemoteAccessException remoteAccessException) {
                if (remoteAccessException.getMessage().equals("Unauthorized")) {
                    bl = false;
                    continue;
                }
                throw remoteAccessException;
            }
            finally {
                if (bl) continue;
                this.rrw.getServerBrowser().popupPasswdDialog("admin");
            }
        }
        for (n = 0; n < attributeDescriptionArray.length; ++n) {
            if (attributeDescriptionArray[n] == null) {
                ++n2;
                continue;
            }
            if (attributeDescriptionArray[n].getAttribute().checkFlag(2)) continue;
            ++n2;
        }
        this.a = new AttributeDescription[attributeDescriptionArray.length - n2];
        this.ae = new AttributeEditor[this.a.length];
        n = 0;
        for (int i = 0; i < attributeDescriptionArray.length; ++i) {
            if (attributeDescriptionArray[i] == null || !attributeDescriptionArray[i].getAttribute().checkFlag(2)) continue;
            this.a[n++] = attributeDescriptionArray[i];
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = Utilities.insets4;
        for (int i = 0; i < this.a.length; ++i) {
            if (this.a[i] == null) continue;
            object2 = PropertyManager.getPropertyManager();
            serializable = ((PropertyManager)object2).getAttributeProperties(this.rrw, this.a[i].getAttribute());
            object = (String)((Properties)serializable).get("label");
            if (object == null) {
                object = this.a[i].getName();
            }
            JLabel jLabel = new JLabel((String)object, 4);
            this.ae[i] = AttributeEditorFactory.getEditor(this.rrw, this.a[i].getAttribute());
            bl = false;
            while (!bl) {
                try {
                    bl = true;
                    this.ae[i].initialize((RemoteResourceWrapper)this.rrw, this.a[i].getAttribute(), this.a[i].getValue(), (Properties)serializable);
                }
                catch (RemoteAccessException remoteAccessException) {
                    if (remoteAccessException.getMessage().equals("Unauthorized")) {
                        bl = false;
                        continue;
                    }
                    throw remoteAccessException;
                }
                finally {
                    if (bl) continue;
                    this.rrw.getServerBrowser().popupPasswdDialog("admin");
                }
            }
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(jLabel, gridBagConstraints);
            jPanel.add(jLabel);
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.ae[i].getComponent(), gridBagConstraints);
            jPanel.add(this.ae[i].getComponent());
        }
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        this.widget.add("Center", jScrollPane);
        object2 = new JPanel(new BorderLayout());
        serializable = new JButton(COMMIT_L);
        object = new JButton(RESET_L);
        ((Component)serializable).addMouseListener(this.ma);
        ((Component)object).addMouseListener(this.ma);
        ((AbstractButton)serializable).addActionListener(this.al);
        ((AbstractButton)object).addActionListener(this.al);
        this.message = new JLabel("", 0);
        this.message.setForeground(Color.white);
        this.message.setBackground(Color.gray);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createBevelBorder(1));
        jPanel2.add("Center", this.message);
        ((Container)object2).add("West", (Component)serializable);
        ((Container)object2).add("Center", jPanel2);
        ((Container)object2).add("East", (Component)object);
        this.widget.add("South", (Component)object2);
        String[] stringArray = new String[]{""};
        try {
            stringArray = remoteResource.getClassHierarchy();
        }
        catch (RemoteAccessException remoteAccessException) {
            remoteAccessException.printStackTrace();
        }
        JLabel jLabel = new JLabel("Class: " + stringArray[0], 0);
        jLabel.setForeground(new Color(0, 0, 128));
        this.widget.add("North", jLabel);
        this.initialized = true;
    }
}

