/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.editors;

import java.util.Hashtable;
import org.w3c.jigadmin.PropertyManager;
import org.w3c.jigadmin.RemoteResourceWrapper;
import org.w3c.jigadmin.editors.ServerEditorInterface;
import org.w3c.jigadmin.gui.ServerBrowser;

public class ServerEditorFactory {
    private static Hashtable editors = new Hashtable(5);

    public static String getIdentifier(String string, ServerBrowser serverBrowser) {
        return string + String.valueOf(serverBrowser.hashCode());
    }

    public static ServerEditorInterface getServerEditor(String string, ServerBrowser serverBrowser, RemoteResourceWrapper remoteResourceWrapper) {
        PropertyManager propertyManager = PropertyManager.getPropertyManager();
        String string2 = propertyManager.getEditorClass(remoteResourceWrapper);
        if (string2 == null) {
            return null;
        }
        ServerEditorInterface serverEditorInterface = (ServerEditorInterface)editors.get(string + serverBrowser);
        if (serverEditorInterface == null) {
            try {
                Class<?> clazz = Class.forName(string2);
                Object obj = clazz.newInstance();
                if (!(obj instanceof ServerEditorInterface)) {
                    throw new RuntimeException(string2 + " doesn't " + "implements ServerEditorInterface.");
                }
                serverEditorInterface = (ServerEditorInterface)obj;
                serverEditorInterface.initialize(string, remoteResourceWrapper, propertyManager.getEditorProperties(remoteResourceWrapper));
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException("cannot create editor: " + string2 + " for \"" + string);
            }
            editors.put(ServerEditorFactory.getIdentifier(string, serverBrowser), serverEditorInterface);
        } else {
            serverEditorInterface.setServer(remoteResourceWrapper);
        }
        return serverEditorInterface;
    }

    public static void updateServerEditor(String string, ServerBrowser serverBrowser, RemoteResourceWrapper remoteResourceWrapper) {
        ServerEditorInterface serverEditorInterface = (ServerEditorInterface)editors.get(ServerEditorFactory.getIdentifier(string, serverBrowser));
        if (serverEditorInterface != null) {
            serverEditorInterface.setServer(remoteResourceWrapper);
        }
    }
}

