/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class StructurePanel
extends Panel {
    static final long serialVersionUID = 3720815111234515113L;
    private transient PropertyChangeSupport propertyChange = new PropertyChangeSupport(this);
    private transient FontMetrics fm = null;
    private transient int intInsets = 0;
    private int intSpacer = 4;
    private String fieldBorderText = new String();
    private Font fieldBorderFont = new Font("dialog", 0, 12);
    private Color fieldBorderColor = Color.lightGray;
    private Color fieldBorderFontColor = Color.black;
    private boolean blnFrameVisible = true;

    public StructurePanel() {
        this.setBackground(SystemColor.activeCaptionBorder);
    }

    public StructurePanel(LayoutManager layout) {
        super(layout);
        this.setBackground(SystemColor.activeCaptionBorder);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChange != null) {
            this.propertyChange.addPropertyChangeListener(listener);
        }
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyChange != null) {
            this.propertyChange.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public Color getBorderColor() {
        return this.fieldBorderColor;
    }

    public Font getBorderFont() {
        return this.fieldBorderFont;
    }

    public Color getBorderFontColor() {
        return this.fieldBorderFontColor;
    }

    public String getBorderText() {
        return this.fieldBorderText;
    }

    public Insets getInsets() {
        if (this.fm == null) {
            this.fm = this.getToolkit().getFontMetrics(this.fieldBorderFont);
            if (this.fm == null) {
                this.fm = Toolkit.getDefaultToolkit().getFontMetrics(this.fieldBorderFont);
            }
        }
        Insets i = null;
        if (this.fieldBorderText.length() == 0) {
            this.intInsets = this.intSpacer;
            i = new Insets(2 * this.intInsets, 2 * this.intInsets, 2 * this.intInsets, 2 * this.intInsets);
        } else {
            this.intInsets = this.intSpacer + this.fm.getHeight() / 4;
            i = new Insets(2 * this.intInsets, 2 * this.intInsets, 2 * this.intInsets, 2 * this.intInsets);
        }
        return i;
    }

    public int getSpacer() {
        return this.intSpacer;
    }

    public void paint(Graphics g) {
        if (g == null) {
            return;
        }
        try {
            this.getInsets();
            Dimension d = this.getSize();
            if (this.blnFrameVisible) {
                g.setColor(this.fieldBorderColor);
                g.draw3DRect(this.intInsets, this.intInsets, d.width - 2 * this.intInsets - 1, d.height - 2 * this.intInsets - 1, false);
            } else {
                g.setColor(this.getBackground());
            }
            if (this.fieldBorderText.length() == 0) {
                return;
            }
            g.clearRect(15, this.intInsets, this.fm.stringWidth(this.fieldBorderText) + 10, 1);
            g.setFont(this.fieldBorderFont);
            g.setColor(this.fieldBorderFontColor);
            g.drawString(this.fieldBorderText, 20, this.intInsets + (this.fm.getAscent() + this.fm.getLeading()) / 2);
        }
        catch (Throwable throwable) {
            super.paint(g);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChange.removePropertyChangeListener(listener);
    }

    public void setBorderColor(Color borderColor) {
        Color oldValue = this.fieldBorderColor;
        this.fieldBorderColor = borderColor;
        this.firePropertyChange("borderColor", oldValue, borderColor);
        this.repaint();
    }

    public void setBorderFont(Font borderFont) {
        Font oldValue = this.fieldBorderFont;
        this.fieldBorderFont = borderFont;
        this.firePropertyChange("borderFont", oldValue, borderFont);
        this.repaint();
    }

    public void setBorderFontColor(Color borderFontColor) {
        Color oldValue = this.fieldBorderFontColor;
        this.fieldBorderFontColor = borderFontColor;
        this.firePropertyChange("borderFontColor", oldValue, borderFontColor);
        this.repaint();
    }

    public void setBorderText(String borderText) {
        String oldValue = this.fieldBorderText;
        this.fieldBorderText = borderText;
        this.firePropertyChange("borderText", oldValue, borderText);
        this.setSpacer(this.getSpacer());
        this.repaint();
    }

    public void setEnabled(boolean b) {
        Component[] cmp = this.getComponents();
        int i = 0;
        while (i < cmp.length) {
            cmp[i].setEnabled(b);
            ++i;
        }
        super.setEnabled(b);
    }

    public void setFrameVisible(boolean b) {
        this.blnFrameVisible = b;
    }

    public void setSpacer(int i) {
        this.intSpacer = i;
        this.invalidate();
        this.doLayout();
        if (this.getParent() != null) {
            this.getParent().doLayout();
        }
    }
}

