/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.classloader;

import de.zwanzigeins.classloader.ClassPathEntry;
import de.zwanzigeins.util.ByteString;
import de.zwanzigeins.util.LogContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ExtendedClassLoader
extends ClassLoader {
    private static final String CLASSPATH_SEPARATOR = ";";
    private Vector vecClassPath = null;
    private Hashtable hshClassCache = null;
    private LogContext log = null;
    private String strLogPrefix = "";

    public ExtendedClassLoader(String strClassPath, String strLogPrefix, LogContext log) {
        this.log = log;
        this.strLogPrefix = strLogPrefix;
        this.init0(strClassPath);
    }

    private Vector appendClassPath(String string) {
        Vector v = (Vector)this.vecClassPath.clone();
        if (string.length() > 0) {
            String str = this.platformPath(string);
            if (!str.endsWith(File.separator)) {
                str = String.valueOf(str) + File.separator;
            }
            ClassPathEntry cp = new ClassPathEntry();
            cp.strPath = str;
            cp.blnIsArchive = false;
            v.insertElementAt(cp, 0);
        }
        return v;
    }

    public boolean classLoaded(String strClass) {
        return this.hshClassCache.containsKey(strClass);
    }

    private void close(Object o) {
        try {
            if (o instanceof InputStream) {
                ((InputStream)o).close();
                return;
            }
            if (o instanceof OutputStream) {
                ((OutputStream)o).close();
                return;
            }
            if (o instanceof Writer) {
                ((Writer)o).close();
                return;
            }
            if (o instanceof Reader) {
                ((Reader)o).close();
                return;
            }
            if (o instanceof ZipFile) {
                ((ZipFile)o).close();
                return;
            }
        }
        catch (IOException iOException) {}
    }

    public void dispose() {
        this.log("Disposing Classloader");
        if (this.vecClassPath != null) {
            int i = 0;
            while (i < this.vecClassPath.size()) {
                ClassPathEntry cp = (ClassPathEntry)this.vecClassPath.elementAt(i);
                if (cp.zf != null) {
                    this.close(cp.zf);
                }
                ++i;
            }
            this.vecClassPath.removeAllElements();
            this.vecClassPath = null;
        }
        if (this.hshClassCache != null) {
            this.hshClassCache.clear();
            this.hshClassCache = null;
        }
    }

    private String getDirectory(String string) {
        if (string.length() == 0) {
            return string;
        }
        String strFile = string.replace('\\', File.separatorChar);
        strFile = strFile.replace('/', File.separatorChar);
        File f = null;
        int i = 0;
        while (i < 2) {
            if (!strFile.endsWith(File.separator)) {
                strFile = String.valueOf(strFile) + File.separator;
            }
            if ((f = new File(strFile)).isDirectory()) {
                return strFile;
            }
            int pp = (strFile = strFile.substring(0, strFile.length() - 1)).lastIndexOf(File.separator);
            if (pp == -1) {
                return "";
            }
            strFile = strFile.substring(0, pp);
            ++i;
        }
        return null;
    }

    public URL getResource(String strFile) {
        return this.getResource(strFile, "");
    }

    public URL getResource(String string, String strAddClassPath) {
        String strFile = this.platformPath(string);
        if (strFile.startsWith(File.separator)) {
            strFile = strFile.substring(1);
        }
        URL url = null;
        url = ClassLoader.getSystemResource(strFile);
        if (url != null) {
            return url;
        }
        Vector v = this.appendClassPath(strAddClassPath);
        int i = 0;
        while (i < v.size()) {
            ClassPathEntry cp = (ClassPathEntry)v.elementAt(i);
            if (cp.blnIsArchive) {
                Object var8_9;
                ZipFile zf = null;
                try {
                    try {
                        zf = new ZipFile(new File(cp.strPath));
                        ZipEntry ze = zf.getEntry(strFile);
                        if (ze != null) {
                            url = new URL("jar:" + cp.strPath + "!/" + strFile);
                        }
                    }
                    catch (ZipException zipException) {
                    }
                    catch (MalformedURLException e) {
                        this.log("Bad URL", e);
                    }
                    catch (IOException iOException) {}
                }
                catch (Throwable throwable) {
                    var8_9 = null;
                    this.close(zf);
                    throw throwable;
                }
                var8_9 = null;
                this.close(zf);
            } else {
                try {
                    url = new URL("file:" + cp.strPath + strFile);
                }
                catch (MalformedURLException e) {
                    this.log("Bad URL", e);
                }
            }
            ++i;
        }
        return url;
    }

    public InputStream getResourceAsStream(String strFile) {
        return this.getResourceAsStream(strFile, "");
    }

    public InputStream getResourceAsStream(String string, String strAddClassPath) {
        String strFile = this.platformPath(string);
        if (strFile.startsWith(File.separator)) {
            strFile = strFile.substring(1);
        }
        InputStream in = null;
        in = ClassLoader.getSystemResourceAsStream(strFile);
        if (in != null) {
            return in;
        }
        Vector v = this.appendClassPath(strAddClassPath);
        int i = 0;
        while (i < v.size()) {
            ClassPathEntry cp = (ClassPathEntry)v.elementAt(i);
            if (cp.blnIsArchive) {
                ZipFile zf = null;
                try {
                    cp.zf = zf = new ZipFile(new File(cp.strPath));
                    ZipEntry ze = zf.getEntry(strFile);
                    if (ze != null) {
                        in = zf.getInputStream(ze);
                    }
                }
                catch (Exception exception) {
                    this.close(in);
                    this.close(zf);
                }
            } else {
                try {
                    in = new FileInputStream(new File(cp.strPath, strFile));
                }
                catch (IOException iOException) {
                    this.close(in);
                }
            }
            if (in != null) break;
            ++i;
        }
        return in;
    }

    private void init0(String string) {
        ClassPathEntry cpe;
        String strClassPath;
        if (!string.endsWith(CLASSPATH_SEPARATOR)) {
            strClassPath = String.valueOf(string) + CLASSPATH_SEPARATOR;
        }
        this.vecClassPath = new Vector(1, 1);
        StringTokenizer strt = new StringTokenizer(strClassPath, CLASSPATH_SEPARATOR);
        while (strt.hasMoreTokens()) {
            cpe = new ClassPathEntry();
            String strFile = strt.nextToken();
            String strDir = this.getDirectory(strFile);
            if (strDir == null) {
                this.log("Classpath " + strFile + " isn't a valid directory or file, ignored");
                continue;
            }
            cpe.strPath = strFile;
            cpe.blnIsArchive = false;
            this.vecClassPath.addElement(cpe);
        }
        if (this.vecClassPath.size() == 0) {
            cpe = new ClassPathEntry();
            cpe.strPath = ".";
            cpe.blnIsArchive = false;
            this.vecClassPath.addElement(cpe);
        }
        int i = 0;
        while (i < this.vecClassPath.size()) {
            ClassPathEntry cpe2 = (ClassPathEntry)this.vecClassPath.elementAt(i);
            File f = new File(cpe2.strPath);
            if (!f.exists()) {
                this.log(String.valueOf(f.getPath()) + " is not a valid file/directory");
            } else if (!f.canRead()) {
                this.log.write("? " + f.getPath() + " is not readable");
            } else {
                if (f.isFile()) {
                    try {
                        ZipFile zf = new ZipFile(f);
                        zf.close();
                        cpe2.blnIsArchive = true;
                    }
                    catch (Throwable throwable) {
                        cpe2.blnIsArchive = false;
                    }
                }
                this.log("Added " + cpe2.toString() + " to container classpath");
            }
            ++i;
        }
        this.hshClassCache = new Hashtable();
    }

    protected Class loadClass(String strClass, boolean blnResolve) throws ClassNotFoundException {
        Class cls = (Class)this.hshClassCache.get(strClass);
        if (cls != null) {
            this.log("Loaded " + strClass + " from cache");
        }
        if (cls == null) {
            int i = 0;
            while (i < this.vecClassPath.size()) {
                ClassPathEntry cp = (ClassPathEntry)this.vecClassPath.elementAt(i);
                cls = cp.blnIsArchive ? this.loadFromZip(strClass, cp.strPath) : this.loadFromFile(strClass, cp.strPath);
                if (cls != null) {
                    this.log("Loaded " + strClass + " from containerpath");
                    break;
                }
                ++i;
            }
        }
        if (cls == null) {
            try {
                cls = this.findSystemClass(strClass);
            }
            catch (Throwable throwable) {
                cls = null;
            }
            if (cls != null) {
                this.log("Loaded " + strClass + " from systempath");
            }
        }
        if (cls == null) {
            this.hshClassCache.remove(strClass);
            this.log("Cannot find class " + strClass);
            throw new ClassNotFoundException(strClass);
        }
        if (blnResolve) {
            this.resolveClass(cls);
        }
        this.hshClassCache.put(strClass, cls);
        return cls;
    }

    private Class loadFromFile(String strClass, String strPath) {
        String strFile = strClass.replace('.', File.separatorChar);
        strFile = String.valueOf(strFile) + ".class";
        while (!Character.isJavaIdentifierStart(strFile.charAt(0))) {
            strFile = strFile.substring(1);
        }
        FileInputStream in = null;
        Class cls = null;
        try {
            try {
                in = new FileInputStream(new File(strPath, strFile));
                cls = this.loadFromStream(strClass, in);
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.close(in);
            throw throwable;
        }
        Object var6_8 = null;
        this.close(in);
        return cls;
    }

    private Class loadFromStream(String strClass, InputStream in) {
        ByteString bs = new ByteString(8192);
        byte[] buffer = new byte[512];
        int i = -1;
        try {
            while ((i = in.read(buffer)) != -1) {
                bs.append(buffer, 0, i);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        if (bs.getLength() == 0) {
            return null;
        }
        return this.defineClass(strClass, bs.getInternalByteArray(), 0, bs.getLength());
    }

    private Class loadFromZip(String strClass, String strArchive) {
        String strFile = strClass.replace('.', '/');
        strFile = String.valueOf(strFile) + ".class";
        ZipFile zf = null;
        InputStream in = null;
        Class cls = null;
        try {
            try {
                zf = new ZipFile(new File(strArchive));
                ZipEntry ze = zf.getEntry(strFile);
                if (ze != null) {
                    in = zf.getInputStream(ze);
                    cls = this.loadFromStream(strClass, in);
                }
            }
            catch (ZipException zipException) {
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.close(in);
            this.close(zf);
            throw throwable;
        }
        Object var7_10 = null;
        this.close(in);
        this.close(zf);
        return cls;
    }

    private void log(String s) {
        if (this.log == null) {
            return;
        }
        this.log.write(String.valueOf(this.strLogPrefix) + " " + s);
    }

    private void log(String s, Throwable t) {
        if (this.log == null) {
            return;
        }
        this.log.write(String.valueOf(this.strLogPrefix) + " " + s, t);
    }

    private String platformPath(String string) {
        if (string == null) {
            return null;
        }
        String strPath = string.replace('\\', File.separatorChar);
        strPath = strPath.replace('/', File.separatorChar);
        return strPath;
    }

    public void setLogContext(LogContext log) {
        this.log = log;
    }
}

