/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.io;

import de.zwanzigeins.util.Encoding;
import de.zwanzigeins.util.HelperIO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends InputStream {
    private BufferedReader brIn = null;
    private Encoding enc = null;
    private byte[] buffer = new byte[80];
    private int intBufferPos = -1;
    private int intBufferSize = -1;
    private boolean blnEOF = false;

    public Base64InputStream(BufferedReader brIn) {
        this.brIn = brIn;
        this.enc = Encoding.createEncodingInstance("base64");
        this.intBufferPos = this.buffer.length;
        this.intBufferSize = this.buffer.length;
        this.enc.startDecode(true);
    }

    public void close() {
        HelperIO.close(this.brIn);
    }

    public int read() throws IOException {
        if (this.blnEOF) {
            return -1;
        }
        if (this.intBufferPos == this.intBufferSize) {
            String s = this.brIn.readLine();
            if (s == null || s.length() == 0 || s.startsWith("[") && s.indexOf("],^") != -1) {
                HelperIO.close(this.brIn);
                this.blnEOF = true;
                return -1;
            }
            this.enc.setInput(s.getBytes(), 0, s.length());
            this.intBufferSize = this.enc.convert(this.buffer, 0, this.buffer.length);
            this.intBufferPos = 0;
        }
        return this.buffer[this.intBufferPos++];
    }
}

