/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class CRLFInputStream
extends InputStream {
    private InputStream in = null;
    private int intPushback = -1;
    private long lngBytesRead = 0L;
    private char chEOL;
    private StringBuffer strbLine = null;
    private int intExpectedLineLength = -1;

    public CRLFInputStream(InputStream in) {
        this(in, '\n', 255);
    }

    public CRLFInputStream(InputStream in, char ch, int intExpectedLineLength) {
        this.in = in;
        this.chEOL = ch;
        this.intExpectedLineLength = intExpectedLineLength;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public long getBytesRead() {
        return this.lngBytesRead;
    }

    public char getEOLChar() {
        return this.chEOL;
    }

    public static void main(String[] args) throws Throwable {
        int i;
        File in = new File("\\request.$$$");
        File out = new File("\\xx");
        CRLFInputStream crlfin = new CRLFInputStream(new FileInputStream(in));
        FileOutputStream flout = new FileOutputStream(out);
        byte[] cfr_ignored_0 = new byte[256];
        while ((i = crlfin.readCRLF()) != -1) {
            flout.write(i);
        }
        crlfin.close();
        flout.close();
        System.out.println(crlfin.getBytesRead());
    }

    public void mark(int i) {
        this.in.mark(i);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    public int read() throws IOException {
        int i = this.intPushback;
        if (i == -1) {
            i = this.in.read();
        }
        if (i != -1) {
            ++this.lngBytesRead;
        }
        return i;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int ofs, int len) throws IOException {
        int i = this.intPushback;
        if (i == -1) {
            i = this.in.read(buf, ofs, len);
        } else {
            buf[0] = (byte)(this.intPushback & 0xFF);
            i = this.in.read(buf, ofs + 1, len - 1);
            if (i != -1) {
                ++i;
            }
        }
        if (i != -1) {
            this.lngBytesRead += (long)i;
        }
        return i;
    }

    public int readCRLF() throws IOException {
        int i = this.intPushback;
        if (i != -1) {
            this.intPushback = -1;
        } else {
            i = this.in.read();
            if (i != -1) {
                ++this.lngBytesRead;
            }
        }
        if (i == 13) {
            this.intPushback = this.in.read();
            if (i != -1) {
                ++this.lngBytesRead;
            }
            if (this.intPushback == 10) {
                this.intPushback = -1;
            }
        }
        if (i == 13 || i == 10) {
            i = this.chEOL;
        }
        return i;
    }

    public String readCRLFLine() throws IOException {
        if (this.strbLine == null) {
            this.strbLine = new StringBuffer(this.intExpectedLineLength);
        } else {
            this.strbLine.setLength(0);
        }
        int intChar = 0;
        while ((intChar = this.readCRLF()) != -1 && intChar != this.chEOL) {
            this.strbLine.append((char)intChar);
        }
        return this.strbLine.toString();
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public void resetBytesRead() {
        this.setBytesRead(0L);
    }

    public void setBytesRead(long l) {
        this.lngBytesRead = l;
    }

    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }
}

