/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

public final class HelperMath {
    private HelperMath() {
    }

    public static final double diff_percent(double dblOldValue, double dblNewValue, int intPrecision) {
        if (dblOldValue == dblNewValue) {
            return 0.0;
        }
        if (dblOldValue < dblNewValue) {
            return HelperMath.nround((dblNewValue / dblOldValue - 1.0) * 100.0, 2);
        }
        return HelperMath.nround((1.0 - dblNewValue / dblOldValue) * -100.0, 2);
    }

    public static void main(String[] args) {
        System.out.println(HelperMath.diff_percent(180.0, 153.0, 2));
    }

    public static final double nround(double value, int decimals) {
        double factor = Math.pow(10.0, decimals);
        return (double)Math.round(value * factor) / factor;
    }

    public static final double percent(double dblMin, double dblValue, double dblMax) {
        if (dblMax - dblMin == 0.0) {
            return 0.0;
        }
        return (dblValue - dblMin) * 100.0 / (dblMax - dblMin);
    }

    public static final double percent(double dblMin, double dblValue, double dblMax, int intRounding) {
        double d = HelperMath.percent(dblMin, dblValue, dblMax);
        return HelperMath.nround(d, intRounding);
    }

    public static final double rebaite(double dblValue, double dblRebaite, int intPrecision) {
        return HelperMath.nround(dblValue * (1.0 - dblRebaite / 100.0), intPrecision);
    }

    public static final int sgn(double value) {
        if (value > 0.0) {
            return 1;
        }
        if (value < 0.0) {
            return -1;
        }
        return 0;
    }
}

