/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Inet6Address;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class A6Record
extends Record {
    private short prefixBits;
    private Inet6Address suffix;
    private Name prefix;

    private A6Record() {
    }

    public A6Record(Name _name, short _dclass, int _ttl, int _prefixBits, Inet6Address _suffix, Name _prefix) throws IOException {
        super(_name, (short)38, _dclass, _ttl);
        this.prefixBits = (short)_prefixBits;
        this.suffix = _suffix;
        this.prefix = _prefix;
    }

    A6Record(Name _name, short _dclass, int _ttl, int length, DataByteInputStream in) throws IOException {
        super(_name, (short)38, _dclass, _ttl);
        if (in == null) {
            return;
        }
        this.prefixBits = in.readByte();
        int suffixbits = 128 - this.prefixBits;
        int suffixbytes = (suffixbits + 7) / 8;
        byte[] data = new byte[suffixbytes];
        in.read(data);
        this.suffix = new Inet6Address(128 - this.prefixBits, data);
        if (this.prefixBits > 0) {
            this.prefix = new Name(in);
        }
    }

    A6Record(Name _name, short _dclass, int _ttl, MyStringTokenizer st, Name origin) throws IOException {
        super(_name, (short)38, _dclass, _ttl);
        this.prefixBits = Short.parseShort(st.nextToken());
        this.suffix = new Inet6Address(st.nextToken());
        if (this.prefixBits > 0) {
            this.prefix = new Name(st.nextToken(), origin);
        }
    }

    public Name getPrefix() {
        return this.prefix;
    }

    public short getPrefixBits() {
        return this.prefixBits;
    }

    public Inet6Address getSuffix() {
        return this.suffix;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.suffix != null) {
            sb.append(this.prefixBits);
            sb.append(" ");
            sb.append(this.suffix);
            if (this.prefix != null) {
                sb.append(" ");
                sb.append(this.prefix);
            }
        }
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c) throws IOException {
        if (this.suffix == null) {
            return;
        }
        out.write(this.prefixBits);
        int suffixbits = 128 - this.prefixBits;
        int suffixbytes = (suffixbits + 7) / 8;
        byte[] data = this.suffix.toBytes();
        out.write(data, 16 - suffixbytes, suffixbytes);
        if (this.prefix != null) {
            this.prefix.toWire(out, null);
        }
    }
}

