/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;
import org.xbill.DNS.utils.base16;

public class DSRecord
extends Record {
    public static final byte SHA1_DIGEST_ID = 1;
    private int footprint = -1;
    private byte alg;
    private byte digestid = 1;
    private byte[] digest;

    private DSRecord() {
    }

    public DSRecord(Name _name, short _dclass, int _ttl, int _footprint, int _alg, int _digestid, byte[] _digest) {
        super(_name, (short)43, _dclass, _ttl);
        this.footprint = _footprint;
        this.alg = (byte)_alg;
        this.digestid = (byte)_digestid;
        this.digest = _digest;
    }

    DSRecord(Name _name, short _dclass, int _ttl, int length, DataByteInputStream in) throws IOException {
        super(_name, (short)43, _dclass, _ttl);
        if (in == null) {
            return;
        }
        this.footprint = in.readShort() & 0xFFFF;
        this.alg = in.readByte();
        this.digestid = in.readByte();
        if (length > 4) {
            this.digest = new byte[length - 4];
            in.read(this.digest);
        }
    }

    DSRecord(Name _name, short _dclass, int _ttl, MyStringTokenizer st, Name origin) throws IOException {
        super(_name, (short)43, _dclass, _ttl);
        this.footprint = Integer.decode(st.nextToken());
        this.alg = (byte)Integer.parseInt(st.nextToken());
        this.digestid = (byte)Integer.parseInt(st.nextToken());
        this.digest = base16.fromString(st.remainingTokens());
    }

    public byte getAlgorithm() {
        return this.alg;
    }

    public byte[] getDigest() {
        return this.digest;
    }

    public byte getDigestID() {
        return this.digestid;
    }

    public short getFootprint() {
        return (short)this.footprint;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.footprint & 0xFFFF);
        sb.append(" ");
        sb.append(this.alg & 0xFF);
        sb.append(" ");
        sb.append(this.digestid & 0xFF);
        if (this.digest != null) {
            sb.append(" ");
            sb.append(base16.toString(this.digest));
        }
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c) throws IOException {
        out.writeShort(this.footprint);
        out.writeByte(this.alg);
        out.writeByte(this.digestid);
        if (this.digest != null) {
            out.write(this.digest);
        }
    }
}

