/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Random;
import org.xbill.DNS.Flags;
import org.xbill.DNS.Opcode;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Section;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;

public class Header {
    private int id;
    private boolean[] flags;
    private short rcode;
    private byte opcode;
    private int[] counts = new int[4];

    public Header() {
        this(Header.randomID());
    }

    public Header(int _id) {
        this.flags = new boolean[16];
        this.id = _id;
    }

    public Header(DataByteInputStream in) throws IOException {
        this(in.readUnsignedShort());
        this.readFlags(in);
        int i = 0;
        while (i < this.counts.length) {
            this.counts[i] = in.readUnsignedShort();
            ++i;
        }
    }

    public Object clone() {
        Header h = new Header();
        int i = 0;
        while (i < this.counts.length) {
            h.counts[i] = this.counts[i];
            ++i;
        }
        i = 0;
        while (i < this.flags.length) {
            h.flags[i] = this.flags[i];
            ++i;
        }
        h.id = this.id;
        h.rcode = this.rcode;
        h.rcode = this.rcode;
        h.opcode = this.opcode;
        return h;
    }

    void decCount(int field) {
        int n = field;
        this.counts[n] = this.counts[n] - 1;
    }

    public int getCount(int field) {
        return this.counts[field];
    }

    public boolean getFlag(int bit) {
        return this.flags[bit];
    }

    boolean[] getFlags() {
        return this.flags;
    }

    public int getID() {
        return this.id & 0xFFFF;
    }

    public byte getOpcode() {
        return this.opcode;
    }

    public short getRcode() {
        return this.rcode;
    }

    void incCount(int field) {
        int n = field;
        this.counts[n] = this.counts[n] + 1;
    }

    public String printFlags() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.flags.length) {
            String s;
            if (this.getFlag(i) && (s = Flags.string(i)) != null) {
                sb.append(s);
                sb.append(" ");
            }
            ++i;
        }
        return sb.toString();
    }

    static short randomID() {
        Random random = new Random();
        return (short)(random.nextInt() & 0xFFFF);
    }

    private void readFlags(DataByteInputStream in) throws IOException {
        short flags1 = (short)in.readUnsignedByte();
        short flags2 = (short)in.readUnsignedByte();
        int i = 0;
        while (i < 8) {
            this.flags[i] = (flags1 & 1 << 7 - i) != 0;
            this.flags[i + 8] = (flags2 & 1 << 7 - i) != 0;
            ++i;
        }
        this.opcode = (byte)(flags1 >> 3 & 0xF);
        this.rcode = (byte)(flags2 & 0xF);
    }

    void setCount(int field, int value) {
        this.counts[field] = value;
    }

    public void setFlag(int bit) {
        this.flags[bit] = true;
    }

    public void setID(int _id) {
        this.id = _id;
    }

    public void setOpcode(byte value) {
        this.opcode = value;
    }

    public void setRcode(short value) {
        this.rcode = value;
    }

    public String toString() {
        return this.toStringWithRcode(this.getRcode());
    }

    String toStringWithRcode(short newrcode) {
        StringBuffer sb = new StringBuffer();
        sb.append(";; ->>HEADER<<- ");
        sb.append("opcode: " + Opcode.string(this.getOpcode()));
        sb.append(", status: " + Rcode.string(newrcode));
        sb.append(", id: " + this.getID());
        sb.append("\n");
        sb.append(";; flags: " + this.printFlags());
        sb.append("; ");
        int i = 0;
        while (i < 4) {
            sb.append(String.valueOf(Section.string(i)) + ": " + this.getCount(i) + " ");
            ++i;
        }
        return sb.toString();
    }

    public byte[] toWire() throws IOException {
        DataByteOutputStream out = new DataByteOutputStream();
        this.toWire(out);
        return out.toByteArray();
    }

    void toWire(DataByteOutputStream out) throws IOException {
        out.writeShort(this.getID());
        this.writeFlags(out);
        int i = 0;
        while (i < this.counts.length) {
            out.writeShort((short)this.counts[i]);
            ++i;
        }
    }

    public void unsetFlag(int bit) {
        this.flags[bit] = false;
    }

    private void writeFlags(DataByteOutputStream out) throws IOException {
        int flags1 = 0;
        short flags2 = 0;
        int i = 0;
        while (i < 8) {
            if (this.flags[i]) {
                flags1 = (short)(flags1 | 1 << 7 - i);
            }
            if (this.flags[i + 8]) {
                flags2 = (short)(flags2 | 1 << 7 - i);
            }
            ++i;
        }
        flags1 = (short)(flags1 | this.opcode << 3);
        flags2 = (short)(flags2 | this.rcode);
        out.writeByte(flags1);
        out.writeByte(flags2);
    }
}

