/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import org.xbill.DNS.DClass;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.TTL;
import org.xbill.DNS.Type;
import org.xbill.DNS.utils.MyStringTokenizer;

public class Master {
    private Name origin;
    private BufferedReader br;
    private File file;
    private Record last = null;
    private int defaultTTL = 3600;
    private Master included = null;

    public Master(BufferedReader in) {
        this(in, null);
    }

    public Master(BufferedReader in, Name defaultOrigin) {
        this.br = in;
        this.origin = defaultOrigin;
    }

    Master(File _file, Name defaultOrigin) throws IOException {
        FileInputStream fis;
        this.file = _file;
        try {
            fis = new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new IOException(e.toString());
        }
        this.br = new BufferedReader(new InputStreamReader(fis));
        this.origin = defaultOrigin;
    }

    public Master(String filename) throws IOException {
        this(new File(filename), null);
    }

    public Master(String filename, Name origin) throws IOException {
        this(new File(filename), origin);
    }

    public Record nextRecord() throws IOException {
        String s;
        MyStringTokenizer st;
        boolean space;
        if (this.included != null) {
            Record rec = this.included.nextRecord();
            if (rec != null) {
                return rec;
            }
            this.included = null;
        }
        while (true) {
            String line;
            if ((line = Master.readExtendedLine(this.br)) == null) {
                return null;
            }
            if (line.length() == 0 || line.startsWith(";")) continue;
            space = line.startsWith(" ") || line.startsWith("\t");
            st = new MyStringTokenizer(line);
            s = st.nextToken();
            if (s.equals("$ORIGIN")) {
                this.origin = this.parseOrigin(st);
                continue;
            }
            if (!s.equals("$TTL")) break;
            this.defaultTTL = this.parseTTL(st);
        }
        if (s.equals("$INCLUDE")) {
            this.parseInclude(st);
            return this.nextRecord();
        }
        if (s.charAt(0) == '$') {
            throw new IOException("Invalid directive: " + s);
        }
        st.putBackToken(s);
        this.last = this.parseRR(st, space, this.last, this.origin);
        return this.last;
    }

    private void parseInclude(MyStringTokenizer st) throws IOException {
        if (!st.hasMoreTokens()) {
            throw new IOException("Missing file to include");
        }
        String filename = st.nextToken();
        File newfile = this.file.getParent() == null ? new File(filename) : new File(this.file.getParent(), filename);
        this.included = st.hasMoreTokens() ? new Master(newfile, new Name(st.nextToken())) : new Master(newfile, this.origin);
    }

    private Name parseOrigin(MyStringTokenizer st) throws IOException {
        if (!st.hasMoreTokens()) {
            throw new IOException("Missing ORIGIN");
        }
        return new Name(st.nextToken());
    }

    private Record parseRR(MyStringTokenizer st, boolean useLast, Record last, Name origin) throws IOException {
        int ttl;
        Name name = !useLast ? new Name(st.nextToken(), origin) : last.getName();
        String s = st.nextToken();
        try {
            ttl = TTL.parseTTL(s);
            s = st.nextToken();
        }
        catch (NumberFormatException numberFormatException) {
            ttl = !useLast || last == null ? this.defaultTTL : last.getTTL();
        }
        short dclass = DClass.value(s);
        if (dclass > 0) {
            s = st.nextToken();
        } else {
            dclass = 1;
        }
        short type = Type.value(s);
        if (type < 0) {
            throw new IOException("Parse error");
        }
        return Record.fromString(name, type, dclass, ttl, st, origin);
    }

    private int parseTTL(MyStringTokenizer st) throws IOException {
        if (!st.hasMoreTokens()) {
            throw new IOException("Missing TTL");
        }
        return Integer.parseInt(st.nextToken());
    }

    public static String readExtendedLine(BufferedReader br) throws IOException {
        String s = Master.stripTrailing(br.readLine());
        if (s == null) {
            return null;
        }
        if (!s.endsWith("(")) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.substring(0, s.length() - 1));
        while (true) {
            if ((s = Master.stripTrailing(br.readLine().trim())) == null) {
                return sb.toString();
            }
            sb.append(" ");
            if (s.endsWith(")")) break;
            sb.append(s);
        }
        sb.append(s.substring(0, s.length() - 1));
        return sb.toString();
    }

    private static String stripTrailing(String s) {
        if (s == null) {
            return null;
        }
        int semi = s.lastIndexOf(59);
        int lastChar = semi < 0 ? s.length() - 1 : semi - 1;
        int i = lastChar;
        while (i >= 0) {
            if (!Character.isWhitespace(s.charAt(i))) {
                return s.substring(0, i + 1);
            }
            --i;
        }
        return "";
    }
}

