/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.BitSet;
import java.util.Vector;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Type;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class NXTRecord
extends Record {
    private Name next;
    private BitSet bitmap;

    private NXTRecord() {
    }

    NXTRecord(Name _name, short _dclass, int _ttl, int length, DataByteInputStream in) throws IOException {
        super(_name, (short)30, _dclass, _ttl);
        if (in == null) {
            return;
        }
        int start = in.getPos();
        this.next = new Name(in);
        this.bitmap = new BitSet();
        int bitmapLength = length - (in.getPos() - start);
        int i = 0;
        while (i < bitmapLength) {
            int t = in.readUnsignedByte();
            int j = 0;
            while (j < 8) {
                if ((t & 1 << 7 - j) != 0) {
                    this.bitmap.set(i * 8 + j);
                }
                ++j;
            }
            ++i;
        }
    }

    public NXTRecord(Name _name, short _dclass, int _ttl, Name _next, BitSet _bitmap) {
        super(_name, (short)30, _dclass, _ttl);
        this.next = _next;
        this.bitmap = _bitmap;
    }

    NXTRecord(Name _name, short _dclass, int _ttl, MyStringTokenizer st, Name origin) throws IOException {
        super(_name, (short)30, _dclass, _ttl);
        new Vector();
        this.next = new Name(st.nextToken(), origin);
        this.bitmap = new BitSet();
        while (st.hasMoreTokens()) {
            short t = Type.value(st.nextToken());
            if (t <= 0) continue;
            this.bitmap.set(t);
        }
    }

    private int BitSetLength(BitSet b) {
        int i = b.size() - 1;
        while (i >= 0) {
            if (b.get(i)) {
                return i + 1;
            }
            --i;
        }
        return -1;
    }

    public BitSet getBitmap() {
        return this.bitmap;
    }

    public Name getNext() {
        return this.next;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.next != null) {
            sb.append(this.next);
            int length = this.BitSetLength(this.bitmap);
            int i = 0;
            while (i < length) {
                if (this.bitmap.get(i)) {
                    sb.append(" ");
                    sb.append(Type.string(i));
                }
                ++i;
            }
        }
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c) throws IOException {
        if (this.next == null) {
            return;
        }
        this.next.toWire(out, null);
        int length = this.BitSetLength(this.bitmap);
        int i = 0;
        int t = 0;
        while (i < length) {
            t |= this.bitmap.get(i) ? 1 << 7 - i % 8 : 0;
            if (i % 8 == 7 || i == length - 1) {
                out.writeByte(t);
                t = 0;
            }
            ++i;
        }
    }

    void rrToWireCanonical(DataByteOutputStream out) throws IOException {
        if (this.next == null) {
            return;
        }
        this.next.toWireCanonical(out);
        int length = this.BitSetLength(this.bitmap);
        int i = 0;
        int t = 0;
        while (i < length) {
            t |= this.bitmap.get(i) ? 1 << 7 - i % 8 : 0;
            if (i % 8 == 7 || i == length - 1) {
                out.writeByte(t);
                t = 0;
            }
            ++i;
        }
    }
}

