/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;

public class SRVRecord
extends Record {
    private short priority;
    private short weight;
    private short port;
    private Name target;

    private SRVRecord() {
    }

    public SRVRecord(Name _name, short _dclass, int _ttl, int _priority, int _weight, int _port, Name _target) {
        super(_name, (short)33, _dclass, _ttl);
        this.priority = (short)_priority;
        this.weight = (short)_weight;
        this.port = (short)_port;
        this.target = _target;
    }

    SRVRecord(Name _name, short _dclass, int _ttl, int length, DataByteInputStream in) throws IOException {
        super(_name, (short)33, _dclass, _ttl);
        if (in == null) {
            return;
        }
        this.priority = (short)in.readUnsignedShort();
        this.weight = (short)in.readUnsignedShort();
        this.port = (short)in.readUnsignedShort();
        this.target = new Name(in);
    }

    SRVRecord(Name _name, short _dclass, int _ttl, MyStringTokenizer st, Name origin) throws IOException {
        super(_name, (short)33, _dclass, _ttl);
        this.priority = Short.parseShort(st.nextToken());
        this.weight = Short.parseShort(st.nextToken());
        this.port = Short.parseShort(st.nextToken());
        this.target = new Name(st.nextToken(), origin);
    }

    public short getPort() {
        return this.port;
    }

    public short getPriority() {
        return this.priority;
    }

    public Name getTarget() {
        return this.target;
    }

    public short getWeight() {
        return this.weight;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.target != null) {
            sb.append(this.priority);
            sb.append(" ");
            sb.append(this.weight);
            sb.append(" ");
            sb.append(this.port);
            sb.append(" ");
            sb.append(this.target);
        }
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c) throws IOException {
        if (this.target == null) {
            return;
        }
        out.writeShort(this.priority);
        out.writeShort(this.weight);
        out.writeShort(this.port);
        this.target.toWire(out, null);
    }

    void rrToWireCanonical(DataByteOutputStream out) throws IOException {
        if (this.target == null) {
            return;
        }
        out.writeShort(this.priority);
        out.writeShort(this.weight);
        out.writeShort(this.port);
        this.target.toWireCanonical(out);
    }
}

