/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Date;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.base64;

public class TSIGRecord
extends Record {
    private Name alg;
    private Date timeSigned;
    private short fudge;
    private byte[] signature;
    private int originalID;
    private short error;
    private byte[] other;

    TSIGRecord(Name _name, short _dclass, int _ttl, int length, DataByteInputStream in) throws IOException {
        super(_name, (short)250, _dclass, _ttl);
        if (in == null) {
            return;
        }
        this.alg = new Name(in);
        short timeHigh = in.readShort();
        int timeLow = in.readInt();
        long time = ((long)timeHigh & 0xFFFFL) << 32;
        this.timeSigned = new Date((time += (long)timeLow & 0xFFFFFFFFFFFFFFFFL) * 1000L);
        this.fudge = in.readShort();
        int sigLen = in.readUnsignedShort();
        this.signature = new byte[sigLen];
        in.read(this.signature);
        this.originalID = in.readUnsignedShort();
        this.error = in.readShort();
        int otherLen = in.readUnsignedShort();
        if (otherLen > 0) {
            this.other = new byte[otherLen];
            in.read(this.other);
        } else {
            this.other = null;
        }
    }

    public TSIGRecord(Name _name, short _dclass, int _ttl, Name _alg, Date _timeSigned, short _fudge, byte[] _signature, int _originalID, short _error, byte[] _other) throws IOException {
        super(_name, (short)250, _dclass, _ttl);
        this.alg = _alg;
        this.timeSigned = _timeSigned;
        this.fudge = _fudge;
        this.signature = _signature;
        this.originalID = _originalID;
        this.error = _error;
        this.other = _other;
    }

    public Name getAlgorithm() {
        return this.alg;
    }

    public short getError() {
        return this.error;
    }

    public short getFudge() {
        return this.fudge;
    }

    public int getOriginalID() {
        return this.originalID;
    }

    public byte[] getOther() {
        return this.other;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public Date getTimeSigned() {
        return this.timeSigned;
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.alg == null) {
            return sb.toString();
        }
        sb.append(this.alg);
        sb.append(" (\n\t");
        sb.append(this.timeSigned.getTime() / 1000L);
        sb.append(" ");
        sb.append(Rcode.TSIGstring(this.error));
        sb.append("\n");
        sb.append(base64.formatString(this.signature, 64, "\t", false));
        if (this.other != null) {
            sb.append("\n\t <");
            if (this.error == 18) {
                try {
                    DataByteInputStream is = new DataByteInputStream(this.other);
                    long time = is.readUnsignedShort();
                    time <<= 32;
                    sb.append("Server time: ");
                    sb.append(new Date((time += (long)is.readInt() & 0xFFFFFFFFFFFFFFFFL) * 1000L));
                }
                catch (IOException iOException) {
                    sb.append("Truncated BADTIME other data");
                }
            } else {
                sb.append(base64.toString(this.other));
            }
            sb.append(">");
        }
        sb.append(" )");
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c) throws IOException {
        if (this.alg == null) {
            return;
        }
        this.alg.toWire(out, null);
        long time = this.timeSigned.getTime() / 1000L;
        short timeHigh = (short)(time >> 32);
        int timeLow = (int)time;
        out.writeShort(timeHigh);
        out.writeInt(timeLow);
        out.writeShort(this.fudge);
        out.writeShort((short)this.signature.length);
        out.write(this.signature);
        out.writeShort(this.originalID);
        out.writeShort(this.error);
        if (this.other != null) {
            out.writeShort((short)this.other.length);
            out.write(this.other);
        } else {
            out.writeShort(0);
        }
    }

    void rrToWireCanonical(DataByteOutputStream out) throws IOException {
        throw new IOException("A TSIG should never be converted to canonical");
    }
}

