/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;
import org.xbill.DNS.utils.base16;

public class UNKRecord
extends Record {
    private byte[] data;

    private UNKRecord() {
    }

    UNKRecord(Name _name, short _type, short _dclass, int _ttl, int length, DataByteInputStream in) throws IOException {
        super(_name, _type, _dclass, _ttl);
        if (in == null) {
            return;
        }
        if (length > 0) {
            this.data = new byte[length];
            in.read(this.data);
        } else {
            this.data = null;
        }
    }

    UNKRecord(Name _name, short _type, short _dclass, int _ttl, MyStringTokenizer st, Name origin) throws IOException {
        super(_name, _type, _dclass, _ttl);
        throw new IOException("Invalid unknown RR encoding");
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.data != null) {
            sb.append("\\# ");
            sb.append(this.data.length);
            sb.append(" ");
            sb.append(base16.toString(this.data));
        }
        return sb.toString();
    }

    void rrToWire(DataByteOutputStream out, Compression c) throws IOException {
        if (this.data != null) {
            out.write(this.data);
        }
    }
}

