/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.admin.awt;

import java.awt.FontMetrics;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Locale;
import net.zerotoaster.mta.admin.awt.IntegerStack;

public final class StringBufferExtended
implements Serializable,
Cloneable {
    private static final int CASEDIFF = 32;
    public static final String LS = System.getProperty("line.separator");
    public static final char N = LS.charAt(LS.length() - 1);
    public static final char R = LS.charAt(0);
    private static final char[] chrDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] chrUnits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final char[] chrTenthsUnits = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    private char[] charsValue = null;
    private int intLength = 0;
    private int intNextLineStart = 0;

    public StringBufferExtended() {
        this(16);
    }

    public StringBufferExtended(int length) {
        this.charsValue = new char[length];
    }

    public StringBufferExtended(String str) {
        this(str.length() + 16);
        this.append(str);
    }

    public StringBufferExtended(StringBuffer str) {
        this(str.length() + 16);
        this.append(str);
    }

    public StringBufferExtended(StringBufferExtended str) {
        this(str.charsValue, 0, str.intLength);
    }

    public StringBufferExtended(StringBufferExtended str, int off, int len) {
        this(str.charsValue, off, len);
    }

    public StringBufferExtended(char[] chars) {
        this(chars, 0, chars.length);
    }

    public StringBufferExtended(char[] chars, int off, int len) {
        this(chars.length + 16);
        this.append(chars, off, len);
    }

    public final StringBufferExtended append(byte b) {
        int newcount = this.intLength + 1;
        if (newcount > this.charsValue.length) {
            this.ensureCapacity(newcount);
        }
        this.charsValue[this.intLength++] = (char)(b & 0xFF);
        return this;
    }

    public final StringBufferExtended append(char c) {
        int newcount = this.intLength + 1;
        if (newcount > this.charsValue.length) {
            this.ensureCapacity(newcount);
        }
        this.charsValue[this.intLength++] = c;
        return this;
    }

    public final StringBufferExtended append(double d) {
        return this.append(String.valueOf(d));
    }

    public final StringBufferExtended append(float f) {
        return this.append(String.valueOf(f));
    }

    public final StringBufferExtended append(int n) {
        int i;
        if (n == Integer.MIN_VALUE) {
            this.append("-2147483648");
            return this;
        }
        char[] buf = new char[12];
        boolean negative = n < 0;
        int charPos = 12;
        if (negative) {
            i = -n;
            this.append('-');
        }
        if (i < 10) {
            this.append((char)(i + 48));
            return this;
        }
        do {
            int digit = i % 100;
            buf[--charPos] = chrUnits[digit];
            buf[--charPos] = chrTenthsUnits[digit];
        } while ((i /= 100) != 0);
        if (buf[charPos] == '0') {
            ++charPos;
        }
        this.append(buf, charPos, 12 - charPos);
        return this;
    }

    public final StringBufferExtended append(long l) {
        return this.append(String.valueOf(l));
    }

    public final StringBufferExtended append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public final StringBufferExtended append(String string) {
        int len;
        int newcount;
        String str;
        if (string == null) {
            str = "null";
        }
        if ((newcount = this.intLength + (len = str.length())) > this.charsValue.length) {
            this.ensureCapacity(newcount);
        }
        str.getChars(0, len, this.charsValue, this.intLength);
        this.intLength = newcount;
        return this;
    }

    public final StringBufferExtended append(StringBuffer str) {
        if (str == null) {
            return this.append("null");
        }
        int len = str.length();
        if (len == 0) {
            return this;
        }
        int newcount = this.intLength + len;
        if (newcount > this.charsValue.length) {
            this.ensureCapacity(newcount);
        }
        str.getChars(0, len, this.charsValue, this.intLength);
        this.intLength = newcount;
        return this;
    }

    public final StringBufferExtended append(StringBufferExtended str) {
        if (str == null) {
            return this.append("null");
        }
        return this.append(str.charsValue, 0, str.intLength);
    }

    public final StringBufferExtended append(StringBufferExtended str, int off, int len) {
        if (str == null) {
            this.append("null");
        }
        return this.append(str.charsValue, off, len);
    }

    public final StringBufferExtended append(boolean b) {
        return this.append(String.valueOf(b));
    }

    public final StringBufferExtended append(byte[] b) {
        return this.append(b, 0, b.length);
    }

    public final StringBufferExtended append(byte[] b, int offset, int len) {
        int newcount = this.intLength + len;
        if (newcount > this.charsValue.length) {
            this.ensureCapacity(newcount);
        }
        int count = this.intLength;
        char[] buffer = this.charsValue;
        while (count < newcount) {
            buffer[count++] = (char)(b[offset++] & 0xFF);
        }
        this.intLength = newcount;
        return this;
    }

    public final StringBufferExtended append(char[] chars) {
        return this.append(chars, 0, chars.length);
    }

    public final StringBufferExtended append(char[] chars, int offset, int len) {
        int newcount = this.intLength + len;
        if (newcount > this.charsValue.length) {
            this.ensureCapacity(newcount);
        }
        System.arraycopy(chars, offset, this.charsValue, this.intLength, len);
        this.intLength = newcount;
        return this;
    }

    private final StringBufferExtended append_(int n) {
        int i;
        if (n == Integer.MIN_VALUE) {
            this.append("-2147483648");
            return this;
        }
        char[] buf = new char[12];
        boolean negative = n < 0;
        int charPos = 12;
        if (negative) {
            i = -n;
            this.append('-');
        }
        if (i < 10) {
            this.append((char)(i + 48));
            return this;
        }
        do {
            int digit = i % 100;
            buf[--charPos] = chrUnits[digit];
            buf[--charPos] = chrTenthsUnits[digit];
        } while ((i /= 100) != 0);
        if (buf[charPos] == '0') {
            ++charPos;
        }
        this.append(buf, charPos, 12 - charPos);
        return this;
    }

    public final void clear() {
        this.intLength = 0;
    }

    public final Object clone() {
        try {
            StringBufferExtended sbe = (StringBufferExtended)super.clone();
            sbe.charsValue = (char[])this.charsValue.clone();
            return sbe;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("clone failed on StringBufferExtended");
        }
    }

    public final int compareTo(String comp) {
        int len = comp.length();
        char[] c = new char[len];
        comp.getChars(0, len, c, 0);
        return this.compareTo(c, 0, len, false);
    }

    public final int compareTo(StringBuffer comp) {
        int len = comp.length();
        char[] c = new char[len];
        comp.getChars(0, len, c, 0);
        return this.compareTo(c, 0, len, false);
    }

    public final int compareTo(StringBufferExtended comp) {
        return this.compareTo(comp.charsValue, 0, comp.intLength, false);
    }

    public final int compareTo(char[] comp) {
        return this.compareTo(comp, 0, comp.length, false);
    }

    public final int compareTo(char[] comp, int offset, int len) {
        return this.compareTo(comp, offset, len, false);
    }

    private final int compareTo(char[] chars, int off, int len, boolean ignoreCase) {
        if (off < 0 || len < 0 || len + off > chars.length) {
            throw new IllegalArgumentException();
        }
        int shorter = Math.min(this.intLength, len);
        char[] source = this.charsValue;
        int sourceIndex = 0;
        int argIndex = off;
        while (shorter-- != 0) {
            char argChar;
            char sourceChar;
            if ((sourceChar = source[sourceIndex++]) == (argChar = chars[argIndex++])) continue;
            if (ignoreCase) {
                char argLowerChar;
                if (Character.toUpperCase(sourceChar) == Character.toUpperCase(argChar)) continue;
                char sourceLowerChar = Character.toLowerCase(sourceChar);
                if (sourceLowerChar != (argLowerChar = Character.toLowerCase(argChar))) {
                    return sourceLowerChar - argLowerChar;
                }
            }
            return sourceChar - argChar;
        }
        return this.intLength - len;
    }

    public final int compareToIgnoreCase(String comp) {
        int len = comp.length();
        char[] c = new char[len];
        comp.getChars(0, len, c, 0);
        return this.compareTo(c, 0, len, true);
    }

    public final int compareToIgnoreCase(StringBuffer comp) {
        int len = comp.length();
        char[] c = new char[len];
        comp.getChars(0, len, c, 0);
        return this.compareTo(c, 0, len, true);
    }

    public final int compareToIgnoreCase(StringBufferExtended comp) {
        return this.compareTo(comp.charsValue, 0, comp.intLength, true);
    }

    public final int compareToIgnoreCase(char[] comp) {
        return this.compareTo(comp, 0, comp.length, true);
    }

    public final int compareToIgnoreCase(char[] chars, int off, int len) {
        return this.compareTo(chars, off, len, true);
    }

    final StringBufferExtended convert(boolean trueASCII, String string, int min) {
        String template;
        boolean removeRows = true;
        if (string == null) {
            template = "";
            removeRows = false;
        }
        if (min < 3) {
            removeRows = false;
        }
        int oldLen = this.intLength;
        int oldPointer = 0;
        int newPointer = 0;
        int charCounter = 0;
        int beginRepeatArea = 0;
        char[] values = this.charsValue;
        char lastChar = '\u0000';
        boolean inWord = false;
        boolean immediateRemove = false;
        while (oldPointer < oldLen) {
            boolean isControl;
            char ch = values[oldPointer++];
            if (removeRows) {
                if (ch == lastChar) {
                    if (immediateRemove) continue;
                    if (++charCounter == min) {
                        immediateRemove = true;
                        newPointer = beginRepeatArea;
                        values[newPointer++] = 32;
                        continue;
                    }
                    values[newPointer++] = ch;
                    continue;
                }
                immediateRemove = false;
                if (template.indexOf(ch) > -1) {
                    lastChar = ch;
                    charCounter = 1;
                    beginRepeatArea = newPointer;
                    values[newPointer++] = ch;
                    continue;
                }
                lastChar = '\u0000';
                charCounter = 0;
            }
            if (trueASCII && ch > '\u007f') continue;
            boolean bl = isControl = ch == '\n' || ch == '\r' || ch == '\t';
            if (ch > ' ' || isControl) {
                values[newPointer++] = ch;
                inWord = !isControl;
                continue;
            }
            if (!inWord) continue;
            values[newPointer++] = 32;
            inWord = false;
        }
        this.intLength = newPointer;
        return this;
    }

    public final StringBufferExtended convertASCIIToLowerCase() {
        int len = this.intLength;
        char[] val = this.charsValue;
        int i = 0;
        while (i < len) {
            char ch = val[i];
            if (ch >= 'A' && ch <= 'Z') {
                int n = i;
                val[n] = (char)(val[n] + 32);
            }
            ++i;
        }
        return this;
    }

    public final StringBufferExtended convertASCIIToUpperCase() {
        int len = this.intLength;
        char[] val = this.charsValue;
        int i = 0;
        while (i < len) {
            char ch = val[i];
            if (ch >= 'a' && ch <= 'z') {
                int n = i;
                val[n] = (char)(val[n] - 32);
            }
            ++i;
        }
        return this;
    }

    public final StringBufferExtended convertToLowerCase() {
        return this.convertToLowerCase(Locale.getDefault());
    }

    public final StringBufferExtended convertToLowerCase(Locale locale) {
        int len = this.intLength;
        char[] val = this.charsValue;
        if (locale.getLanguage().equals("tr")) {
            int i = 0;
            while (i < len) {
                char ch = val[i];
                val[i] = ch == 'I' ? 305 : (ch == '\u0130' ? 105 : Character.toLowerCase(ch));
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                val[i] = Character.toLowerCase(val[i]);
                ++i;
            }
        }
        return this;
    }

    public final StringBufferExtended convertToUpperCase() {
        return this.convertToUpperCase(Locale.getDefault());
    }

    public final StringBufferExtended convertToUpperCase(Locale locale) {
        int len = this.intLength;
        char[] val = this.charsValue;
        if (locale.getLanguage().equals("tr")) {
            int i = 0;
            while (i < len) {
                char ch = val[i];
                if (ch == 'i') {
                    val[i] = 304;
                } else if (ch == '\u0131') {
                    val[i] = 73;
                } else if (ch == '\u00df') {
                    val[i] = 83;
                    this.insert(i++, 'S');
                    val = this.charsValue;
                    len = this.intLength;
                } else {
                    val[i] = Character.toUpperCase(ch);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                char ch = val[i];
                if (ch == '\u00df') {
                    val[i] = 83;
                    this.insert(i++, 'S');
                    val = this.charsValue;
                    len = this.intLength;
                } else {
                    val[i] = Character.toUpperCase(ch);
                }
                ++i;
            }
        }
        return this;
    }

    public static final char[] createFilledCharArray(char ch, int len) {
        char[] c = new char[len];
        int i = len;
        while (i-- > 0) {
            c[i] = ch;
        }
        return c;
    }

    public final StringBufferExtended decLength() {
        if (--this.intLength < 0) {
            this.intLength = 0;
        }
        return this;
    }

    public final StringBufferExtended delete(int off) {
        return this.delete(off, Integer.MAX_VALUE);
    }

    public final StringBufferExtended delete(int off, int len) {
        if (off < 0 || off >= this.intLength) {
            throw new StringIndexOutOfBoundsException("offset out of bounds: " + off);
        }
        if (len < 0) {
            throw new StringIndexOutOfBoundsException("len must be >= 0: " + len);
        }
        if (len == 0) {
            return this;
        }
        int overflowCheck = off + len;
        if (overflowCheck >= this.intLength || overflowCheck < 0) {
            this.setLength(off);
            return this;
        }
        System.arraycopy(this.charsValue, off + len, this.charsValue, off, this.intLength - (off + len));
        this.intLength -= len;
        return this;
    }

    public void dispose() {
        this.charsValue = null;
        this.intLength = 0;
        this.intNextLineStart = 0;
    }

    public final boolean endsWith(String str) {
        int len = str.length();
        if (this.intLength < len) {
            return false;
        }
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.isMatchingRegion(c, 0, len, this.intLength - len, false);
    }

    public final boolean endsWith(StringBuffer str) {
        int len = str.length();
        if (this.intLength < len) {
            return false;
        }
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.isMatchingRegion(c, 0, len, this.intLength - len, false);
    }

    public final boolean endsWith(StringBufferExtended str) {
        if (this.intLength < str.intLength) {
            return false;
        }
        return this.isMatchingRegion(str.charsValue, 0, str.intLength, this.intLength - str.intLength, false);
    }

    public final boolean endsWith(StringBufferExtended str, int off, int len) {
        if (this.intLength < len) {
            return false;
        }
        return this.isMatchingRegion(str.charsValue, off, len, this.intLength - len, false);
    }

    public final boolean endsWith(char[] chars) {
        if (this.intLength < chars.length) {
            return false;
        }
        return this.isMatchingRegion(chars, 0, chars.length, this.intLength - chars.length, false);
    }

    public final boolean endsWith(char[] chars, int off, int len) {
        if (this.intLength < len) {
            return false;
        }
        return this.isMatchingRegion(chars, off, len, this.intLength - len, false);
    }

    public final void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.charsValue.length) {
            int newCapacity = (this.charsValue.length + 1) * 2;
            if (minimumCapacity > newCapacity) {
                newCapacity = minimumCapacity;
            }
            char[] newValue = new char[newCapacity];
            System.arraycopy(this.charsValue, 0, newValue, 0, this.intLength);
            this.charsValue = newValue;
        }
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o.getClass() == this.getClass()) {
            StringBufferExtended anotherString = (StringBufferExtended)o;
            int n = this.intLength;
            if (n == anotherString.intLength) {
                char[] v1 = this.charsValue;
                char[] v2 = anotherString.charsValue;
                int i = 0;
                while (n-- > 0) {
                    if (v1[i] == v2[i++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public final StringBufferExtended erase(int start, int end) {
        return this.overwrite(' ', start, end);
    }

    public String fillInNameTemplate(Dictionary values) {
        return this.fillInNameTemplate(null, values).toString();
    }

    public StringBufferExtended fillInNameTemplate(StringBufferExtended stringBufferExtended, Dictionary values) {
        StringBufferExtended sbe;
        int slen = values.size();
        boolean sbeProvided = stringBufferExtended != null;
        if (!sbeProvided) {
            sbe = new StringBufferExtended(this.intLength + slen * 80);
        } else {
            sbe.clear();
        }
        int pos = 0;
        int startPos = 0;
        while (startPos < this.intLength && (startPos = this.getIndexOf(123, startPos)) > -1) {
            int endPos = this.getIndexOf(125, startPos);
            if (endPos == -1) break;
            String key = this.getSubstring(startPos + 1, endPos);
            Object o = values.get(key);
            if (o == null && (o = values.get(key.toLowerCase())) == null && (o = values.get(key.toUpperCase())) == null) {
                if (!sbeProvided) {
                    throw new IllegalArgumentException("place holder in buffer not matched by element in argument list: {" + key + '}');
                }
                ++startPos;
                continue;
            }
            if (startPos > pos) {
                sbe.append(this.charsValue, pos, startPos - pos);
            }
            pos = startPos = endPos + 1;
            sbe.append(o.toString());
        }
        if (pos < this.intLength) {
            sbe.append(this.charsValue, pos, this.intLength - pos);
        }
        return sbe;
    }

    public StringBufferExtended fillInNumberTemplate(StringBufferExtended stringBufferExtended, Object[] s) {
        StringBufferExtended sbe;
        int slen = s.length;
        boolean sbeProvided = stringBufferExtended != null;
        if (!sbeProvided) {
            sbe = new StringBufferExtended(this.intLength + slen * 80);
        } else {
            sbe.clear();
        }
        int pos = 0;
        int startPos = 0;
        int index = 0;
        while (startPos < this.intLength && (startPos = this.getIndexOf(123, startPos)) > -1) {
            int endPos = this.getIndexOf(125, startPos);
            if (endPos == -1) break;
            try {
                index = Integer.parseInt(this.getSubstring(startPos + 1, endPos));
            }
            catch (NumberFormatException numberFormatException) {
                ++startPos;
                continue;
            }
            if (index < 0 || index > slen - 1) {
                if (sbeProvided) {
                    ++startPos;
                    continue;
                }
                throw new IllegalArgumentException("place holder in buffer not matched by argument array: {" + index + '}');
            }
            if (startPos > pos) {
                sbe.append(this.charsValue, pos, startPos - pos);
            }
            pos = startPos = endPos + 1;
            sbe.append(s[index]);
        }
        if (pos < this.intLength) {
            sbe.append(this.charsValue, pos, this.intLength - pos);
        }
        return sbe;
    }

    public String fillInNumberTemplate(Object[] s) {
        return this.fillInNumberTemplate(null, s).toString();
    }

    public final int getCapacity() {
        return this.charsValue.length;
    }

    public final char[] getCharArray() {
        return this.charsValue;
    }

    public final char getCharAt(int index) {
        if (index >= this.intLength) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.charsValue[index];
    }

    public final int getCharCount(char ch) {
        return this.getCharCount(ch, 0, this.intLength, false);
    }

    public final int getCharCount(char ch, int start, int end) {
        return this.getCharCount(ch, start, end, false);
    }

    public final int getCharCount(char ch, int start, int n, boolean ignoreCase) {
        int end;
        if (start < 0 || n < 0 || start > n || start > this.intLength) {
            throw new StringIndexOutOfBoundsException("start=" + start + "; end=" + n + ";buffer size=" + this.intLength);
        }
        if (n > this.intLength) {
            end = this.intLength;
        }
        int counter = 0;
        char[] val = this.charsValue;
        int i = end;
        while (i-- > start) {
            char curChar = val[i];
            if (curChar == ch) {
                ++counter;
                continue;
            }
            if (!ignoreCase) continue;
            if (Character.toUpperCase(ch) == Character.toUpperCase(curChar)) {
                ++counter;
                continue;
            }
            if (Character.toLowerCase(ch) != Character.toLowerCase(curChar)) continue;
            ++counter;
        }
        return counter;
    }

    public final void getChars(int begin, int end, char[] dst, int start) {
        if (begin < end) {
            System.arraycopy(this.charsValue, begin, dst, start, end - begin);
        }
    }

    public final int getIndexOf(int ch) {
        return this.getIndexOf(ch, 0);
    }

    public final int getIndexOf(int ch, int n) {
        int fromIndex;
        int max = this.intLength;
        char[] v = this.charsValue;
        if (n < 0) {
            fromIndex = 0;
        } else if (fromIndex >= this.intLength) {
            return -1;
        }
        int i = fromIndex;
        while (i < max) {
            if (v[i] == ch) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final int getIndexOf(String str) {
        int len = str.length();
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.getIndexOf(c, 0, len, 0);
    }

    public final int getIndexOf(String str, int from) {
        int len = str.length();
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.getIndexOf(c, 0, len, from);
    }

    public final int getIndexOf(StringBuffer str) {
        int len = str.length();
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.getIndexOf(c, 0, len, 0);
    }

    public final int getIndexOf(StringBuffer str, int fromIndex) {
        int len = str.length();
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.getIndexOf(c, 0, len, fromIndex);
    }

    public final int getIndexOf(StringBufferExtended str) {
        return this.getIndexOf(str.charsValue, 0, str.intLength, 0);
    }

    public final int getIndexOf(StringBufferExtended str, int fromIndex) {
        return this.getIndexOf(str.charsValue, 0, str.intLength, fromIndex);
    }

    public final int getIndexOf(StringBufferExtended str, int off, int len) {
        return this.getIndexOf(str.charsValue, off, len, 0);
    }

    public final int getIndexOf(StringBufferExtended str, int off, int len, int fromIndex) {
        return this.getIndexOf(str.charsValue, off, len, fromIndex);
    }

    public final int getIndexOf(char[] comp) {
        return this.getIndexOf(comp, 0, comp.length, 0);
    }

    public final int getIndexOf(char[] comp, int fromIndex) {
        return this.getIndexOf(comp, 0, comp.length, fromIndex);
    }

    public final int getIndexOf(char[] comp, int off, int len) {
        return this.getIndexOf(comp, off, len, 0);
    }

    public final int getIndexOf(char[] comp, int off, int len, int n) {
        int fromIndex;
        char[] charsThis = this.charsValue;
        int lenThis = this.intLength;
        int lastIndexToCompare = lenThis - len;
        if (n >= lenThis) {
            return -1;
        }
        if (n < 0) {
            fromIndex = 0;
        }
        if (len == 0) {
            return fromIndex;
        }
        char first = comp[off];
        block0: while (true) {
            if (fromIndex <= lastIndexToCompare && charsThis[fromIndex] != first) {
                ++fromIndex;
                continue;
            }
            if (fromIndex > lastIndexToCompare) {
                return -1;
            }
            int innerIndex = fromIndex + 1;
            int end = innerIndex + len - 1;
            int compIndex = off + 1;
            while (innerIndex < end) {
                if (charsThis[innerIndex++] == comp[compIndex++]) continue;
                ++fromIndex;
                continue block0;
            }
            break;
        }
        return fromIndex;
    }

    public final int getIndexOfIgnoreCase(String str) {
        int len = str.length();
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.getIndexOfIgnoreCase(c, 0, len, 0);
    }

    public final int getIndexOfIgnoreCase(String str, int fromIndex) {
        int len = str.length();
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.getIndexOfIgnoreCase(c, 0, len, fromIndex);
    }

    public final int getIndexOfIgnoreCase(StringBuffer str) {
        int len = str.length();
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.getIndexOfIgnoreCase(c, 0, len, 0);
    }

    public final int getIndexOfIgnoreCase(StringBuffer str, int fromIndex) {
        int len = str.length();
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.getIndexOfIgnoreCase(c, 0, len, fromIndex);
    }

    public final int getIndexOfIgnoreCase(StringBufferExtended str) {
        return this.getIndexOfIgnoreCase(str.charsValue, 0, str.intLength, 0);
    }

    public final int getIndexOfIgnoreCase(StringBufferExtended str, int fromIndex) {
        return this.getIndexOfIgnoreCase(str.charsValue, 0, str.intLength, fromIndex);
    }

    public final int getIndexOfIgnoreCase(StringBufferExtended str, int off, int len) {
        return this.getIndexOfIgnoreCase(str.charsValue, off, len, 0);
    }

    public final int getIndexOfIgnoreCase(StringBufferExtended str, int off, int len, int fromIndex) {
        return this.getIndexOfIgnoreCase(str.charsValue, off, len, fromIndex);
    }

    public final int getIndexOfIgnoreCase(char[] comp) {
        return this.getIndexOfIgnoreCase(comp, 0, comp.length, 0);
    }

    public final int getIndexOfIgnoreCase(char[] comp, int fromIndex) {
        return this.getIndexOfIgnoreCase(comp, 0, comp.length, fromIndex);
    }

    public final int getIndexOfIgnoreCase(char[] comp, int off, int len) {
        return this.getIndexOfIgnoreCase(comp, off, len, 0);
    }

    public final int getIndexOfIgnoreCase(char[] comp, int off, int len, int n) {
        int fromIndex;
        char[] charsThis = this.charsValue;
        int lenThis = this.intLength;
        int lastIndexToCompare = lenThis - len;
        if (n >= lenThis) {
            return -1;
        }
        if (n < 0) {
            fromIndex = 0;
        }
        if (len == 0) {
            return fromIndex;
        }
        char first = comp[off];
        char firstUpper = Character.toUpperCase(first);
        char firstLower = Character.toLowerCase(first);
        block0: while (true) {
            if (fromIndex <= lastIndexToCompare) {
                char loop = charsThis[fromIndex];
                if (loop != first && Character.toUpperCase(loop) != firstUpper && Character.toLowerCase(loop) != firstLower) {
                    ++fromIndex;
                    continue;
                }
            }
            if (fromIndex > lastIndexToCompare) {
                return -1;
            }
            int innerIndex = fromIndex + 1;
            int end = innerIndex + len - 1;
            int compIndex = off + 1;
            while (innerIndex < end) {
                char loop;
                char c = charsThis[innerIndex++];
                char cUpper = Character.toUpperCase(c);
                char cLower = Character.toLowerCase(c);
                if ((loop = comp[compIndex++]) == c || cUpper == Character.toUpperCase(loop) || cLower == Character.toLowerCase(loop)) continue;
                ++fromIndex;
                continue block0;
            }
            break;
        }
        return fromIndex;
    }

    public final int getLastIndexOf(int ch) {
        return this.getLastIndexOf(ch, this.intLength - 1);
    }

    public final int getLastIndexOf(int ch, int fromIndex) {
        char[] v = this.charsValue;
        int i = fromIndex >= this.intLength ? this.intLength - 1 : fromIndex;
        while (i >= 0) {
            if (v[i] == ch) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public final int getLastIndexOf(String str) {
        int len = str.length();
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.getLastIndexOf(c, 0, len, this.intLength - 1);
    }

    public final int getLastIndexOf(String str, int fromIndex) {
        int len = str.length();
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.getLastIndexOf(c, 0, len, fromIndex);
    }

    public final int getLastIndexOf(String str, int fromIndex, boolean ignoreCase) {
        int len = str.length();
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.getLastIndexOf(c, 0, len, fromIndex, ignoreCase);
    }

    public final int getLastIndexOf(String str, boolean ignoreCase) {
        int len = str.length();
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.getLastIndexOf(c, 0, len, this.intLength - 1, ignoreCase);
    }

    public final int getLastIndexOf(StringBuffer str) {
        int len = str.length();
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.getLastIndexOf(c, 0, len, this.intLength - 1);
    }

    public final int getLastIndexOf(StringBuffer str, int fromIndex) {
        int len = str.length();
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.getLastIndexOf(c, 0, len, fromIndex);
    }

    public final int getLastIndexOf(StringBuffer str, int fromIndex, boolean ignoreCase) {
        int len = str.length();
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.getLastIndexOf(c, 0, len, fromIndex, ignoreCase);
    }

    public final int getLastIndexOf(StringBuffer str, boolean ignoreCase) {
        int len = str.length();
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.getLastIndexOf(c, 0, len, this.intLength - 1, ignoreCase);
    }

    public final int getLastIndexOf(StringBufferExtended str) {
        return this.getLastIndexOf(str.charsValue, 0, str.intLength, this.intLength - 1);
    }

    public final int getLastIndexOf(StringBufferExtended str, int fromIndex) {
        return this.getLastIndexOf(str.charsValue, 0, str.intLength, fromIndex);
    }

    public final int getLastIndexOf(StringBufferExtended str, int off, int len) {
        return this.getLastIndexOf(str.charsValue, off, len, this.intLength - 1);
    }

    public final int getLastIndexOf(StringBufferExtended str, int off, int len, int from) {
        return this.getLastIndexOf(str.charsValue, off, len, from);
    }

    public final int getLastIndexOf(StringBufferExtended str, int off, int len, int fromIndex, boolean ignoreCase) {
        return this.getLastIndexOf(str.charsValue, off, len, fromIndex, ignoreCase);
    }

    public final int getLastIndexOf(StringBufferExtended str, int off, int len, boolean ignoreCase) {
        return this.getLastIndexOf(str.charsValue, off, len, this.intLength - 1, ignoreCase);
    }

    public final int getLastIndexOf(StringBufferExtended str, int fromIndex, boolean ignoreCase) {
        return this.getLastIndexOf(str.charsValue, 0, str.intLength, fromIndex, ignoreCase);
    }

    public final int getLastIndexOf(StringBufferExtended str, boolean ignoreCase) {
        return this.getLastIndexOf(str.charsValue, 0, str.intLength, this.intLength - 1, ignoreCase);
    }

    public final int getLastIndexOf(char[] chars) {
        return this.getLastIndexOf(chars, 0, chars.length, this.intLength - 1);
    }

    public final int getLastIndexOf(char[] chars, int fromIndex) {
        return this.getLastIndexOf(chars, 0, chars.length, fromIndex);
    }

    public final int getLastIndexOf(char[] chars, int off, int len) {
        return this.getLastIndexOf(chars, off, len, this.intLength - 1);
    }

    public final int getLastIndexOf(char[] chars, int off, int len, int n) {
        int start;
        int fromIndex;
        if (n < 0) {
            return -1;
        }
        int t = this.intLength - len;
        if (n > t) {
            fromIndex = t;
        }
        if (len == 0) {
            return fromIndex;
        }
        char[] val = this.charsValue;
        int strLastIndex = off + len - 1;
        char strLastChar = chars[strLastIndex];
        int lastCharPos = len - 1;
        int lastCharIndex = lastCharPos + fromIndex;
        block0: while (true) {
            if (lastCharIndex >= lastCharPos && val[lastCharIndex] != strLastChar) {
                --lastCharIndex;
                continue;
            }
            if (lastCharIndex < lastCharPos) {
                return -1;
            }
            int thisIndex = lastCharIndex - 1;
            start = thisIndex - (len - 1);
            int paramIndex = strLastIndex - 1;
            while (thisIndex > start) {
                if (val[thisIndex--] == chars[paramIndex--]) continue;
                --lastCharIndex;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public final int getLastIndexOf(char[] chars, int off, int len, int n, boolean ignoreCase) {
        int start;
        int fromIndex;
        if (!ignoreCase) {
            return this.getLastIndexOf(chars, off, len, n);
        }
        if (n < 0) {
            return -1;
        }
        int t = this.intLength - len;
        if (n > t) {
            fromIndex = t;
        }
        if (len == 0) {
            return fromIndex;
        }
        char[] val = this.charsValue;
        int lastIndex = off + len - 1;
        char last = chars[lastIndex];
        char lastUpper = Character.toUpperCase(last);
        char lastLower = Character.toLowerCase(last);
        int lastSearchPos = len - 1;
        int lastSearchIndex = lastSearchPos + fromIndex;
        block0: while (true) {
            if (lastSearchIndex >= lastSearchPos) {
                char loop = val[lastSearchIndex];
                if (loop != last && Character.toUpperCase(loop) != lastUpper && Character.toLowerCase(loop) != lastLower) {
                    --lastSearchIndex;
                    continue;
                }
            }
            if (lastSearchIndex < lastSearchPos) {
                return -1;
            }
            int thisIndex = lastSearchIndex - 1;
            start = thisIndex - (len - 1);
            int paramIndex = lastIndex - 1;
            while (thisIndex > start) {
                char loop;
                char c = val[thisIndex--];
                char cUpper = Character.toUpperCase(c);
                char cLower = Character.toLowerCase(c);
                if ((loop = chars[paramIndex--]) == c || Character.toUpperCase(loop) == cUpper || Character.toLowerCase(loop) == cLower) continue;
                --lastSearchIndex;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public final int getLastIndexOf(char[] chars, int off, int len, boolean ignoreCase) {
        return this.getLastIndexOf(chars, off, len, this.intLength - 1, ignoreCase);
    }

    public final int getLastIndexOf(char[] chars, int fromIndex, boolean ignoreCase) {
        return this.getLastIndexOf(chars, 0, chars.length, fromIndex, ignoreCase);
    }

    public final int getLastIndexOf(char[] chars, boolean ignoreCase) {
        return this.getLastIndexOf(chars, 0, chars.length, this.intLength - 1, ignoreCase);
    }

    public final int getLength() {
        return this.intLength;
    }

    public final int getLineCount() {
        if (this.intLength == 0) {
            return 0;
        }
        int count = this.getCharCount(N, 0, this.intLength - 1, false);
        if (this.charsValue[this.intLength - 1] != N) {
            ++count;
        }
        return count;
    }

    public final String getLineFixedLength(int n, int lineLength) {
        int offset;
        if (n < 0 || n > this.intLength) {
            throw new StringIndexOutOfBoundsException("offset: " + n);
        }
        if (lineLength < 0) {
            throw new IllegalArgumentException("width: " + lineLength);
        }
        char[] result = new char[lineLength + 1];
        char[] source = this.charsValue;
        int len = this.intLength;
        int resultIndex = 0;
        IntegerStack resultStack = new IntegerStack();
        IntegerStack sourceStack = new IntegerStack();
        boolean inWord = false;
        boolean skip = true;
        char ch = '\u0000';
        while (offset <= len) {
            if (resultIndex > lineLength || n == len || ch == N) {
                while (resultIndex > 0 && result[resultIndex - 1] <= ' ') {
                    --resultIndex;
                }
                if (resultIndex > lineLength && !resultStack.isEmpty()) {
                    resultIndex = resultStack.pop();
                    offset = sourceStack.pop();
                }
                while (offset < len && (ch = source[offset]) != N && ch <= ' ') {
                    ++offset;
                }
                this.intNextLineStart = offset;
                return String.valueOf(result, 0, resultIndex);
            }
            ch = source[offset];
            if (ch <= ' ') {
                if (inWord) {
                    resultStack.push(resultIndex);
                    sourceStack.push(offset);
                    inWord = false;
                    skip = false;
                }
                ++offset;
                if (skip) continue;
                skip = true;
                if (ch == N || ch == R) continue;
                result[resultIndex++] = 32;
                continue;
            }
            inWord = true;
            ++offset;
            result[resultIndex++] = ch;
        }
        return null;
    }

    private final String getLineFixedLength(int n, int length, boolean skipSpaces) {
        int fromIndex;
        if (n < 0 || n > this.intLength) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (length < 0) {
            throw new IllegalArgumentException("width: " + length);
        }
        char[] result = new char[length + 1];
        char[] source = this.charsValue;
        int len = this.intLength;
        int resultIndex = 0;
        IntegerStack resultStack = new IntegerStack();
        IntegerStack sourceStack = new IntegerStack();
        boolean inWord = false;
        boolean skip = skipSpaces;
        char ch = '\u0000';
        while (fromIndex <= len) {
            if (resultIndex > length || n == len || ch == N) {
                if (skipSpaces) {
                    while (resultIndex > 0 && result[resultIndex - 1] <= ' ') {
                        --resultIndex;
                    }
                }
                if (resultIndex > length && !resultStack.isEmpty()) {
                    resultIndex = resultStack.pop();
                    fromIndex = sourceStack.pop();
                }
                if (skipSpaces) {
                    while (fromIndex < len && (ch = result[fromIndex]) != N || ch <= ' ') {
                        ++fromIndex;
                    }
                }
                this.intNextLineStart = fromIndex;
                return String.valueOf(result, 0, resultIndex);
            }
            ch = source[fromIndex];
            if (ch <= ' ') {
                if (inWord) {
                    resultStack.push(resultIndex);
                    sourceStack.push(fromIndex);
                    inWord = false;
                    skip = false;
                }
                ++fromIndex;
                if (skip) continue;
                skip = skipSpaces;
                if (ch == N || ch == R) continue;
                result[resultIndex++] = 32;
                continue;
            }
            inWord = true;
            ++fromIndex;
            result[resultIndex++] = ch;
        }
        return null;
    }

    public final Enumeration getLineFixedLengthEnumeration(int lineLength) {
        return new LineEnumeration(this, lineLength);
    }

    public final String getLineHardBreak(int offset, boolean skipSpaces) {
        if (offset < 0 || offset > this.intLength) {
            throw new StringIndexOutOfBoundsException("offset: " + offset);
        }
        char[] source = this.charsValue;
        int len = this.intLength;
        int lineEnd = this.getIndexOf(N, offset);
        int countLS = 1;
        if (lineEnd == -1) {
            lineEnd = len;
        } else if (lineEnd > offset && source[lineEnd - 1] == R) {
            ++countLS;
            --lineEnd;
        }
        int lineLength = lineEnd - offset;
        if (!skipSpaces) {
            this.intNextLineStart = offset + lineLength + countLS;
            return new String(source, offset, lineLength);
        }
        char[] line = new char[lineLength];
        int lineIndex = 0;
        boolean skip = skipSpaces;
        boolean inWord = true;
        char ch = '\u0000';
        while (offset < lineEnd) {
            if ((ch = source[offset++]) <= ' ') {
                if (inWord) {
                    inWord = false;
                }
                if (skip) continue;
                skip = skipSpaces;
                line[lineIndex++] = 32;
                continue;
            }
            inWord = true;
            line[lineIndex++] = ch;
        }
        while (lineIndex > 0 && line[lineIndex - 1] <= ' ') {
            --lineIndex;
        }
        while (offset < len && (ch = source[offset]) != N && ch <= ' ') {
            ++offset;
        }
        this.intNextLineStart = offset;
        return String.valueOf(line, 0, lineIndex);
    }

    public final Enumeration getLineHardBreakEnumeration() {
        return new LineEnumeration(this);
    }

    public final Enumeration getLineHardBreakEnumeration(int startLine) {
        LineEnumeration lineEnumeration = new LineEnumeration(this);
        LineEnumeration.access$intLineCounter(lineEnumeration, this.getLineStart(startLine));
        return lineEnumeration;
    }

    public final int getLineNumber(int pos) {
        return this.getCharCount(N, 0, pos, false) + 1;
    }

    public final String getLineSoftLength(int n, int pixelWidth, FontMetrics fm, boolean skipSpaces) {
        int offset;
        if (n < 0 || n > this.intLength) {
            throw new StringIndexOutOfBoundsException("offset: " + n);
        }
        if (pixelWidth < 0) {
            throw new IllegalArgumentException("pixelWidth: " + pixelWidth);
        }
        int maxChars = 0;
        double w = fm.stringWidth("iIwW");
        double charWidth = w / 4.0;
        maxChars = (int)((double)pixelWidth / charWidth);
        char[] result = new char[maxChars + 16];
        char[] source = this.charsValue;
        int len = this.intLength;
        int resultIndex = 0;
        IntegerStack resultStack = new IntegerStack();
        IntegerStack sourceStack = new IntegerStack();
        boolean inWord = false;
        boolean skip = skipSpaces;
        char ch = '\u0000';
        boolean stop = false;
        while (offset <= len) {
            if (resultIndex > maxChars | (stop = n == len | ch == N)) {
                char[] newArray;
                int totalWidth = fm.charsWidth(result, 0, resultIndex);
                if (totalWidth > pixelWidth || stop) {
                    if (skipSpaces) {
                        while (resultIndex > 0 && result[resultIndex - 1] <= ' ') {
                            --resultIndex;
                        }
                    }
                    totalWidth = fm.charsWidth(result, 0, resultIndex);
                    while (totalWidth > pixelWidth && !resultStack.isEmpty()) {
                        resultIndex = resultStack.pop();
                        offset = sourceStack.pop();
                        totalWidth = fm.charsWidth(result, 0, resultIndex);
                    }
                    if (source[offset - true] != N) {
                        while (offset < len) {
                            ch = source[offset];
                            if (ch <= ' ') {
                                ++offset;
                            }
                            if (ch == N || ch > ' ') break;
                            if (skipSpaces || ch == R) continue;
                            if (resultIndex == result.length) {
                                newArray = new char[resultIndex * 2];
                                System.arraycopy(result, 0, newArray, 0, resultIndex);
                                result = newArray;
                            }
                            result[resultIndex++] = 32;
                        }
                    }
                    this.intNextLineStart = offset;
                    return String.valueOf(result, 0, resultIndex);
                }
                if (resultIndex == result.length) {
                    newArray = new char[resultIndex * 2];
                    System.arraycopy(result, 0, newArray, 0, resultIndex);
                    result = newArray;
                }
            }
            if ((ch = source[offset]) <= ' ') {
                if (inWord) {
                    resultStack.push(resultIndex);
                    sourceStack.push(offset);
                    inWord = false;
                    skip = false;
                }
                ++offset;
                if (skip) continue;
                skip = skipSpaces;
                if (ch == N || ch == R) continue;
                result[resultIndex++] = 32;
                continue;
            }
            inWord = true;
            ++offset;
            result[resultIndex++] = ch;
        }
        return null;
    }

    public final Enumeration getLineSoftLengthEnumeration(int lineLength, FontMetrics fm) {
        return new LineEnumeration(this, lineLength, fm, true);
    }

    public final Enumeration getLineSoftLengthEnumeration(int lineLength, FontMetrics fm, boolean skipSpaces) {
        return new LineEnumeration(this, lineLength, fm, skipSpaces);
    }

    public final int getLineStart(int lineNo) {
        if (lineNo < 0 || this.intLength == 0) {
            return -1;
        }
        int currPos = 0;
        while (lineNo-- > 0) {
            int nextPos = this.getIndexOf(N, currPos);
            if (nextPos == -1) {
                return -1;
            }
            currPos = nextPos + 1;
        }
        return currPos;
    }

    public final int getNextLineStart() {
        return this.intNextLineStart;
    }

    public final int getRowNumber(int pos) {
        int lastCR = this.getLastIndexOf(N, pos);
        return pos - lastCR;
    }

    public final String getSubstring(int begin) {
        return this.getSubstring(begin, this.intLength);
    }

    public final String getSubstring(int n, int n2) {
        int begin;
        int end;
        if (n < 0 || n2 < 0) {
            throw new StringIndexOutOfBoundsException(n + "," + n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        if (n2 > this.intLength) {
            end = this.intLength;
        }
        if (n > this.intLength) {
            begin = this.intLength;
        }
        return new String(this.charsValue, begin, end - begin);
    }

    public final int hashCode() {
        int h = 0;
        int off = 0;
        char[] val = this.charsValue;
        int len = this.intLength;
        if (len < 16) {
            int i = len;
            while (i > 0) {
                h = h * 37 + val[off++];
                --i;
            }
        } else {
            int skip = len / 8;
            int i = len;
            while (i > 0) {
                h = h * 39 + val[off];
                i -= skip;
                off += skip;
            }
        }
        return h;
    }

    public void init(int size) {
        if (this.charsValue == null) {
            this.charsValue = new char[size + 16];
        } else {
            this.ensureCapacity(size);
        }
    }

    public final StringBufferExtended insert(int offset, char c) {
        int newcount = this.intLength + 1;
        if (newcount > this.charsValue.length) {
            this.ensureCapacity(newcount);
        }
        System.arraycopy(this.charsValue, offset, this.charsValue, offset + 1, this.intLength - offset);
        this.charsValue[offset] = c;
        this.intLength = newcount;
        return this;
    }

    public final StringBufferExtended insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    public final StringBufferExtended insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    public final StringBufferExtended insert(int offset, int i) {
        return this.insert(offset, String.valueOf(i));
    }

    public final StringBufferExtended insert(int offset, long l) {
        return this.insert(offset, String.valueOf(l));
    }

    public final StringBufferExtended insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public final StringBufferExtended insert(int offset, String str) {
        int len = str.length();
        int newcount = this.intLength + len;
        if (newcount > this.charsValue.length) {
            this.ensureCapacity(newcount);
        }
        System.arraycopy(this.charsValue, offset, this.charsValue, offset + len, this.intLength - offset);
        str.getChars(0, len, this.charsValue, offset);
        this.intLength = newcount;
        return this;
    }

    public final StringBufferExtended insert(int offset, StringBuffer str) {
        int len = str.length();
        int newcount = this.intLength + len;
        if (newcount > this.charsValue.length) {
            this.ensureCapacity(newcount);
        }
        System.arraycopy(this.charsValue, offset, this.charsValue, offset + len, this.intLength - offset);
        str.getChars(0, len, this.charsValue, offset);
        this.intLength = newcount;
        return this;
    }

    public final StringBufferExtended insert(int offset, StringBufferExtended str) {
        return this.insert(offset, str.charsValue, 0, str.intLength);
    }

    public final StringBufferExtended insert(int offset, StringBufferExtended str, int off, int len) {
        return this.insert(offset, str.charsValue, off, len);
    }

    public final StringBufferExtended insert(int offset, boolean b) {
        return this.insert(offset, String.valueOf(b));
    }

    public final StringBufferExtended insert(int offset, char[] str) {
        return this.insert(offset, str, 0, str.length);
    }

    public final StringBufferExtended insert(int start, char[] str, int off, int len) {
        int newcount = this.intLength + len;
        if (newcount > this.charsValue.length) {
            this.ensureCapacity(newcount);
        }
        System.arraycopy(this.charsValue, start, this.charsValue, start + len, this.intLength - start);
        System.arraycopy(str, off, this.charsValue, start, len);
        this.intLength = newcount;
        return this;
    }

    public final boolean isEmpty() {
        return this.intLength == 0;
    }

    public final boolean isMatchingRegion(String str, int start, boolean ignoreCase) {
        int len = str.length();
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.isMatchingRegion(c, 0, len, start, ignoreCase);
    }

    public final boolean isMatchingRegion(StringBuffer str, int start, boolean ignoreCase) {
        int len = str.length();
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.isMatchingRegion(c, 0, len, start, ignoreCase);
    }

    public final boolean isMatchingRegion(StringBufferExtended str, int off, int len, int start, boolean ignoreCase) {
        return this.isMatchingRegion(str.charsValue, off, len, start, ignoreCase);
    }

    public final boolean isMatchingRegion(char[] chars, int off, int len, int start, boolean ignoreCase) {
        if (off < 0 || off > chars.length || len < 0 || len + off > chars.length || start > this.intLength) {
            throw new IllegalArgumentException();
        }
        if (this.intLength - start < len) {
            return false;
        }
        char[] thisChars = this.charsValue;
        int indexThis = start;
        int indexThat = off;
        while (len-- != 0) {
            char cthat;
            char cthis;
            if ((cthis = thisChars[indexThis++]) == (cthat = chars[indexThat++])) continue;
            if (ignoreCase) {
                char lthat;
                char uthat;
                char uthis = Character.toUpperCase(cthis);
                if (uthis == (uthat = Character.toUpperCase(cthat))) continue;
                char lthis = Character.toLowerCase(cthis);
                if (lthis != (lthat = Character.toLowerCase(cthat))) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Throwable {
        StringBufferExtended sbe = new StringBufferExtended("schau mer ma: {0} {1}");
        StringBufferExtended result = new StringBufferExtended();
        Object[] hsh = new Object[]{"geht"};
        try {
            result = sbe.fillInNumberTemplate(result, hsh);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(result);
        hsh = new Object[]{"ignore", "ja"};
        try {
            result = result.fillInNumberTemplate(null, hsh);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(result);
    }

    public final StringBufferExtended overwrite(char ch, int n, int n2) {
        int end;
        int start;
        if (n < 0) {
            start = 0;
        }
        if (n2 < 0) {
            return this;
        }
        if (start >= this.intLength) {
            return this;
        }
        if (n2 >= this.intLength) {
            end = this.intLength - 1;
        }
        char[] chars = this.charsValue;
        int i = start;
        while (i <= end) {
            chars[i] = ch;
            ++i;
        }
        return this;
    }

    public final StringBufferExtended reduceSpaces() {
        int oldLen = this.intLength;
        int oldPointer = 0;
        int newPointer = 0;
        char[] values = this.charsValue;
        boolean inWord = false;
        while (oldPointer < oldLen) {
            char ch;
            if ((ch = values[oldPointer++]) > ' ') {
                values[newPointer++] = ch;
                inWord = true;
                continue;
            }
            if (!inWord) continue;
            values[newPointer++] = 32;
            inWord = false;
        }
        this.intLength = newPointer;
        return this;
    }

    public final StringBufferExtended reduceSpaces(boolean keepLineBreaks) {
        int oldLen = this.intLength;
        int oldPointer = 0;
        int newPointer = 0;
        char[] values = this.charsValue;
        boolean inWord = false;
        while (oldPointer < oldLen) {
            char ch;
            if ((ch = values[oldPointer++]) > ' ' || keepLineBreaks && (ch == '\n' || ch == '\r')) {
                values[newPointer++] = ch;
                if (ch == '\n' || ch == '\r') continue;
                inWord = true;
                continue;
            }
            if (!inWord) continue;
            values[newPointer++] = 32;
            inWord = false;
        }
        this.intLength = newPointer;
        return this;
    }

    public final StringBufferExtended replace(char oldChar, char newChar) {
        if (oldChar != newChar) {
            int len = this.intLength;
            char[] val = this.charsValue;
            int i = len;
            while (i-- > 0) {
                if (val[i] != oldChar) continue;
                val[i] = newChar;
            }
        }
        return this;
    }

    public final StringBufferExtended replace(String oldStr, String newStr, boolean ignoreCase) {
        int oldLen = oldStr.length();
        int newLen = newStr.length();
        char[] oc = new char[oldLen];
        char[] nc = new char[newLen];
        oldStr.getChars(0, oldLen, oc, 0);
        newStr.getChars(0, newLen, nc, 0);
        return this.replace(oc, 0, oldLen, nc, 0, newLen, ignoreCase);
    }

    public final StringBufferExtended replace(StringBufferExtended oldStr, int oldOff, int oldLen, StringBufferExtended newStr, int newOff, int newLen, boolean ignoreCase) {
        return this.replace(oldStr.charsValue, oldOff, oldLen, newStr.charsValue, newOff, newLen, ignoreCase);
    }

    public final StringBufferExtended replace(StringBufferExtended oldStr, int oldOff, int oldLen, char[] newStr, int newOff, int newLen, boolean ignoreCase) {
        return this.replace(oldStr.charsValue, oldOff, oldLen, newStr, newOff, newLen, ignoreCase);
    }

    public final StringBufferExtended replace(char[] oldStr, int oldOff, int oldLen, StringBufferExtended newStr, int newOff, int newLen, boolean ignoreCase) {
        return this.replace(oldStr, oldOff, oldLen, newStr.charsValue, newOff, newLen, ignoreCase);
    }

    public final StringBufferExtended replace(char[] oldStr, int oldOff, int oldLen, char[] newStr, int newOff, int newLen, boolean ignoreCase) {
        if (oldStr == null || newStr == null) {
            throw new NullPointerException();
        }
        if (oldOff < 0 || oldLen < 0 || newOff < 0 || newLen < 0 || oldOff + oldLen > oldStr.length || newOff + newLen > newStr.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (oldLen == 0) {
            return this;
        }
        int pos = 0;
        while ((pos = ignoreCase ? this.getIndexOfIgnoreCase(oldStr, oldOff, oldLen, pos) : this.getIndexOf(oldStr, oldOff, oldLen, pos)) != -1) {
            if (oldLen == newLen) {
                System.arraycopy(newStr, newOff, this.charsValue, pos, newLen);
            } else if (oldLen > newLen) {
                if (newLen > 0) {
                    System.arraycopy(newStr, newOff, this.charsValue, pos, newLen);
                }
                this.delete(pos + newLen, oldLen - newLen);
            } else {
                System.arraycopy(newStr, newOff, this.charsValue, pos, oldLen);
                this.insert(pos + oldLen, newStr, newOff + oldLen, newLen - oldLen);
            }
            pos += newLen;
        }
        return this;
    }

    public final StringBufferExtended replaceTabsWithSpaces(int spaces) {
        return this.replaceTabsWithSpaces(new int[]{spaces});
    }

    public final StringBufferExtended replaceTabsWithSpaces(int[] tabStops) {
        if (tabStops == null) {
            throw new NullPointerException("tabStops must not be null");
        }
        int tabLen = tabStops.length;
        char[] spaces = null;
        if (tabLen > 0) {
            int longestTab = 0;
            int index = 0;
            int i = 0;
            while (i < tabLen) {
                int value = tabStops[i];
                if (value < 0) {
                    throw new IllegalArgumentException("negative tab stop at position #" + i + " (" + value + ')');
                }
                longestTab = Math.max(longestTab, value);
                if (value > 0) {
                    tabStops[index++] = value;
                }
                ++i;
            }
            tabLen = index;
            spaces = StringBufferExtended.createFilledCharArray(' ', longestTab);
        }
        if (tabLen == 0 || this.intLength == 0) {
            return this;
        }
        --tabLen;
        int len = this.intLength;
        char[] source = (char[])this.charsValue.clone();
        this.clear();
        int nextStop = 0;
        int tabIndex = 0;
        int lineIndex = 0;
        int i = 0;
        while (i < len) {
            char ch = source[i];
            if (ch == N) {
                nextStop = 0;
                lineIndex = 0;
                tabIndex = 0;
                this.append(ch);
            } else {
                if (nextStop == lineIndex) {
                    nextStop += tabStops[tabIndex];
                    if (tabIndex < tabLen) {
                        ++tabIndex;
                    }
                }
                if (ch == '\t') {
                    this.append(spaces, 0, nextStop - lineIndex);
                    lineIndex = nextStop;
                } else {
                    ++lineIndex;
                    this.append(ch);
                }
            }
            ++i;
        }
        return this;
    }

    public final StringBufferExtended reverse() {
        int lastChar = this.intLength - 1;
        int i = lastChar - 1 >> 1;
        while (i >= 0) {
            char temp = this.charsValue[i];
            this.charsValue[i] = this.charsValue[lastChar - i];
            this.charsValue[lastChar - i] = temp;
            --i;
        }
        return this;
    }

    public final void setCharArray(char[] chars, int len) {
        if (chars == null) {
            throw new NullPointerException();
        }
        if (len > chars.length || len < 0) {
            throw new StringIndexOutOfBoundsException(len);
        }
        this.charsValue = chars;
        this.intLength = len;
    }

    public final void setCharAt(int index, char ch) {
        if (index < 0 || index >= this.intLength) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.charsValue[index] = ch;
    }

    public final void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        if (newLength > this.charsValue.length) {
            this.ensureCapacity(newLength);
        }
        if (this.intLength < newLength) {
            while (this.intLength < newLength) {
                this.charsValue[this.intLength] = '\u0000';
                ++this.intLength;
            }
        } else {
            this.intLength = newLength;
        }
    }

    public final void setLengthIndex(int newLength) {
        if (newLength < 0 || newLength > this.charsValue.length) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        this.intLength = newLength;
    }

    public final void setNextLineStart(int lineNo) {
        this.intNextLineStart = lineNo;
    }

    public final boolean startsWith(String str) {
        int len = str.length();
        if (this.intLength < len) {
            return false;
        }
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.isMatchingRegion(c, 0, len, 0, false);
    }

    public final boolean startsWith(StringBuffer str) {
        int len = str.length();
        if (this.intLength < len) {
            return false;
        }
        char[] c = new char[len];
        str.getChars(0, len, c, 0);
        return this.isMatchingRegion(c, 0, len, 0, false);
    }

    public final boolean startsWith(StringBufferExtended str) {
        if (this.intLength < str.intLength) {
            return false;
        }
        return this.isMatchingRegion(str.charsValue, 0, str.intLength, 0, false);
    }

    public final boolean startsWith(StringBufferExtended str, int off, int len) {
        if (this.intLength < len) {
            return false;
        }
        return this.isMatchingRegion(str.charsValue, off, len, 0, false);
    }

    public final boolean startsWith(char[] chars) {
        if (this.intLength < chars.length) {
            return false;
        }
        return this.isMatchingRegion(chars, 0, chars.length, 0, false);
    }

    public final boolean startsWith(char[] chars, int off, int len) {
        if (this.intLength < len) {
            return false;
        }
        return this.isMatchingRegion(chars, off, len, 0, false);
    }

    public final StringBufferExtended stripSpaces() {
        int oldLen = this.intLength;
        int oldPointer = 0;
        int newPointer = 0;
        char[] values = this.charsValue;
        while (oldPointer < oldLen) {
            char ch;
            if ((ch = values[oldPointer++]) <= ' ') continue;
            values[newPointer++] = ch;
        }
        this.intLength = newPointer;
        return this;
    }

    public static void testAppend() throws Throwable {
        int i;
        long startTest = System.currentTimeMillis();
        StringBufferExtended sbe = new StringBufferExtended(10000000);
        System.out.println("preparing jit");
        int j = 3;
        while (j-- > 0) {
            int i2 = -100000;
            while (i2 < 100000) {
                sbe.append(String.valueOf(i2));
                ++i2;
            }
            sbe.clear();
            i2 = -100000;
            while (i2 < 100000) {
                sbe.append_(i2);
                ++i2;
            }
            sbe.clear();
            i2 = 2147383647;
            while (i2 < Integer.MAX_VALUE) {
                sbe.append(i2);
                ++i2;
            }
            sbe.clear();
            i2 = -2147483647;
            while (i2 < -2147383647) {
                sbe.append(i2);
                ++i2;
            }
        }
        System.out.println("\t\tpos\t\tneg\t\t0\t\t1");
        System.out.print("internal:\t");
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        long start = System.currentTimeMillis();
        int j2 = 1000;
        while (j2-- > 0) {
            sbe.clear();
            int i3 = 2147383647;
            while (i3 < Integer.MAX_VALUE) {
                sbe.append(i3);
                ++i3;
            }
        }
        long end = System.currentTimeMillis();
        System.out.print(end - start);
        System.out.print("\t\t");
        int hashPositive = sbe.hashCode();
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        start = System.currentTimeMillis();
        int j3 = 1000;
        while (j3-- > 0) {
            sbe.clear();
            i = -2147483647;
            while (i < -2147383647) {
                sbe.append(i);
                ++i;
            }
        }
        end = System.currentTimeMillis();
        System.out.print(end - start);
        System.out.print("\t\t");
        int hashNegative = sbe.hashCode();
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        start = System.currentTimeMillis();
        j3 = 1000;
        while (j3-- > 0) {
            sbe.clear();
            i = -2147483647;
            while (i < -2147383647) {
                sbe.append(0);
                ++i;
            }
        }
        end = System.currentTimeMillis();
        System.out.print(end - start);
        System.out.print("\t\t");
        int hashZero = sbe.hashCode();
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        start = System.currentTimeMillis();
        j3 = 1000;
        while (j3-- > 0) {
            sbe.clear();
            i = -2147483647;
            while (i < -2147383647) {
                sbe.append(1);
                ++i;
            }
        }
        end = System.currentTimeMillis();
        System.out.println(end - start);
        int hashOne = sbe.hashCode();
        System.out.print("test    :\t");
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        start = System.currentTimeMillis();
        j3 = 1000;
        while (j3-- > 0) {
            sbe.clear();
            i = 2147383647;
            while (i < Integer.MAX_VALUE) {
                sbe.append_(i);
                ++i;
            }
        }
        end = System.currentTimeMillis();
        System.out.print(end - start);
        System.out.print("\t\t");
        if (hashPositive != sbe.hashCode()) {
            System.out.println();
            System.out.println("strings sind unterschiedlich");
            System.exit(0);
        }
        hashPositive = sbe.hashCode();
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        start = System.currentTimeMillis();
        j3 = 1000;
        while (j3-- > 0) {
            sbe.clear();
            i = -2147483647;
            while (i < -2147383647) {
                sbe.append_(i);
                ++i;
            }
        }
        end = System.currentTimeMillis();
        System.out.print(end - start);
        System.out.print("\t\t");
        if (hashNegative != sbe.hashCode()) {
            System.out.println();
            System.out.println("strings sind unterschiedlich");
            System.exit(0);
        }
        hashNegative = sbe.hashCode();
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        start = System.currentTimeMillis();
        j3 = 1000;
        while (j3-- > 0) {
            sbe.clear();
            i = -2147483647;
            while (i < -2147383647) {
                sbe.append_(0);
                ++i;
            }
        }
        end = System.currentTimeMillis();
        System.out.print(end - start);
        System.out.print("\t\t");
        if (hashZero != sbe.hashCode()) {
            System.out.println();
            System.out.println("strings sind unterschiedlich");
            System.exit(0);
        }
        hashZero = sbe.hashCode();
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        start = System.currentTimeMillis();
        j3 = 1000;
        while (j3-- > 0) {
            sbe.clear();
            i = -2147483647;
            while (i < -2147383647) {
                sbe.append_(1);
                ++i;
            }
        }
        end = System.currentTimeMillis();
        System.out.println(end - start);
        if (hashOne != sbe.hashCode()) {
            System.out.println();
            System.out.println("strings sind unterschiedlich");
            System.exit(0);
        }
        hashOne = sbe.hashCode();
        System.out.print("String  :\t");
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        start = System.currentTimeMillis();
        j3 = 1000;
        while (j3-- > 0) {
            sbe.clear();
            i = 2147383647;
            while (i < Integer.MAX_VALUE) {
                sbe.append(String.valueOf(i));
                ++i;
            }
        }
        end = System.currentTimeMillis();
        System.out.print(end - start);
        System.out.print("\t\t");
        if (hashPositive != sbe.hashCode()) {
            System.out.println();
            System.out.println("strings sind unterschiedlich");
            System.exit(0);
        }
        hashPositive = sbe.hashCode();
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        start = System.currentTimeMillis();
        j3 = 1000;
        while (j3-- > 0) {
            sbe.clear();
            i = -2147483647;
            while (i < -2147383647) {
                sbe.append(String.valueOf(i));
                ++i;
            }
        }
        end = System.currentTimeMillis();
        System.out.print(end - start);
        System.out.print("\t\t");
        if (hashNegative != sbe.hashCode()) {
            System.out.println();
            System.out.println("strings sind unterschiedlich");
            System.exit(0);
        }
        hashNegative = sbe.hashCode();
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        start = System.currentTimeMillis();
        j3 = 1000;
        while (j3-- > 0) {
            sbe.clear();
            i = -2147483647;
            while (i < -2147383647) {
                sbe.append(String.valueOf(0));
                ++i;
            }
        }
        end = System.currentTimeMillis();
        System.out.print(end - start);
        System.out.print("\t\t");
        if (hashZero != sbe.hashCode()) {
            System.out.println();
            System.out.println("strings sind unterschiedlich");
            System.exit(0);
        }
        hashZero = sbe.hashCode();
        System.gc();
        System.runFinalization();
        System.gc();
        Thread.sleep(1000L);
        start = System.currentTimeMillis();
        j3 = 1000;
        while (j3-- > 0) {
            sbe.clear();
            i = -2147483647;
            while (i < -2147383647) {
                sbe.append(String.valueOf(1));
                ++i;
            }
        }
        end = System.currentTimeMillis();
        System.out.println(end - start);
        if (hashOne != sbe.hashCode()) {
            System.out.println();
            System.out.println("strings sind unterschiedlich");
            System.exit(0);
        }
        hashOne = sbe.hashCode();
        long endTest = System.currentTimeMillis();
        System.out.println("\ntotal Test time: " + (endTest - startTest));
    }

    public final byte[] toByteArray() {
        return this.toByteArray(0, this.intLength);
    }

    public final byte[] toByteArray(int n, int n2) {
        int len;
        int off;
        if (n < 0 || n2 < 0) {
            throw new StringIndexOutOfBoundsException(n + "," + n2);
        }
        if (n >= this.intLength) {
            off = this.intLength;
        }
        if (off + n2 > this.intLength) {
            len = this.intLength - off;
        }
        byte[] result = new byte[len];
        char[] buffer = this.charsValue;
        int count = off;
        int i = 0;
        while (i < len) {
            result[i++] = (byte)buffer[count++];
        }
        return result;
    }

    public final char[] toCharArray() {
        return this.toCharArray(0, this.intLength);
    }

    public final char[] toCharArray(int n, int n2) {
        int len;
        int off;
        if (n < 0 || n2 < 0) {
            throw new StringIndexOutOfBoundsException(n + "," + n2);
        }
        if (n >= this.intLength) {
            off = this.intLength;
        }
        if (off + n2 > this.intLength) {
            len = this.intLength - off;
        }
        char[] result = new char[len];
        System.arraycopy(this.charsValue, off, result, 0, len);
        return result;
    }

    public final String toString() {
        return this.toString(0, this.intLength);
    }

    public final String toString(int n, int n2) {
        int len;
        int off;
        if (n < 0 || n2 < 0) {
            throw new StringIndexOutOfBoundsException(n + "," + n2);
        }
        if (n >= this.intLength) {
            off = this.intLength;
        }
        if (off + n2 > this.intLength) {
            len = this.intLength - off;
        }
        return new String(this.charsValue, off, len);
    }

    public final StringBuffer toStringBuffer() {
        return this.toStringBuffer(0, this.intLength);
    }

    public final StringBuffer toStringBuffer(int n, int n2) {
        int len;
        int off;
        if (n < 0 || n2 < 0) {
            throw new StringIndexOutOfBoundsException(n + "," + n2);
        }
        if (n >= this.intLength) {
            off = this.intLength;
        }
        if (off + n2 > this.intLength) {
            len = this.intLength - off;
        }
        return new StringBuffer(len).append(this.charsValue, off, len);
    }

    public final StringBufferExtended trim() {
        int len = this.intLength;
        int start = 0;
        char[] val = this.charsValue;
        while (start < len && val[start] <= ' ') {
            ++start;
        }
        while (start < len && val[len - 1] <= ' ') {
            --len;
        }
        this.intLength = len - start;
        System.arraycopy(val, start, val, 0, this.intLength);
        return this;
    }

    public final StringBufferExtended trimLeft() {
        int len = this.intLength;
        int start = 0;
        char[] val = this.charsValue;
        while (start < len && val[start] <= ' ') {
            ++start;
        }
        this.intLength = len - start;
        System.arraycopy(val, start, val, 0, this.intLength);
        return this;
    }

    public final StringBufferExtended trimRight() {
        int len = this.intLength;
        char[] val = this.charsValue;
        while (len > 0 && val[len - 1] <= ' ') {
            --len;
        }
        this.intLength = len;
        return this;
    }

    static int access$intLength(StringBufferExtended stringBufferExtended) {
        return stringBufferExtended.intLength;
    }

    static int access$intNextLineStart(StringBufferExtended stringBufferExtended) {
        return stringBufferExtended.intNextLineStart;
    }

    private class LineEnumeration
    implements Enumeration {
        /* synthetic */ StringBufferExtended this$0;
        private int intLineCounter = 0;
        private int intType = 0;
        private int intWidth = 0;
        private FontMetrics fmMetrics = null;

        LineEnumeration(StringBufferExtended this$0) {
            this.this$0 = this$0;
        }

        LineEnumeration(StringBufferExtended this$0, int width) {
            this.this$0 = this$0;
            this.intType = 1;
            this.intWidth = width;
        }

        LineEnumeration(StringBufferExtended this$0, int width, FontMetrics fm, boolean skipSpaces) {
            this.this$0 = this$0;
            this.intType = skipSpaces ? 2 : 3;
            this.intWidth = width;
            this.fmMetrics = fm;
        }

        public Object nextElement() {
            String line;
            switch (this.intType) {
                case 0: {
                    line = this.this$0.getLineHardBreak(this.intLineCounter, false);
                    break;
                }
                case 1: {
                    line = this.this$0.getLineFixedLength(this.intLineCounter, this.intWidth);
                    break;
                }
                case 2: {
                    line = this.this$0.getLineSoftLength(this.intLineCounter, this.intWidth, this.fmMetrics, true);
                    break;
                }
                case 3: {
                    line = this.this$0.getLineSoftLength(this.intLineCounter, this.intWidth, this.fmMetrics, false);
                    break;
                }
                default: {
                    line = "";
                }
            }
            this.intLineCounter = StringBufferExtended.access$intNextLineStart(this.this$0);
            return line;
        }

        public boolean hasMoreElements() {
            return this.intLineCounter < StringBufferExtended.access$intLength(this.this$0);
        }

        static void access$intLineCounter(LineEnumeration lineEnumeration, int n) {
            lineEnumeration.intLineCounter = n;
        }
    }
}

