/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.mailfilters;

import java.io.Serializable;
import net.zerotoaster.mta.storage.StorageRecord;
import net.zerotoaster.mta.util.Helper;

public class BayesianRBLRecord
extends StorageRecord
implements Serializable {
    public static final String KEYDATA_APPL_RECORD = "BAYESIAN_RBL_RECORD";
    private String strUserName = null;
    private String strServer = null;
    private String strResponse = null;
    private int intProbability = 0;

    public BayesianRBLRecord() {
        this.init();
    }

    public int getProbability() {
        return this.intProbability;
    }

    public String getResponse() {
        return this.strResponse;
    }

    public String getServer() {
        return this.strServer;
    }

    public String getUserName() {
        return this.strUserName;
    }

    public void init() {
        this.strUserName = "";
        this.strServer = "";
        this.strResponse = "";
        this.intProbability = 0;
    }

    public String recordExport() {
        StringBuffer strb = new StringBuffer();
        strb.append(this.strUserName);
        strb.append('\u0014');
        strb.append(this.strServer);
        strb.append('\u0014');
        strb.append(this.strResponse);
        strb.append('\u0014');
        strb.append(this.intProbability);
        strb.append('\u0014');
        return strb.toString();
    }

    public void recordImport(String str) {
        this.initTokenizer(str);
        this.strUserName = this.nextToken();
        this.strServer = this.nextToken();
        this.strResponse = this.nextToken();
        this.intProbability = Integer.parseInt(this.nextToken());
    }

    public void setProbability(int i) {
        this.intProbability = i;
    }

    public void setResponse(String s) {
        this.strResponse = Helper.limit(s, 60);
    }

    public void setServer(String s) {
        this.strServer = Helper.limit(s.toLowerCase(), 50);
    }

    public void setUserName(String s) {
        this.strUserName = Helper.limit(s.toLowerCase(), 129);
    }

    public String toString() {
        return String.valueOf(this.getUserName()) + "/" + this.getServer();
    }
}

