/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.main;

import de.zwanzigeins.util.InitializationException;
import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.TimeFactory;
import java.util.Vector;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.event.KickForwarder;
import net.zerotoaster.mta.event.MTAEvent;
import net.zerotoaster.mta.event.MTAEventListener;
import net.zerotoaster.mta.event.MTAEventQueue;
import net.zerotoaster.mta.main.FWD_ServerInstance;
import net.zerotoaster.mta.main.ServerContainer;
import net.zerotoaster.mta.storage.MailHeaderRecord;
import net.zerotoaster.mta.storage.StorageManager;
import net.zerotoaster.mta.util.Helper;

public class FWD_ServerContainer
extends ServerContainer
implements MTAEventListener {
    private static LockObject objLock = null;
    protected StorageManager smManager = null;

    public FWD_ServerContainer() throws Throwable {
        super("FWD");
        this.setThreadName("FWD-Container");
        this.init();
        this.resetThreadName();
    }

    public void dispose() {
        this.setThreadName();
        this.blnIsRunning = false;
        if (objLock != null) {
            objLock.lo_notify();
            objLock.dispose();
            objLock = null;
        }
        super.dispose();
        if (this.smManager != null) {
            this.smManager.dispose();
        }
        this.resetThreadName();
    }

    protected boolean init() throws Throwable {
        if (!super.init()) {
            return false;
        }
        MTAEventQueue.addListener(this);
        try {
            int i = 0;
            while (i < this.intInstances) {
                FWD_ServerInstance si = new FWD_ServerInstance(String.valueOf(this.strContainerName) + " " + Helper.buildID(i + 1, this.intInstances));
                this.addInstance(si);
                ++i;
            }
        }
        catch (InitializationException initializationException) {
            this.dispose();
            throw new InitializationException();
        }
        catch (Throwable t) {
            Configuration.logContext.write("? Unhandled exception during creating instances", t);
            this.dispose();
            throw new InitializationException();
        }
        this.smManager = Configuration.getStorageManager();
        this.kickThread();
        Configuration.logContext.write("# Created " + String.valueOf(this.intInstances) + " FWD instances");
        return true;
    }

    public void mtaEvent(MTAEvent e) {
        if (e instanceof KickForwarder) {
            objLock.lo_notify();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        objLock = new LockObject();
        this.blnIsRunning = true;
        this.loThreadStarted.lo_notify();
        while (this.blnIsRunning) {
            Vector vecMessages = new Vector(0);
            try {
                int intFreeInstances = this.getFreeInstanceCount();
                Configuration.logContext.write("D Scanning for outgoing mails [" + intFreeInstances + " free FWD instances]");
                vecMessages = this.smManager.mailGetHeadersToSend(intFreeInstances, this.cnf.intFWD_RetryDelay);
                Configuration.logContext.write("# " + vecMessages.size() + " mails to forward");
            }
            catch (Throwable t) {
                Configuration.logContext.write("? Error getting mails to forward/instances count ", t);
            }
            boolean blnOutOfServers = false;
            int i = 0;
            while (i < vecMessages.size()) {
                MailHeaderRecord mhr = (MailHeaderRecord)vecMessages.elementAt(i);
                try {
                    FWD_ServerInstance si = (FWD_ServerInstance)this.getFreeInstance();
                    if (si == null) {
                        blnOutOfServers = true;
                        break;
                    }
                    mhr.setMailLocked(true);
                    mhr.setMailLockedTimestamp(TimeFactory.getTime());
                    this.smManager.mailWriteHeader(mhr);
                    this.smManager.commit();
                    Configuration.logContext.write("D Kick FWD instance for " + mhr.toString());
                    si.kickInstance(mhr);
                }
                catch (Throwable t) {
                    Configuration.logContext.write("? Error processing outgoing mail " + mhr.getUID(), t);
                }
                ++i;
            }
            try {
                if (!blnOutOfServers) {
                    Configuration.logContext.write("D Waiting " + this.cnf.intFWD_Rescan + " seconds or instance kick for rescan");
                    objLock.lo_wait((long)(this.cnf.intFWD_Rescan * 1000));
                    continue;
                }
                while (this.getFreeInstanceCount() < this.getInstanceCount()) {
                    Configuration.logContext.write("D Waiting for a free instance");
                    objLock.lo_wait(5000L);
                }
            }
            catch (Throwable t) {
                Configuration.logContext.write("? Error waiting for next queue run", t);
            }
        }
    }
}

