/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.mta.main;

import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperFilter;
import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.TimeFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Date;
import java.util.Vector;
import net.zerotoaster.mta.config.Configuration;
import net.zerotoaster.mta.config.Constants;
import net.zerotoaster.mta.event.ForceFetchmailEvent;
import net.zerotoaster.mta.event.MTAEvent;
import net.zerotoaster.mta.event.MTAEventListener;
import net.zerotoaster.mta.event.MTAEventQueue;
import net.zerotoaster.mta.io.LineSocket;
import net.zerotoaster.mta.io.SMTPInputReader;
import net.zerotoaster.mta.main.ZeroToaster;
import net.zerotoaster.mta.storage.DomainRecord;
import net.zerotoaster.mta.storage.FetchmailRecord;
import net.zerotoaster.mta.storage.MailHeaderRecord;
import net.zerotoaster.mta.storage.MailQueueRecord;
import net.zerotoaster.mta.storage.StorageManager;
import net.zerotoaster.mta.storage.UserRecord;
import net.zerotoaster.mta.util.Helper;
import net.zerotoaster.mta.util.HostIP;
import net.zerotoaster.mta.util.UserAlias;

public class POP3_Fetchmail
extends Thread
implements Constants,
MTAEventListener {
    private LineSocket lsok = null;
    private LockObject objLock = new LockObject();
    private boolean blnIsRunning = false;
    private StorageManager smManager = null;
    private Configuration cnf = Configuration.getConfig();
    private Vector vecPolls = null;
    private boolean blnForcePoll = false;

    public POP3_Fetchmail() throws Throwable {
        super("POP3F");
        this.setName("POP3 Fetchmail");
        this.smManager = Configuration.getStorageManager();
        MTAEventQueue.addListener(this);
        this.start();
    }

    private String cmdReceive() throws IOException {
        String strMsg = this.lsok.readln();
        if (strMsg == null) {
            throw new IOException("Got NULL from input stream");
        }
        strMsg = strMsg.toLowerCase().trim();
        Configuration.logContext.write("M I:" + strMsg);
        return HelperFilter.filterBackspace((String)strMsg);
    }

    private void cmdSend(String strMsg) throws IOException {
        Configuration.logContext.write("M O:" + strMsg);
        this.lsok.println(strMsg);
        this.lsok.flush();
    }

    private boolean cmdSendVerify(String str) throws IOException {
        this.cmdSend(str);
        if (!this.cmdReceive().startsWith("+")) {
            try {
                this.cmdSend("QUIT");
            }
            catch (Throwable throwable) {}
            Configuration.logContext.write("? Error on command '" + str + "'");
            return false;
        }
        return true;
    }

    public void dispose() {
        this.blnIsRunning = false;
        Helper.close(this.lsok);
        this.objLock.lo_notify();
        this.objLock.dispose();
        this.objLock = null;
        if (this.smManager != null) {
            this.smManager.dispose();
            this.smManager = null;
        }
        MTAEventQueue.removeListener(this);
    }

    public void mtaEvent(MTAEvent e) {
        if (e instanceof ForceFetchmailEvent) {
            this.blnForcePoll = true;
            this.objLock.lo_notify();
        }
    }

    private void performPoll(FetchmailRecord fm) throws Throwable {
        String strPollHost = fm.getHost();
        if (strPollHost.length() == 0) {
            HostIP[] hip = Helper.getMXHosts(HelperExtract.splitUserName_getDomain((String)fm.getUserFrom()), false);
            if (hip == null) {
                Configuration.logContext.write("? Cannot find a mail host to poll for user " + fm.getUserFrom());
                return;
            }
            strPollHost = hip[0].strHost;
        }
        String strHost = HelperExtract.splitIP_getHost((String)strPollHost);
        int intPort = HelperExtract.splitIP_getPort((String)strPollHost, (int)110);
        InetAddress inaLocal = null;
        if (!this.cnf.strFetchmail_Host.startsWith("*")) {
            inaLocal = InetAddress.getByName(HelperExtract.splitIP_getHost((String)this.cnf.strFetchmail_Host));
        }
        Configuration.logContext.write("# Connecting to " + strHost);
        try {
            Socket sokTmp = new Socket(strHost, intPort, inaLocal, 0);
            sokTmp.setSoTimeout(this.cnf.intFetchmail_Socket_Timeout * 1000);
            Configuration.logContext.write("D Connected to " + strHost + ":" + intPort);
            this.lsok = new LineSocket(sokTmp);
        }
        catch (IOException e) {
            Configuration.logContext.write("D " + strHost + ": " + e.toString());
            return;
        }
        String strBuffer = this.cmdReceive();
        if (!strBuffer.startsWith("+")) {
            Configuration.logContext.write("? Remote service: " + strBuffer);
            return;
        }
        if (!this.cmdSendVerify("USER " + fm.getUserFrom())) {
            return;
        }
        if (!this.cmdSendVerify("PASS " + fm.getPassword())) {
            return;
        }
        this.cmdSend("STAT");
        strBuffer = this.cmdReceive();
        strBuffer = Helper.getArg(strBuffer);
        strBuffer = Helper.getCmd(strBuffer);
        int intUpbMails = Integer.parseInt(strBuffer);
        int i = 0;
        while (i < intUpbMails) {
            if (!this.cmdSendVerify("RETR " + (i + 1))) {
                this.smManager.rollback();
                return;
            }
            long lngTimeStamp = TimeFactory.getTime();
            String strUID_Temp = TimeFactory.createUID();
            Vector<String> vecHeader = new Vector<String>();
            String TAB = new String(new byte[]{9});
            vecHeader.addElement("Fetched: from " + this.lsok.getInetAddress().getHostName() + " [" + this.lsok.getInetAddress().getHostAddress() + "]");
            vecHeader.addElement(String.valueOf(TAB) + "by   " + this.lsok.getLocalAddress().getHostName() + " [" + this.lsok.getLocalAddress().getHostAddress() + "]");
            vecHeader.addElement(String.valueOf(TAB) + "MTA  " + ZeroToaster.getVersion());
            vecHeader.addElement(String.valueOf(TAB) + "at   " + new Date().toString());
            vecHeader.addElement(String.valueOf(TAB) + "id   POP3Fetch-" + strUID_Temp);
            vecHeader.addElement("X-PLACEHOLDER");
            SMTPInputReader siData = new SMTPInputReader(this.lsok.getLineReader(), vecHeader, Configuration.logContext);
            this.smManager.tempWrite(strUID_Temp, siData);
            long lngMailSize = siData.getBytes();
            Vector vecRecipients = Helper.processGroup(fm.getUserTo());
            String strMailTo = Helper.redirectUser(fm.getUserTo(), this.smManager);
            vecRecipients.addElement(strMailTo);
            UserRecord usrReceiver = this.smManager.userRead(strMailTo);
            if (usrReceiver != null) {
                int t = 0;
                while (t < usrReceiver.getCopy().length) {
                    vecRecipients.addElement(usrReceiver.getCopy()[t]);
                    ++t;
                }
            }
            boolean blnAVScan = false;
            MailQueueRecord mqr = new MailQueueRecord(vecRecipients.size());
            int intRecipients = 0;
            while (intRecipients < vecRecipients.size()) {
                strMailTo = (String)vecRecipients.elementAt(intRecipients);
                Configuration.logContext.write("D **1/" + intRecipients + "** strMailTo=" + strMailTo);
                MailHeaderRecord mhr = new MailHeaderRecord();
                DomainRecord domReceiver = this.smManager.domainRead(HelperExtract.splitUserName_getDomain((String)strMailTo));
                Configuration.logContext.write("D **2/" + intRecipients + "** strMailTo=" + strMailTo + " ;domReceiver=" + domReceiver);
                if (domReceiver == null) {
                    mhr.setExternalMail(true);
                } else {
                    blnAVScan |= domReceiver.getAVScan();
                    mhr.setExternalMail(false);
                    usrReceiver = this.smManager.userRead(strMailTo);
                    Configuration.logContext.write("D **3/" + intRecipients + "** strMailTo=" + strMailTo + " ;usrReceiver=" + usrReceiver);
                    if (usrReceiver == null) {
                        strMailTo = domReceiver.getCatchAll();
                        Configuration.logContext.write("D **4/" + intRecipients + "** strMailTo=" + strMailTo + " ;usrReceiver=" + usrReceiver);
                    }
                    if (strMailTo.length() == 0) {
                        UserAlias uaAlias = new UserAlias(this.cnf.strAliases);
                        strMailTo = uaAlias.resolve("postmaster")[0];
                        vecHeader.addElement("X-ZeroToaster-Info:  Fetchmail target address not configured");
                    }
                }
                Configuration.logContext.write("# Created mail for " + strMailTo + (mhr.getExternalMail() ? " (extern)" : " (intern)"));
                mhr.setEnvelopeFrom_Orginal(fm.getUserFrom());
                mhr.setEnvelopeFrom_Redirected(fm.getUserFrom());
                if (mhr.getExternalMail()) {
                    mhr.setEnvelopeFrom_Redirected(fm.getUserTo());
                }
                mhr.addEnvelopeTo_Orginal(fm.getUserTo());
                mhr.addEnvelopeTo_Redirected(strMailTo);
                mhr.setMailSize(lngMailSize);
                mhr.setTimeReceived(lngTimeStamp);
                mhr.setTimeNextRetry(lngTimeStamp);
                mhr.setTimeFetched(0L);
                mhr.setRetryCount(0);
                mhr.setMailDeleted(false);
                mhr.setUID(TimeFactory.createUID());
                mhr.setAccounting(strMailTo);
                mhr.setIsRelayMail(false);
                mhr.setIsHubMail(false);
                this.smManager.accountingStore("F", strMailTo, this.lsok.getBytesReceived(), this.lsok.getBytesSent());
                mqr.vecMHR.addElement(mhr);
                ++intRecipients;
            }
            this.cmdSendVerify("DELE " + (i + 1));
            this.smManager.commit();
            mqr.strUID_Queue = strUID_Temp;
            mqr.strUID_Temp = strUID_Temp;
            mqr.blnAVScan = blnAVScan;
            this.smManager.mailProcessQueueAdd(mqr);
            ++i;
        }
        this.cmdSend("QUIT");
        Configuration.logContext.write("# Finished " + strHost);
    }

    public void run() {
        this.blnIsRunning = true;
        this.vecPolls = new Vector();
        while (this.blnIsRunning) {
            PollRecord pr;
            long lngTime = TimeFactory.getTime();
            int j = 0;
            while (j < this.vecPolls.size()) {
                ((PollRecord)this.vecPolls.elementAt((int)j)).blnTouched = false;
                ++j;
            }
            Configuration.logContext.write("D Re-read configuration");
            Vector vecUser = this.smManager.keyDataReadAll("FETCHMAIL_RECORD", "");
            int i = 0;
            while (i < vecUser.size()) {
                String s = this.smManager.keyDataRead("FETCHMAIL_RECORD", (String)vecUser.elementAt(i), "");
                FetchmailRecord fm = new FetchmailRecord();
                fm.recordImport(s);
                boolean blnFound = false;
                int j2 = 0;
                while (j2 < this.vecPolls.size()) {
                    PollRecord pr2 = (PollRecord)this.vecPolls.elementAt(j2);
                    if (pr2.fm.equals(fm)) {
                        Configuration.logContext.write("D Found record " + pr2.fm.toString());
                        pr2.lngInterval = (long)fm.getPollFrequency() * 1000L;
                        pr2.blnTouched = true;
                        blnFound = true;
                        break;
                    }
                    ++j2;
                }
                if (!blnFound && fm.getPollFrequency() > 0) {
                    Configuration.logContext.write("# Adding record " + fm.toString());
                    PollRecord pr3 = new PollRecord(this);
                    pr3.fm = fm;
                    pr3.lngInterval = (long)fm.getPollFrequency() * 1000L;
                    pr3.lngLastPoll = 0L;
                    pr3.blnTouched = true;
                    this.vecPolls.addElement(pr3);
                }
                ++i;
            }
            i = 0;
            while (i < this.vecPolls.size()) {
                pr = (PollRecord)this.vecPolls.elementAt(i);
                if (!pr.blnTouched) {
                    Configuration.logContext.write("# Removing record " + pr.fm.toString());
                    this.vecPolls.removeElementAt(i);
                    --i;
                } else if (this.blnForcePoll) {
                    pr.lngLastPoll = 0L;
                }
                ++i;
            }
            this.blnForcePoll = false;
            i = 0;
            while (i < this.vecPolls.size()) {
                pr = (PollRecord)this.vecPolls.elementAt(i);
                if (pr.lngLastPoll + pr.lngInterval < lngTime) {
                    try {
                        this.performPoll(pr.fm);
                    }
                    catch (Throwable t) {
                        Configuration.logContext.write("? Exception while processing " + pr.fm.getUserFrom(), t);
                    }
                    Helper.close(this.lsok);
                    this.lsok = null;
                    pr.lngLastPoll = TimeFactory.getTime();
                }
                ++i;
            }
            this.objLock.lo_wait((long)this.cnf.intFetchmail_JobRescan * 1000L);
        }
    }

    class PollRecord {
        /* synthetic */ POP3_Fetchmail this$0;
        FetchmailRecord fm = null;
        long lngInterval = 0L;
        long lngLastPoll = 0L;
        boolean blnTouched = false;

        PollRecord(POP3_Fetchmail this$0) {
            this.this$0 = this$0;
        }
    }
}

